/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.oomph.p2.Configuration;
import org.eclipse.oomph.p2.P2Exception;
import org.eclipse.oomph.p2.P2Factory;
import org.eclipse.oomph.p2.P2Package;
import org.eclipse.oomph.p2.ProfileDefinition;
import org.eclipse.oomph.p2.Repository;
import org.eclipse.oomph.p2.RepositoryList;
import org.eclipse.oomph.p2.RepositoryType;
import org.eclipse.oomph.p2.Requirement;
import org.eclipse.oomph.p2.VersionSegment;
import org.eclipse.oomph.p2.impl.ConfigurationImpl;
import org.eclipse.oomph.p2.impl.ProfileDefinitionImpl;
import org.eclipse.oomph.p2.impl.RepositoryImpl;
import org.eclipse.oomph.p2.impl.RepositoryListImpl;
import org.eclipse.oomph.p2.impl.RequirementImpl;
import org.osgi.framework.Version;

public class P2FactoryImpl
extends EFactoryImpl
implements P2Factory {
    public static P2Factory init() {
        try {
            P2Factory theP2Factory = (P2Factory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/oomph/p2/1.0");
            if (theP2Factory != null) {
                return theP2Factory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new P2FactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createProfileDefinition();
            }
            case 1: {
                return this.createConfiguration();
            }
            case 2: {
                return this.createRequirement();
            }
            case 3: {
                return this.createRepositoryList();
            }
            case 4: {
                return this.createRepository();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 5: {
                return this.createRepositoryTypeFromString(eDataType, initialValue);
            }
            case 6: {
                return this.createVersionSegmentFromString(eDataType, initialValue);
            }
            case 7: {
                return this.createVersionFromString(eDataType, initialValue);
            }
            case 8: {
                return this.createVersionRangeFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 5: {
                return this.convertRepositoryTypeToString(eDataType, instanceValue);
            }
            case 6: {
                return this.convertVersionSegmentToString(eDataType, instanceValue);
            }
            case 7: {
                return this.convertVersionToString(eDataType, instanceValue);
            }
            case 8: {
                return this.convertVersionRangeToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public ProfileDefinition createProfileDefinition() {
        ProfileDefinitionImpl profileDefinition = new ProfileDefinitionImpl();
        return profileDefinition;
    }

    public Configuration createConfiguration() {
        ConfigurationImpl configuration = new ConfigurationImpl();
        return configuration;
    }

    public Requirement createRequirement() {
        RequirementImpl requirement = new RequirementImpl();
        return requirement;
    }

    public Requirement createRequirement(String id) {
        Requirement requirement = this.createRequirement();
        requirement.setName(id);
        return requirement;
    }

    public Requirement createRequirement(String id, VersionRange versionRange) {
        Requirement requirement = this.createRequirement(id);
        requirement.setVersionRange(versionRange);
        return requirement;
    }

    public Requirement createRequirement(String id, VersionRange versionRange, boolean optional) {
        Requirement requirement = this.createRequirement(id, versionRange);
        requirement.setOptional(optional);
        return requirement;
    }

    public RepositoryList createRepositoryList() {
        RepositoryListImpl repositoryList = new RepositoryListImpl();
        return repositoryList;
    }

    public Repository createRepository() {
        RepositoryImpl repository = new RepositoryImpl();
        return repository;
    }

    public Repository createRepository(String url) {
        Repository repository = this.createRepository();
        repository.setURL(url);
        return repository;
    }

    public RepositoryType createRepositoryTypeFromString(EDataType eDataType, String initialValue) {
        RepositoryType result = RepositoryType.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertRepositoryTypeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public VersionSegment createVersionSegmentFromString(EDataType eDataType, String initialValue) {
        VersionSegment result = VersionSegment.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertVersionSegmentToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public org.eclipse.equinox.p2.metadata.Version createVersionFromString(EDataType eDataType, String initialValue) {
        return initialValue == null ? null : org.eclipse.equinox.p2.metadata.Version.create((String)initialValue);
    }

    public String convertVersionToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : ((org.eclipse.equinox.p2.metadata.Version)instanceValue).toString();
    }

    public VersionRange createVersionRange(org.eclipse.equinox.p2.metadata.Version version, VersionSegment segment) {
        return this.createVersionRange(version, segment, false);
    }

    public VersionRange createVersionRange(org.eclipse.equinox.p2.metadata.Version version, VersionSegment segment, boolean compatible) {
        if (version.equals(org.eclipse.equinox.p2.metadata.Version.emptyVersion)) {
            return VersionRange.emptyRange;
        }
        if (segment == null || segment == VersionSegment.QUALIFIER) {
            Comparable firstSegment;
            if (compatible && version.getSegmentCount() != 0 && (firstSegment = version.getSegment(0)) instanceof Integer) {
                Integer major = (Integer)firstSegment;
                return new VersionRange(version, true, org.eclipse.equinox.p2.metadata.Version.createOSGi((int)(major + 1), (int)0, (int)0), false);
            }
            return new VersionRange(version, true, version, true);
        }
        if (!version.isOSGiCompatible()) {
            throw new P2Exception("Version not OSGi-compatible: " + version);
        }
        Version osgiVersion = new Version(version.toString());
        int major = osgiVersion.getMajor();
        int minor = osgiVersion.getMinor();
        int micro = osgiVersion.getMicro();
        switch (segment) {
            case MAJOR: {
                return new VersionRange(org.eclipse.equinox.p2.metadata.Version.createOSGi((int)major, (int)0, (int)0), true, org.eclipse.equinox.p2.metadata.Version.createOSGi((int)(major + 1), (int)0, (int)0), false);
            }
            case MINOR: {
                return new VersionRange(org.eclipse.equinox.p2.metadata.Version.createOSGi((int)major, (int)minor, (int)0), true, compatible ? org.eclipse.equinox.p2.metadata.Version.createOSGi((int)(major + 1), (int)0, (int)0) : org.eclipse.equinox.p2.metadata.Version.createOSGi((int)major, (int)(minor + 1), (int)0), false);
            }
            case MICRO: {
                return new VersionRange(org.eclipse.equinox.p2.metadata.Version.createOSGi((int)major, (int)minor, (int)micro), true, compatible ? org.eclipse.equinox.p2.metadata.Version.createOSGi((int)(major + 1), (int)0, (int)0) : org.eclipse.equinox.p2.metadata.Version.createOSGi((int)major, (int)minor, (int)(micro + 1)), false);
            }
        }
        throw new P2Exception("Invalid segment: " + (Object)((Object)segment));
    }

    public VersionRange createVersionRangeFromString(EDataType eDataType, String initialValue) {
        return initialValue == null ? null : new VersionRange(initialValue);
    }

    public String convertVersionRangeToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : ((VersionRange)instanceValue).toString();
    }

    public P2Package getP2Package() {
        return (P2Package)this.getEPackage();
    }

    @Deprecated
    public static P2Package getPackage() {
        return P2Package.eINSTANCE;
    }
}

