/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.targlets.impl;

import java.util.Collection;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.p2.RepositoryList;
import org.eclipse.oomph.p2.Requirement;
import org.eclipse.oomph.resources.SourceLocator;
import org.eclipse.oomph.targlets.CSpecGenerator;
import org.eclipse.oomph.targlets.CSpexGenerator;
import org.eclipse.oomph.targlets.CategoryGenerator;
import org.eclipse.oomph.targlets.ComponentDefGenerator;
import org.eclipse.oomph.targlets.ComponentDefinition;
import org.eclipse.oomph.targlets.ComponentExtGenerator;
import org.eclipse.oomph.targlets.ComponentExtension;
import org.eclipse.oomph.targlets.FeatureGenerator;
import org.eclipse.oomph.targlets.IUGenerator;
import org.eclipse.oomph.targlets.PluginGenerator;
import org.eclipse.oomph.targlets.ProductGenerator;
import org.eclipse.oomph.targlets.ProjectNameGenerator;
import org.eclipse.oomph.targlets.SiteGenerator;
import org.eclipse.oomph.targlets.Targlet;
import org.eclipse.oomph.targlets.TargletContainer;
import org.eclipse.oomph.targlets.TargletFactory;
import org.eclipse.oomph.targlets.TargletPackage;
import org.eclipse.oomph.targlets.impl.CSpecGeneratorImpl;
import org.eclipse.oomph.targlets.impl.CSpexGeneratorImpl;
import org.eclipse.oomph.targlets.impl.CategoryGeneratorImpl;
import org.eclipse.oomph.targlets.impl.ComponentDefGeneratorImpl;
import org.eclipse.oomph.targlets.impl.ComponentDefinitionImpl;
import org.eclipse.oomph.targlets.impl.ComponentExtGeneratorImpl;
import org.eclipse.oomph.targlets.impl.ComponentExtensionImpl;
import org.eclipse.oomph.targlets.impl.FeatureGeneratorImpl;
import org.eclipse.oomph.targlets.impl.PluginGeneratorImpl;
import org.eclipse.oomph.targlets.impl.ProductGeneratorImpl;
import org.eclipse.oomph.targlets.impl.ProjectNameGeneratorImpl;
import org.eclipse.oomph.targlets.impl.SiteGeneratorImpl;
import org.eclipse.oomph.targlets.impl.TargletContainerImpl;
import org.eclipse.oomph.targlets.impl.TargletImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TargletFactoryImpl
extends EFactoryImpl
implements TargletFactory {
    public static TargletFactory init() {
        try {
            TargletFactory theTargletFactory = (TargletFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/oomph/targlets/1.0");
            if (theTargletFactory != null) {
                return theTargletFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new TargletFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createTargletContainer();
            }
            case 1: {
                return this.createTarglet();
            }
            case 2: {
                return this.createComponentExtension();
            }
            case 3: {
                return this.createComponentDefinition();
            }
            case 5: {
                return this.createFeatureGenerator();
            }
            case 6: {
                return this.createPluginGenerator();
            }
            case 7: {
                return this.createComponentDefGenerator();
            }
            case 8: {
                return this.createComponentExtGenerator();
            }
            case 9: {
                return this.createCSpecGenerator();
            }
            case 10: {
                return this.createCSpexGenerator();
            }
            case 11: {
                return this.createSiteGenerator();
            }
            case 12: {
                return this.createCategoryGenerator();
            }
            case 13: {
                return this.createProductGenerator();
            }
            case 14: {
                return this.createProjectNameGenerator();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        eDataType.getClassifierID();
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        eDataType.getClassifierID();
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public TargletContainer createTargletContainer() {
        TargletContainerImpl targletContainer = new TargletContainerImpl();
        return targletContainer;
    }

    @Override
    public Targlet createTarglet() {
        TargletImpl targlet = new TargletImpl();
        return targlet;
    }

    @Override
    public Targlet createTarglet(String name) {
        Targlet targlet = this.createTarglet();
        targlet.setName(name);
        return targlet;
    }

    @Override
    public Targlet copyTarglet(Targlet source) {
        String activeRepositoryList = source.getActiveRepositoryListName();
        if (activeRepositoryList != null && activeRepositoryList.length() == 0) {
            activeRepositoryList = null;
        }
        Targlet targlet = this.createTarglet();
        targlet.setName(source.getName());
        targlet.setActiveRepositoryListName(activeRepositoryList);
        targlet.setIncludeSources(source.isIncludeSources());
        targlet.setIncludeAllPlatforms(source.isIncludeAllPlatforms());
        targlet.setIncludeAllRequirements(source.isIncludeAllRequirements());
        for (Annotation annotation : source.getAnnotations()) {
            targlet.getAnnotations().add((Object)((Annotation)EcoreUtil.copy((EObject)annotation)));
        }
        for (Requirement requirement : source.getRequirements()) {
            targlet.getRequirements().add((Object)((Requirement)EcoreUtil.copy((EObject)requirement)));
        }
        for (SourceLocator sourceLocator : source.getSourceLocators()) {
            targlet.getSourceLocators().add((Object)((SourceLocator)EcoreUtil.copy((EObject)sourceLocator)));
        }
        for (RepositoryList repositoryList : source.getRepositoryLists()) {
            targlet.getRepositoryLists().add((Object)((RepositoryList)EcoreUtil.copy((EObject)repositoryList)));
        }
        for (IUGenerator iuGenerator : source.getInstallableUnitGenerators()) {
            targlet.getInstallableUnitGenerators().add((Object)((IUGenerator)EcoreUtil.copy((EObject)iuGenerator)));
        }
        return targlet;
    }

    @Override
    public EList<Targlet> copyTarglets(Collection<? extends Targlet> targlets) {
        BasicEList result = new BasicEList();
        for (Targlet targlet : targlets) {
            result.add((Object)this.copyTarglet(targlet));
        }
        return result;
    }

    @Override
    public ComponentExtension createComponentExtension() {
        ComponentExtensionImpl componentExtension = new ComponentExtensionImpl();
        return componentExtension;
    }

    @Override
    public ComponentDefinition createComponentDefinition() {
        ComponentDefinitionImpl componentDefinition = new ComponentDefinitionImpl();
        return componentDefinition;
    }

    @Override
    public FeatureGenerator createFeatureGenerator() {
        FeatureGeneratorImpl featureGenerator = new FeatureGeneratorImpl();
        return featureGenerator;
    }

    @Override
    public PluginGenerator createPluginGenerator() {
        PluginGeneratorImpl pluginGenerator = new PluginGeneratorImpl();
        return pluginGenerator;
    }

    @Override
    public ComponentDefGenerator createComponentDefGenerator() {
        ComponentDefGeneratorImpl componentDefGenerator = new ComponentDefGeneratorImpl();
        return componentDefGenerator;
    }

    @Override
    public ComponentExtGenerator createComponentExtGenerator() {
        ComponentExtGeneratorImpl componentExtGenerator = new ComponentExtGeneratorImpl();
        return componentExtGenerator;
    }

    @Override
    public CSpecGenerator createCSpecGenerator() {
        CSpecGeneratorImpl cSpecGenerator = new CSpecGeneratorImpl();
        return cSpecGenerator;
    }

    @Override
    public CSpexGenerator createCSpexGenerator() {
        CSpexGeneratorImpl cSpexGenerator = new CSpexGeneratorImpl();
        return cSpexGenerator;
    }

    @Override
    public SiteGenerator createSiteGenerator() {
        SiteGeneratorImpl siteGenerator = new SiteGeneratorImpl();
        return siteGenerator;
    }

    @Override
    public CategoryGenerator createCategoryGenerator() {
        CategoryGeneratorImpl categoryGenerator = new CategoryGeneratorImpl();
        return categoryGenerator;
    }

    @Override
    public ProductGenerator createProductGenerator() {
        ProductGeneratorImpl productGenerator = new ProductGeneratorImpl();
        return productGenerator;
    }

    @Override
    public ProjectNameGenerator createProjectNameGenerator() {
        ProjectNameGeneratorImpl projectNameGenerator = new ProjectNameGeneratorImpl();
        return projectNameGenerator;
    }

    @Override
    public TargletPackage getTargletPackage() {
        return (TargletPackage)this.getEPackage();
    }

    @Deprecated
    public static TargletPackage getPackage() {
        return TargletPackage.eINSTANCE;
    }
}

