/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.p2.internal.ui;

import java.io.File;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ItemProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.equinox.p2.metadata.IInstallableUnit;
import org.eclipse.equinox.p2.metadata.VersionRange;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.oomph.base.provider.BaseEditUtil;
import org.eclipse.oomph.p2.P2Factory;
import org.eclipse.oomph.p2.ProfileDefinition;
import org.eclipse.oomph.p2.Requirement;
import org.eclipse.oomph.p2.core.Agent;
import org.eclipse.oomph.p2.core.BundlePool;
import org.eclipse.oomph.p2.core.P2Util;
import org.eclipse.oomph.p2.core.Profile;
import org.eclipse.oomph.p2.internal.ui.AgentManagerComposite;
import org.eclipse.oomph.p2.internal.ui.Messages;
import org.eclipse.oomph.p2.internal.ui.P2UIPlugin;
import org.eclipse.oomph.ui.ToolButton;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.OS;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ProfileDetailsComposite
extends Composite {
    private final ComposedAdapterFactory adapterFactory = BaseEditUtil.createAdapterFactory();
    private final Profile profile;

    public ProfileDetailsComposite(Composite parent, int style, Profile profile) {
        super(parent, style);
        this.profile = profile;
        UIUtil.setTransparentBackgroundColor((Control)this);
        GridLayout gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        this.setLayout((Layout)gridLayout);
        Agent agent = profile.getAgent();
        BundlePool bundlePool = profile.getBundlePool();
        this.addHeaderRow(Messages.ProfileDetailsComposite_headerRow_profile, profile.getLocation(), profile.getProfileId()).selectAll();
        this.addHeaderRow(Messages.ProfileDetailsComposite_headerRow_agent, agent.getLocation(), null);
        this.addHeaderRow(Messages.ProfileDetailsComposite_headerRow_bundlePool, bundlePool == null ? null : bundlePool.getLocation(), null);
        this.addHeaderRow(Messages.ProfileDetailsComposite_headerRow_installation, profile.getInstallFolder(), null);
        new Label((Composite)this, 0);
        new Label((Composite)this, 0);
        new Label((Composite)this, 0);
        TabFolder tabFolder = new TabFolder((Composite)this, 0);
        tabFolder.setLayoutData((Object)new GridData(4, 4, true, true, 3, 1));
        this.createDefinitionTab(tabFolder);
        this.createInstalledUnitsTab(tabFolder);
        this.createPropertiesTab(tabFolder);
    }

    public final Profile getProfile() {
        return this.profile;
    }

    public void dispose() {
        this.adapterFactory.dispose();
        super.dispose();
    }

    private Text addHeaderRow(String name, final File location, String value) {
        Label label = new Label((Composite)this, 0);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        label.setText(String.valueOf(name) + ":");
        Text text = new Text((Composite)this, 2056);
        text.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        text.setBackground(this.getDisplay().getSystemColor(25));
        if (value != null) {
            text.setText(value);
        } else if (location != null) {
            text.setText(location.getAbsolutePath());
        }
        ToolButton button = new ToolButton((Composite)this, 8, P2UIPlugin.INSTANCE.getSWTImage("obj16/folder"), false);
        button.setToolTipText(NLS.bind((String)Messages.ProfileDetailsComposite_openFolder, (Object)name.toLowerCase()));
        button.setEnabled(location != null && location.isDirectory());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                OS.INSTANCE.openSystemBrowser(location.toURI().toString());
            }
        });
        return text;
    }

    private void createDefinitionTab(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(Messages.ProfileDetailsComposite_tab_definition);
        final TreeViewer viewer = new TreeViewer((Composite)tabFolder, 0);
        viewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
        viewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory));
        tabItem.setControl((Control)viewer.getTree());
        AgentManagerComposite.addDragSupport((StructuredViewer)viewer);
        UIUtil.asyncExec((Runnable)new Runnable(){

            public void run() {
                ProfileDefinition definition = ProfileDetailsComposite.this.profile.getDefinition();
                ItemProvider requirements = new ItemProvider((AdapterFactory)ProfileDetailsComposite.this.adapterFactory, Messages.ProfileDetailsComposite_tab_definition_requirements, (Object)P2UIPlugin.INSTANCE.getSWTImage("full/obj16/ProfileDefinition"), (Collection)definition.getRequirements());
                ItemProvider repositories = new ItemProvider((AdapterFactory)ProfileDetailsComposite.this.adapterFactory, Messages.ProfileDetailsComposite_tab_definition_repositories, (Object)P2UIPlugin.INSTANCE.getSWTImage("full/obj16/RepositoryList"), (Collection)definition.getRepositories());
                ItemProvider input = new ItemProvider((AdapterFactory)ProfileDetailsComposite.this.adapterFactory);
                input.getChildren().add((Object)requirements);
                input.getChildren().add((Object)repositories);
                viewer.setInput((Object)input);
                viewer.expandAll();
            }
        });
    }

    private void createInstalledUnitsTab(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(Messages.ProfileDetailsComposite_tab_installedUnits);
        TableColumnLayout layout = new TableColumnLayout();
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)layout);
        tabItem.setControl((Control)composite);
        final TableViewer viewer = new TableViewer(composite, 0x10000000);
        viewer.setContentProvider((IContentProvider)new AdapterFactoryContentProvider((AdapterFactory)this.adapterFactory));
        viewer.setLabelProvider((IBaseLabelProvider)new AdapterFactoryLabelProvider((AdapterFactory)this.adapterFactory));
        Table table = viewer.getTable();
        TableColumn idColumn = new TableColumn(table, 16384);
        layout.setColumnData((Widget)idColumn, (ColumnLayoutData)new ColumnWeightData(100));
        AgentManagerComposite.addDragSupport((StructuredViewer)viewer);
        UIUtil.asyncExec((Control)viewer.getControl(), (Runnable)new Runnable(){

            public void run() {
                BasicEList children = new BasicEList();
                for (IInstallableUnit iu : P2Util.asIterable((IQueryResult)ProfileDetailsComposite.this.profile.query(QueryUtil.createIUAnyQuery(), null))) {
                    String id = iu.getId();
                    VersionRange versionRange = new VersionRange(iu.getVersion().toString());
                    Requirement requirement = P2Factory.eINSTANCE.createRequirement(id, versionRange);
                    requirement.setMatchExpression(iu.getFilter());
                    children.add((Object)requirement);
                }
                ECollections.sort((EList)children, (Comparator)Requirement.COMPARATOR);
                ItemProvider input = new ItemProvider((AdapterFactory)ProfileDetailsComposite.this.adapterFactory, (Collection)children);
                viewer.setInput((Object)input);
            }
        });
    }

    private void createPropertiesTab(TabFolder tabFolder) {
        TabItem tabItem = new TabItem(tabFolder, 0);
        tabItem.setText(Messages.ProfileDetailsComposite_tab_properties);
        TableColumnLayout layout = new TableColumnLayout();
        Composite composite = new Composite((Composite)tabFolder, 0);
        composite.setLayout((Layout)layout);
        tabItem.setControl((Control)composite);
        final TableViewer viewer = new TableViewer(composite, 0x10010000);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new PropertiesLabelProvider());
        Table table = viewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn keyColumn = new TableColumn(table, 16384);
        keyColumn.setText(Messages.ProfileDetailsComposite_tab_properties_key);
        layout.setColumnData((Widget)keyColumn, (ColumnLayoutData)new ColumnWeightData(40));
        TableColumn valueColumn = new TableColumn(table, 16384);
        valueColumn.setText(Messages.ProfileDetailsComposite_tab_properties_value);
        layout.setColumnData((Widget)valueColumn, (ColumnLayoutData)new ColumnWeightData(60));
        UIUtil.asyncExec((Control)viewer.getControl(), (Runnable)new Runnable(){

            public void run() {
                viewer.setInput(ProfileDetailsComposite.this.profile.getProperties().entrySet());
            }
        });
    }

    private static final class PropertiesLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private PropertiesLabelProvider() {
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof Map.Entry) {
                Object value;
                Map.Entry entry = (Map.Entry)element;
                if (columnIndex == 0) {
                    Object key = entry.getKey();
                    if (key instanceof String) {
                        return (String)key;
                    }
                } else if (columnIndex == 1 && (value = entry.getValue()) instanceof String) {
                    return (String)value;
                }
            }
            return null;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }
    }
}

