/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.ClasspathContainerInitializer;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IClasspathAttribute;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.AccessRulesDialog;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ArchiveFileFilter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.BuildPathSupport;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementAttribute;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElementSorter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListLabelProvider;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPUserLibraryElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ClasspathAttributeConfigurationDescriptors;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.SourceAttachmentBlock;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.CheckedListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ITreeListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.TreeListDialogField;
import org.eclipse.jdt.ui.wizards.BuildPathDialogAccess;
import org.eclipse.jdt.ui.wizards.ClasspathAttributeConfiguration;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.util.BidiUtils;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UserLibraryPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.eclipse.jdt.ui.preferences.UserLibraryPreferencePage";
    public static final String DATA_DO_CREATE = "do_create";
    public static final String DATA_LIBRARY_TO_SELECT = "select_library";
    private IWorkbench fWorkbench;
    private IDialogSettings fDialogSettings;
    private TreeListDialogField<CPUserLibraryElement> fLibraryList;
    private IJavaProject fDummyProject;
    private ClasspathAttributeConfigurationDescriptors fAttributeDescriptors;
    private static final int IDX_NEW = 0;
    private static final int IDX_EDIT = 1;
    private static final int IDX_ADD = 2;
    private static final int IDX_ADD_EXTERNAL = 3;
    private static final int IDX_REMOVE = 4;
    private static final int IDX_UP = 6;
    private static final int IDX_DOWN = 7;
    private static final int IDX_LOAD = 9;
    private static final int IDX_SAVE = 10;

    public UserLibraryPreferencePage() {
        this.setPreferenceStore(JavaPlugin.getDefault().getPreferenceStore());
        this.fDummyProject = UserLibraryPreferencePage.createPlaceholderProject();
        this.fAttributeDescriptors = JavaPlugin.getDefault().getClasspathAttributeConfigurationDescriptors();
        this.setTitle(PreferencesMessages.UserLibraryPreferencePage_title);
        this.setDescription(PreferencesMessages.UserLibraryPreferencePage_description);
        this.noDefaultAndApplyButton();
        this.fDialogSettings = JavaPlugin.getDefault().getDialogSettings();
        UserLibraryAdapter adapter = new UserLibraryAdapter();
        String[] stringArray = new String[11];
        stringArray[0] = PreferencesMessages.UserLibraryPreferencePage_libraries_new_button;
        stringArray[1] = PreferencesMessages.UserLibraryPreferencePage_libraries_edit_button;
        stringArray[2] = PreferencesMessages.UserLibraryPreferencePage_libraries_addjar_button;
        stringArray[3] = PreferencesMessages.UserLibraryPreferencePage_libraries_addexternaljar_button;
        stringArray[4] = PreferencesMessages.UserLibraryPreferencePage_libraries_remove_button;
        stringArray[6] = PreferencesMessages.UserLibraryPreferencePage_UserLibraryPreferencePage_libraries_up_button;
        stringArray[7] = PreferencesMessages.UserLibraryPreferencePage_UserLibraryPreferencePage_libraries_down_button;
        stringArray[9] = PreferencesMessages.UserLibraryPreferencePage_libraries_load_button;
        stringArray[10] = PreferencesMessages.UserLibraryPreferencePage_libraries_save_button;
        String[] buttonLabels = stringArray;
        this.fLibraryList = new TreeListDialogField<CPUserLibraryElement>(adapter, buttonLabels, (ILabelProvider)new CPListLabelProvider());
        this.fLibraryList.setLabelText(PreferencesMessages.UserLibraryPreferencePage_libraries_label);
        String[] names = JavaCore.getUserLibraryNames();
        ArrayList<CPUserLibraryElement> elements = new ArrayList<CPUserLibraryElement>();
        int i = 0;
        while (i < names.length) {
            IPath path = new Path("org.eclipse.jdt.USER_LIBRARY").append(names[i]);
            try {
                IClasspathContainer container = JavaCore.getClasspathContainer((IPath)path, (IJavaProject)this.fDummyProject);
                elements.add(new CPUserLibraryElement(names[i], container, this.fDummyProject));
            }
            catch (JavaModelException e) {
                JavaPlugin.log(e);
            }
            ++i;
        }
        this.fLibraryList.setElements(elements);
        this.fLibraryList.setViewerComparator(new CPListElementSorter());
        this.doSelectionChanged(this.fLibraryList);
    }

    private static IJavaProject createPlaceholderProject() {
        String name = "####internal";
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project;
        while ((project = root.getProject(name)).exists()) {
            name = String.valueOf(name) + '1';
        }
        return JavaCore.create((IProject)project);
    }

    public void applyData(Object data) {
        if (data instanceof Map) {
            Map map = (Map)data;
            Object selectedLibrary = map.get(DATA_LIBRARY_TO_SELECT);
            boolean createIfNotExists = Boolean.TRUE.equals(map.get(DATA_DO_CREATE));
            if (selectedLibrary instanceof String) {
                int nElements = this.fLibraryList.getSize();
                int i = 0;
                while (i < nElements) {
                    CPUserLibraryElement curr = this.fLibraryList.getElement(i);
                    if (curr.getName().equals(selectedLibrary)) {
                        this.fLibraryList.selectElements((ISelection)new StructuredSelection((Object)curr));
                        this.fLibraryList.expandElement(curr, 1);
                        break;
                    }
                    ++i;
                }
                if (createIfNotExists) {
                    CPUserLibraryElement elem = new CPUserLibraryElement((String)selectedLibrary, null, UserLibraryPreferencePage.createPlaceholderProject());
                    this.fLibraryList.addElement(elem);
                    this.fLibraryList.selectElements((ISelection)new StructuredSelection((Object)elem));
                }
            }
        }
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.jdt.ui.cp_userlibraries_preference_page_context");
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        LayoutUtil.doDefaultLayout(composite, new DialogField[]{this.fLibraryList}, true);
        LayoutUtil.setHorizontalGrabbing(this.fLibraryList.getTreeControl(null));
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    public void init(IWorkbench workbench) {
        this.fWorkbench = workbench;
    }

    protected void performDefaults() {
        super.performDefaults();
    }

    public boolean performOk() {
        try {
            PlatformUI.getWorkbench().getProgressService().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        try {
                            if (monitor != null) {
                                monitor = new NullProgressMonitor();
                            }
                            UserLibraryPreferencePage.this.updateUserLibararies(monitor);
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
        }
        catch (InvocationTargetException e) {
            String title = PreferencesMessages.UserLibraryPreferencePage_config_error_title;
            String message = PreferencesMessages.UserLibraryPreferencePage_config_error_message;
            ExceptionHandler.handle(e, this.getShell(), title, message);
        }
        return true;
    }

    private void updateUserLibararies(IProgressMonitor monitor) throws CoreException {
        IPath path;
        List<CPUserLibraryElement> list = this.fLibraryList.getElements();
        HashSet<String> oldNames = new HashSet<String>(Arrays.asList(JavaCore.getUserLibraryNames()));
        int nExisting = list.size();
        HashSet<CPUserLibraryElement> newEntries = new HashSet<CPUserLibraryElement>(list.size());
        int i = 0;
        while (i < nExisting) {
            CPUserLibraryElement element = list.get(i);
            boolean contained = oldNames.remove(element.getName());
            if (!contained) {
                newEntries.add(element);
            }
            ++i;
        }
        int len = nExisting + oldNames.size();
        monitor.beginTask(PreferencesMessages.UserLibraryPreferencePage_operation, len);
        MultiStatus multiStatus = new MultiStatus("org.eclipse.jdt.ui", 0, PreferencesMessages.UserLibraryPreferencePage_operation_error, null);
        ClasspathContainerInitializer initializer = JavaCore.getClasspathContainerInitializer((String)"org.eclipse.jdt.USER_LIBRARY");
        IJavaProject jproject = this.fDummyProject;
        int i2 = 0;
        while (i2 < nExisting) {
            CPUserLibraryElement element = list.get(i2);
            path = element.getPath();
            if (newEntries.contains(element) || element.hasChanges(JavaCore.getClasspathContainer((IPath)path, (IJavaProject)jproject))) {
                IClasspathContainer updatedContainer = element.getUpdatedContainer();
                try {
                    initializer.requestClasspathContainerUpdate(path, jproject, updatedContainer);
                }
                catch (CoreException e) {
                    multiStatus.add(e.getStatus());
                }
            }
            monitor.worked(1);
            ++i2;
        }
        for (String name : oldNames) {
            path = new Path("org.eclipse.jdt.USER_LIBRARY").append(name);
            try {
                initializer.requestClasspathContainerUpdate(path, jproject, null);
            }
            catch (CoreException e) {
                multiStatus.add(e.getStatus());
            }
            monitor.worked(1);
        }
        if (!multiStatus.isOK()) {
            throw new CoreException((IStatus)multiStatus);
        }
    }

    private CPUserLibraryElement getSingleSelectedLibrary(List<Object> selected) {
        if (selected.size() == 1 && selected.get(0) instanceof CPUserLibraryElement) {
            return (CPUserLibraryElement)selected.get(0);
        }
        return null;
    }

    private void editAttributeEntry(CPListElementAttribute elem) {
        IClasspathAttribute result;
        ClasspathAttributeConfiguration config;
        String key = elem.getKey();
        CPListElement selElement = elem.getParent();
        Object parentContainer = selElement.getParentContainer();
        CPListElementAttribute[] allAttributes = selElement.getAllAttributes();
        boolean canEditEncoding = false;
        int i = 0;
        while (i < allAttributes.length) {
            if ("source_encoding".equals(allAttributes[i].getKey())) {
                canEditEncoding = !allAttributes[i].isNonModifiable() && !allAttributes[i].isNotSupported();
            }
            ++i;
        }
        if (key.equals("sourcepath")) {
            IClasspathEntry result2 = BuildPathDialogAccess.configureSourceAttachment(this.getShell(), selElement.getClasspathEntry(), canEditEncoding);
            if (result2 != null) {
                selElement.setAttribute("sourcepath", result2.getSourceAttachmentPath());
                selElement.setAttribute("source_encoding", SourceAttachmentBlock.getSourceAttachmentEncoding(result2));
                this.fLibraryList.refresh(parentContainer);
                this.fLibraryList.update(selElement);
            }
        } else if (key.equals("accessrules")) {
            AccessRulesDialog dialog = new AccessRulesDialog(this.getShell(), selElement, null, false);
            if (dialog.open() == 0) {
                selElement.setAttribute("accessrules", dialog.getAccessRules());
                this.fLibraryList.refresh(parentContainer);
                this.fLibraryList.expandElement(elem, 2);
            }
        } else if (!elem.isBuiltIn() && (config = this.fAttributeDescriptors.get(key)) != null && (result = config.performEdit(this.getShell(), elem.getClasspathAttributeAccess())) != null) {
            elem.setValue(result.getValue());
            this.fLibraryList.refresh(parentContainer);
        }
    }

    protected void doSelectionChanged(TreeListDialogField<CPUserLibraryElement> field) {
        List<Object> list = field.getSelectedElements();
        field.enableButton(4, this.canRemove(list));
        field.enableButton(1, this.canEdit(list));
        field.enableButton(2, this.canAdd(list));
        field.enableButton(3, this.canAdd(list));
        field.enableButton(6, this.canMoveUp(list));
        field.enableButton(7, this.canMoveDown(list));
        field.enableButton(10, field.getSize() > 0);
    }

    protected void doCustomButtonPressed(TreeListDialogField<CPUserLibraryElement> field, int index) {
        if (index == 0) {
            this.editUserLibraryElement(null);
        } else if (index == 2) {
            this.doAdd(field.getSelectedElements());
        } else if (index == 3) {
            this.doAddExternal(field.getSelectedElements());
        } else if (index == 4) {
            this.doRemove(field.getSelectedElements());
        } else if (index == 1) {
            this.doEdit(field.getSelectedElements());
        } else if (index == 10) {
            this.doSave();
        } else if (index == 9) {
            this.doLoad();
        } else if (index == 6) {
            this.doMoveUp(field.getSelectedElements());
        } else if (index == 7) {
            this.doMoveDown(field.getSelectedElements());
        }
    }

    protected void doDoubleClicked(TreeListDialogField<CPUserLibraryElement> field) {
        List<Object> selected = field.getSelectedElements();
        if (this.canEdit(selected)) {
            this.doEdit(field.getSelectedElements());
        }
    }

    protected void doKeyPressed(TreeListDialogField<CPUserLibraryElement> field, KeyEvent event) {
        List<Object> selection;
        if (event.character == '\u007f' && event.stateMask == 0 && this.canRemove(selection = field.getSelectedElements())) {
            this.doRemove(selection);
        }
    }

    private void doEdit(List<Object> selected) {
        if (selected.size() == 1) {
            Object curr = selected.get(0);
            if (curr instanceof CPListElementAttribute) {
                this.editAttributeEntry((CPListElementAttribute)curr);
            } else if (curr instanceof CPUserLibraryElement) {
                this.editUserLibraryElement((CPUserLibraryElement)curr);
            } else if (curr instanceof CPListElement) {
                CPListElement elem = (CPListElement)curr;
                this.editArchiveElement(elem, (CPUserLibraryElement)elem.getParentContainer());
            }
            this.doSelectionChanged(this.fLibraryList);
        }
    }

    private void editUserLibraryElement(CPUserLibraryElement element) {
        LibraryNameDialog dialog = new LibraryNameDialog(this.getShell(), element, this.fLibraryList.getElements());
        if (dialog.open() == 0) {
            CPUserLibraryElement newLibrary = dialog.getNewLibrary();
            if (element != null) {
                this.fLibraryList.replaceElement(element, newLibrary);
            } else {
                this.fLibraryList.addElement(newLibrary);
            }
            this.fLibraryList.expandElement(newLibrary, -1);
            this.fLibraryList.selectElements((ISelection)new StructuredSelection((Object)newLibrary));
        }
    }

    private void editArchiveElement(CPListElement existingElement, CPUserLibraryElement parent) {
        CPListElement[] elements = this.openJarFileDialog(existingElement, parent);
        if (elements != null) {
            int i = 0;
            while (i < elements.length) {
                if (existingElement != null) {
                    parent.replace(existingElement, elements[i]);
                } else {
                    parent.add(elements[i]);
                }
                ++i;
            }
            this.fLibraryList.refresh(parent);
            this.fLibraryList.selectElements((ISelection)new StructuredSelection(Arrays.asList(elements)));
            this.fLibraryList.expandElement(parent, 2);
        }
    }

    private void doRemove(List<Object> selected) {
        Object selectionAfter = null;
        int i = 0;
        while (i < selected.size()) {
            Object curr = selected.get(i);
            if (curr instanceof CPUserLibraryElement) {
                this.fLibraryList.removeElement((CPUserLibraryElement)curr);
            } else if (curr instanceof CPListElement) {
                Object parent = ((CPListElement)curr).getParentContainer();
                if (parent instanceof CPUserLibraryElement) {
                    CPUserLibraryElement elem = (CPUserLibraryElement)parent;
                    elem.remove((CPListElement)curr);
                    this.fLibraryList.refresh(elem);
                    selectionAfter = parent;
                }
            } else if (curr instanceof CPListElementAttribute) {
                CPListElementAttribute attrib = (CPListElementAttribute)curr;
                Object parentContainer = attrib.getParent().getParentContainer();
                if (attrib.isBuiltIn()) {
                    IAccessRule[] value = null;
                    String key = attrib.getKey();
                    if (key.equals("accessrules")) {
                        value = new IAccessRule[]{};
                    }
                    attrib.getParent().setAttribute(key, value);
                    this.fLibraryList.refresh(parentContainer);
                } else {
                    IClasspathAttribute result;
                    ClasspathAttributeConfiguration config = this.fAttributeDescriptors.get(attrib.getKey());
                    if (config != null && (result = config.performRemove(attrib.getClasspathAttributeAccess())) != null) {
                        attrib.setValue(result.getValue());
                        this.fLibraryList.refresh(parentContainer);
                    }
                }
            }
            ++i;
        }
        if (this.fLibraryList.getSelectedElements().isEmpty()) {
            if (selectionAfter != null) {
                this.fLibraryList.selectElements((ISelection)new StructuredSelection(selectionAfter));
            } else {
                this.fLibraryList.selectFirstElement();
            }
        } else {
            this.doSelectionChanged(this.fLibraryList);
        }
    }

    private void doAdd(List<Object> list) {
        if (this.canAdd(list)) {
            CPUserLibraryElement parentLibrary = this.getSingleSelectedLibrary(list);
            IPath selection = this.getWorkbenchWindowSelection();
            IPath[] selectedPaths = BuildPathDialogAccess.chooseJAREntries(this.getShell(), selection, new IPath[0]);
            if (selectedPaths != null) {
                ArrayList<CPListElement> elements = new ArrayList<CPListElement>();
                int i = 0;
                while (i < selectedPaths.length) {
                    CPListElement cpElement = new CPListElement(parentLibrary, this.fDummyProject, 1, selectedPaths[i], null);
                    cpElement.setAttribute("sourcepath", BuildPathSupport.guessSourceAttachment(cpElement));
                    cpElement.setAttribute("javadoc_location", BuildPathSupport.guessJavadocLocation(cpElement));
                    elements.add(cpElement);
                    parentLibrary.add(cpElement);
                    ++i;
                }
                this.fLibraryList.refresh(parentLibrary);
                this.fLibraryList.selectElements((ISelection)new StructuredSelection(elements));
                this.fLibraryList.expandElement(parentLibrary, 2);
            }
        }
    }

    private IPath getWorkbenchWindowSelection() {
        IStructuredSelection structuredSelection;
        Object element;
        ISelection selection;
        IWorkbenchWindow window = this.fWorkbench.getActiveWorkbenchWindow();
        if (window != null && (selection = window.getSelectionService().getSelection()) instanceof IStructuredSelection && (element = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) != null) {
            Object resource = Platform.getAdapterManager().getAdapter(element, IResource.class);
            if (resource != null) {
                return ((IResource)resource).getFullPath();
            }
            if (structuredSelection instanceof ITreeSelection) {
                TreePath treePath = ((ITreeSelection)structuredSelection).getPaths()[0];
                while ((treePath = treePath.getParentPath()) != null) {
                    element = treePath.getLastSegment();
                    resource = Platform.getAdapterManager().getAdapter(element, IResource.class);
                    if (resource == null) continue;
                    return ((IResource)resource).getFullPath();
                }
            }
        }
        return null;
    }

    private void doAddExternal(List<Object> list) {
        if (this.canAdd(list)) {
            CPUserLibraryElement element = this.getSingleSelectedLibrary(list);
            this.editArchiveElement(null, element);
        }
    }

    private void doLoad() {
        List<CPUserLibraryElement> existing = this.fLibraryList.getElements();
        LoadSaveDialog dialog = new LoadSaveDialog(this.getShell(), false, existing, this.fDialogSettings);
        if (dialog.open() == 0) {
            HashMap<String, CPUserLibraryElement> map = new HashMap<String, CPUserLibraryElement>(existing.size());
            int k = 0;
            while (k < existing.size()) {
                CPUserLibraryElement elem = existing.get(k);
                map.put(elem.getName(), elem);
                ++k;
            }
            List<CPUserLibraryElement> list = dialog.getLoadedLibraries();
            int i = 0;
            while (i < list.size()) {
                CPUserLibraryElement elem = list.get(i);
                CPUserLibraryElement found = (CPUserLibraryElement)map.get(elem.getName());
                if (found == null) {
                    existing.add(elem);
                    map.put(elem.getName(), elem);
                } else {
                    existing.set(existing.indexOf(found), elem);
                }
                ++i;
            }
            this.fLibraryList.setElements(existing);
            this.fLibraryList.selectElements((ISelection)new StructuredSelection(list));
        }
    }

    private void doSave() {
        LoadSaveDialog dialog = new LoadSaveDialog(this.getShell(), true, this.fLibraryList.getElements(), this.fDialogSettings);
        dialog.open();
    }

    private boolean canAdd(List<Object> list) {
        return this.getSingleSelectedLibrary(list) != null;
    }

    private boolean canEdit(List<Object> list) {
        CPListElementAttribute attrib;
        if (list.size() != 1) {
            return false;
        }
        Object firstElement = list.get(0);
        if (firstElement instanceof IAccessRule) {
            return false;
        }
        if (firstElement instanceof CPListElementAttribute && !(attrib = (CPListElementAttribute)firstElement).isBuiltIn()) {
            ClasspathAttributeConfiguration config = this.fAttributeDescriptors.get(attrib.getKey());
            return config != null && config.canEdit(attrib.getClasspathAttributeAccess());
        }
        return true;
    }

    private boolean canRemove(List<Object> list) {
        if (list.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < list.size()) {
            Object elem = list.get(i);
            if (elem instanceof CPListElementAttribute) {
                CPListElementAttribute attrib = (CPListElementAttribute)elem;
                if (attrib.isNonModifiable()) {
                    return false;
                }
                if (attrib.isBuiltIn()) {
                    if (attrib.getKey().equals("accessrules")) {
                        return ((IAccessRule[])attrib.getValue()).length > 0;
                    }
                    if (attrib.getValue() == null) {
                        return false;
                    }
                } else {
                    ClasspathAttributeConfiguration config = this.fAttributeDescriptors.get(attrib.getKey());
                    if (config == null || !config.canRemove(attrib.getClasspathAttributeAccess())) {
                        return false;
                    }
                }
            } else if (!(elem instanceof CPListElement) && !(elem instanceof CPUserLibraryElement)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private CPUserLibraryElement getCommonParent(List<?> list) {
        CPUserLibraryElement parent = null;
        int i = 0;
        int len = list.size();
        while (i < len) {
            Object curr = list.get(i);
            if (!(curr instanceof CPListElement)) return null;
            Object elemParent = ((CPListElement)curr).getParentContainer();
            if (parent == null) {
                if (!(elemParent instanceof CPUserLibraryElement)) return null;
                parent = (CPUserLibraryElement)elemParent;
            } else if (parent != elemParent) {
                return null;
            }
            ++i;
        }
        return parent;
    }

    private void doMoveUp(List<?> list) {
        CPUserLibraryElement parent = this.getCommonParent(list);
        if (parent != null) {
            List<CPListElement> cpElementList = list;
            parent.moveUp(cpElementList);
            this.fLibraryList.refresh(parent);
            this.doSelectionChanged(this.fLibraryList);
        }
    }

    private void doMoveDown(List<?> list) {
        CPUserLibraryElement parent = this.getCommonParent(list);
        if (parent != null) {
            List<CPListElement> cpElementList = list;
            parent.moveDown(cpElementList);
            this.fLibraryList.refresh(parent);
            this.doSelectionChanged(this.fLibraryList);
        }
    }

    private boolean canMoveUp(List<?> list) {
        CPUserLibraryElement parent = this.getCommonParent(list);
        if (parent != null) {
            CPListElement[] children = parent.getChildren();
            int i = 0;
            int len = Math.min(list.size(), children.length);
            while (i < len) {
                if (!list.contains(children[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean canMoveDown(List<?> list) {
        CPUserLibraryElement parent = this.getCommonParent(list);
        if (parent != null) {
            CPListElement[] children = parent.getChildren();
            int i = children.length - 1;
            int end = Math.max(0, children.length - list.size());
            while (i >= end) {
                if (!list.contains(children[i])) {
                    return true;
                }
                --i;
            }
        }
        return false;
    }

    private CPListElement[] openJarFileDialog(CPListElement existing, Object parent) {
        IPath path;
        if (existing == null) {
            return this.doOpenExternalJarFileDialog(existing, parent);
        }
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        if (root.exists(path = existing.getPath())) {
            return this.doOpenInternalJarFileDialog(existing, parent);
        }
        return this.doOpenExternalJarFileDialog(existing, parent);
    }

    private CPListElement[] doOpenInternalJarFileDialog(CPListElement existing, Object parent) {
        IPath path = existing.getPath();
        IPath[] selectedPaths = BuildPathDialogAccess.chooseJAREntries(this.getShell(), path, new IPath[0]);
        if (selectedPaths != null) {
            ArrayList<CPListElement> elements = new ArrayList<CPListElement>();
            int i = 0;
            while (i < selectedPaths.length) {
                CPListElement cpElement = new CPListElement(parent, this.fDummyProject, 1, selectedPaths[i], null);
                cpElement.setAttribute("sourcepath", BuildPathSupport.guessSourceAttachment(cpElement));
                cpElement.setAttribute("javadoc_location", BuildPathSupport.guessJavadocLocation(cpElement));
                elements.add(cpElement);
                ++i;
            }
            return elements.toArray(new CPListElement[0]);
        }
        return null;
    }

    private CPListElement[] doOpenExternalJarFileDialog(CPListElement existing, Object parent) {
        String res;
        String lastUsedPath;
        if (existing != null) {
            lastUsedPath = existing.getPath().removeLastSegments(1).toOSString();
        } else {
            lastUsedPath = this.fDialogSettings.get("org.eclipse.jdt.ui.lastextjar");
            if (lastUsedPath == null) {
                lastUsedPath = "";
            }
        }
        String title = existing == null ? PreferencesMessages.UserLibraryPreferencePage_browsejar_new_title : PreferencesMessages.UserLibraryPreferencePage_browsejar_edit_title;
        FileDialog dialog = new FileDialog(this.getShell(), existing == null ? 2 : 4);
        dialog.setText(title);
        dialog.setFilterExtensions(ArchiveFileFilter.ALL_ARCHIVES_FILTER_EXTENSIONS);
        dialog.setFilterPath(lastUsedPath);
        if (existing != null) {
            dialog.setFileName(existing.getPath().lastSegment());
        }
        if ((res = dialog.open()) == null) {
            return null;
        }
        String[] fileNames = dialog.getFileNames();
        int nChosen = fileNames.length;
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IPath filterPath = Path.fromOSString((String)dialog.getFilterPath());
        CPListElement[] elems = new CPListElement[nChosen];
        int i = 0;
        while (i < nChosen) {
            IPath path = filterPath.append(fileNames[i]).makeAbsolute();
            IFile file = root.getFileForLocation(path);
            if (file != null) {
                path = file.getFullPath();
            }
            CPListElement curr = new CPListElement(parent, null, 1, path, (IResource)file);
            curr.setAttribute("sourcepath", BuildPathSupport.guessSourceAttachment(curr));
            curr.setAttribute("javadoc_location", BuildPathSupport.guessJavadocLocation(curr));
            elems[i] = curr;
            ++i;
        }
        this.fDialogSettings.put("org.eclipse.jdt.ui.lastextjar", dialog.getFilterPath());
        return elems;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LibraryNameDialog
    extends StatusDialog
    implements IDialogFieldListener {
        private StringDialogField fNameField;
        private SelectionButtonDialogField fIsSystemField;
        private CPUserLibraryElement fElementToEdit;
        private List<CPUserLibraryElement> fExistingLibraries;

        public LibraryNameDialog(Shell parent, CPUserLibraryElement elementToEdit, List<CPUserLibraryElement> existingLibraries) {
            super(parent);
            if (elementToEdit == null) {
                this.setTitle(PreferencesMessages.UserLibraryPreferencePage_LibraryNameDialog_new_title);
            } else {
                this.setTitle(PreferencesMessages.UserLibraryPreferencePage_LibraryNameDialog_edit_title);
            }
            this.fElementToEdit = elementToEdit;
            this.fExistingLibraries = existingLibraries;
            this.fNameField = new StringDialogField();
            this.fNameField.setDialogFieldListener(this);
            this.fNameField.setLabelText(PreferencesMessages.UserLibraryPreferencePage_LibraryNameDialog_name_label);
            this.fIsSystemField = new SelectionButtonDialogField(32);
            this.fIsSystemField.setLabelText(PreferencesMessages.UserLibraryPreferencePage_LibraryNameDialog_issystem_label);
            if (elementToEdit != null) {
                this.fNameField.setText(elementToEdit.getName());
                this.fIsSystemField.setSelection(elementToEdit.isSystemLibrary());
            } else {
                this.fNameField.setText("");
                this.fIsSystemField.setSelection(false);
            }
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            LayoutUtil.doDefaultLayout(composite, new DialogField[]{this.fNameField, this.fIsSystemField}, true, -1, -1);
            this.fNameField.postSetFocusOnDialogField(parent.getDisplay());
            Dialog.applyDialogFont((Control)composite);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.cp_edit_user_library");
            return composite;
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            if (field == this.fNameField) {
                this.updateStatus(this.validateSettings());
            }
        }

        private IStatus validateSettings() {
            String name = this.fNameField.getText();
            if (name.length() == 0) {
                return new StatusInfo(4, PreferencesMessages.UserLibraryPreferencePage_LibraryNameDialog_name_error_entername);
            }
            int i = 0;
            while (i < this.fExistingLibraries.size()) {
                CPUserLibraryElement curr = this.fExistingLibraries.get(i);
                if (curr != this.fElementToEdit && name.equals(curr.getName())) {
                    return new StatusInfo(4, Messages.format(PreferencesMessages.UserLibraryPreferencePage_LibraryNameDialog_name_error_exists, name));
                }
                ++i;
            }
            IStatus status = ResourcesPlugin.getWorkspace().validateName(name, 1);
            if (status.matches(4)) {
                return new StatusInfo(4, "Name contains invalid characters.");
            }
            return StatusInfo.OK_STATUS;
        }

        public CPUserLibraryElement getNewLibrary() {
            CPListElement[] entries = null;
            if (this.fElementToEdit != null) {
                entries = this.fElementToEdit.getChildren();
            }
            return new CPUserLibraryElement(this.fNameField.getText(), this.fIsSystemField.isSelected(), entries);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class LoadSaveDialog
    extends StatusDialog
    implements IStringButtonAdapter,
    IDialogFieldListener,
    IListAdapter<CPUserLibraryElement> {
        private static final String VERSION1 = "1";
        private static final String CURRENT_VERSION = "2";
        private static final String TAG_ROOT = "eclipse-userlibraries";
        private static final String TAG_VERSION = "version";
        private static final String TAG_LIBRARY = "library";
        private static final String TAG_SOURCEATTACHMENT = "source";
        private static final String TAG_SOURCE_ATTACHMENT_ENCODING = "source_encoding";
        private static final String TAG_ARCHIVE_PATH = "path";
        private static final String TAG_ARCHIVE = "archive";
        private static final String TAG_SYSTEMLIBRARY = "systemlibrary";
        private static final String TAG_NAME = "name";
        private static final String TAG_JAVADOC = "javadoc";
        private static final String TAG_NATIVELIB_PATHS = "nativelibpaths";
        private static final String TAG_ACCESSRULES = "accessrules";
        private static final String TAG_ACCESSRULE = "accessrule";
        private static final String TAG_RULE_KIND = "kind";
        private static final String TAG_RULE_PATTERN = "pattern";
        private static final String PREF_LASTPATH = "org.eclipse.jdt.ui.lastuserlibrary";
        private static final String PREF_USER_LIBRARY_LOADSAVE_SIZE = "UserLibraryLoadSaveDialog.size";
        private List<CPUserLibraryElement> fExistingLibraries;
        private IDialogSettings fSettings;
        private File fLastFile;
        private StringButtonDialogField fLocationField;
        private CheckedListDialogField<CPUserLibraryElement> fExportImportList;
        private Point fInitialSize;
        private final boolean fIsSave;

        public LoadSaveDialog(Shell shell, boolean isSave, List<CPUserLibraryElement> existingLibraries, IDialogSettings dialogSettings) {
            super(shell);
            this.initializeDialogUnits((Control)shell);
            this.fExistingLibraries = existingLibraries;
            this.fSettings = dialogSettings;
            this.fLastFile = null;
            this.fIsSave = isSave;
            int defaultWidth = this.convertWidthInCharsToPixels(80);
            int defaultHeigth = this.convertHeightInCharsToPixels(34);
            String lastSize = this.fSettings.get(PREF_USER_LIBRARY_LOADSAVE_SIZE);
            this.fInitialSize = lastSize != null ? StringConverter.asPoint((String)lastSize, (Point)new Point(defaultWidth, defaultHeigth)) : new Point(defaultWidth, defaultHeigth);
            if (this.isSave()) {
                this.setTitle(PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_save_title);
            } else {
                this.setTitle(PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_load_title);
            }
            this.fLocationField = new StringButtonDialogField(this);
            this.fLocationField.setLabelText(PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_location_label);
            this.fLocationField.setButtonLabel(PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_location_button);
            this.fLocationField.setDialogFieldListener(this);
            String[] buttonNames = new String[]{PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_list_selectall_button, PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_list_deselectall_button};
            this.fExportImportList = new CheckedListDialogField<CPUserLibraryElement>(this, buttonNames, (ILabelProvider)new CPListLabelProvider());
            this.fExportImportList.setCheckAllButtonIndex(0);
            this.fExportImportList.setUncheckAllButtonIndex(1);
            this.fExportImportList.setViewerComparator(new CPListElementSorter());
            this.fExportImportList.setDialogFieldListener(this);
            if (this.isSave()) {
                this.fExportImportList.setLabelText(PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_list_save_label);
                this.fExportImportList.setElements(this.fExistingLibraries);
                this.fExportImportList.checkAll(true);
            } else {
                this.fExportImportList.setLabelText(PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_list_load_label);
            }
            String lastPath = this.fSettings.get(PREF_LASTPATH);
            if (lastPath != null) {
                this.fLocationField.setText(lastPath);
            } else {
                this.fLocationField.setText("");
            }
        }

        protected boolean isResizable() {
            return true;
        }

        protected Point getInitialSize() {
            return this.fInitialSize;
        }

        private boolean isSave() {
            return this.fIsSave;
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            DialogField[] fields = this.isSave() ? new DialogField[]{this.fExportImportList, this.fLocationField} : new DialogField[]{this.fLocationField, this.fExportImportList};
            LayoutUtil.doDefaultLayout(composite, fields, true, -1, -1);
            this.fExportImportList.getListControl(null).setLayoutData((Object)new GridData(1808));
            this.fLocationField.postSetFocusOnDialogField(parent.getDisplay());
            BidiUtils.applyBidiProcessing((Text)this.fLocationField.getTextControl(parent), (String)"file");
            Dialog.applyDialogFont((Control)composite);
            if (this.isSave()) {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.cp_export_user_library");
            } else {
                PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.cp_import_user_library");
            }
            return composite;
        }

        @Override
        public void changeControlPressed(DialogField field) {
            String fileName;
            String label = this.isSave() ? PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_filedialog_save_title : PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_filedialog_load_title;
            FileDialog dialog = new FileDialog(this.getShell(), this.isSave() ? 8192 : 4096);
            dialog.setText(label);
            dialog.setFilterExtensions(new String[]{"*.userlibraries", "*.*"});
            String lastPath = this.fLocationField.getText();
            if (lastPath.length() == 0 || !new File(lastPath).exists()) {
                lastPath = this.fSettings.get(PREF_LASTPATH);
            }
            if (lastPath != null) {
                dialog.setFileName(lastPath);
            }
            if ((fileName = dialog.open()) != null) {
                this.fSettings.put(PREF_LASTPATH, fileName);
                this.fLocationField.setText(fileName);
            }
        }

        private IStatus updateShownLibraries(IStatus status) {
            if (!status.isOK()) {
                this.fExportImportList.removeAllElements();
                this.fExportImportList.setEnabled(false);
                this.fLastFile = null;
            } else {
                File file = new File(this.fLocationField.getText());
                if (!file.equals(this.fLastFile)) {
                    this.fLastFile = file;
                    try {
                        List<CPUserLibraryElement> elements = LoadSaveDialog.loadLibraries(file);
                        this.fExportImportList.setElements(elements);
                        this.fExportImportList.checkAll(true);
                        this.fExportImportList.setEnabled(true);
                        if (elements.isEmpty()) {
                            return new StatusInfo(4, PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_error_empty);
                        }
                    }
                    catch (IOException iOException) {
                        this.fExportImportList.removeAllElements();
                        this.fExportImportList.setEnabled(false);
                        return new StatusInfo(4, PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_error_invalidfile);
                    }
                }
            }
            return status;
        }

        @Override
        public void dialogFieldChanged(DialogField field) {
            if (field == this.fLocationField) {
                IStatus status = this.validateSettings();
                if (!this.isSave()) {
                    status = this.updateShownLibraries(status);
                }
                this.updateStatus(status);
            } else if (field == this.fExportImportList) {
                this.updateStatus(this.validateSettings());
            }
        }

        @Override
        public void customButtonPressed(ListDialogField<CPUserLibraryElement> field, int index) {
        }

        @Override
        public void selectionChanged(ListDialogField<CPUserLibraryElement> field) {
        }

        @Override
        public void doubleClicked(ListDialogField<CPUserLibraryElement> field) {
            List selectedElements = this.fExportImportList.getSelectedElements();
            if (selectedElements.size() == 1) {
                CPUserLibraryElement elem;
                this.fExportImportList.setChecked(elem, !this.fExportImportList.isChecked(elem = (CPUserLibraryElement)selectedElements.get(0)));
            }
        }

        protected void okPressed() {
            if (this.isSave()) {
                final File file = new File(this.fLocationField.getText());
                if (file.exists()) {
                    String title = PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_overwrite_title;
                    String message = PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_overwrite_message;
                    if (!MessageDialog.openQuestion((Shell)this.getShell(), (String)title, (String)message)) {
                        return;
                    }
                }
                try {
                    IPath path;
                    String encoding = "UTF-8";
                    IPath filePath = Path.fromOSString((String)file.getCanonicalPath());
                    IPath workspacePath = ResourcesPlugin.getWorkspace().getRoot().getLocation();
                    if (filePath.matchingFirstSegments(workspacePath) == workspacePath.segmentCount() && (path = filePath.removeFirstSegments(workspacePath.segmentCount())).segmentCount() > 1) {
                        IFile result = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
                        try {
                            encoding = result.getCharset(true);
                        }
                        catch (CoreException exception) {
                            JavaPlugin.log(exception);
                        }
                    }
                    final List<CPUserLibraryElement> elements = this.fExportImportList.getCheckedElements();
                    final String charset = encoding;
                    IProgressService context = PlatformUI.getWorkbench().getProgressService();
                    try {
                        context.run(true, true, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                try {
                                    LoadSaveDialog.saveLibraries(elements, file, charset, monitor);
                                }
                                catch (IOException e) {
                                    throw new InvocationTargetException(e);
                                }
                            }
                        });
                        this.fSettings.put(PREF_LASTPATH, file.getPath());
                    }
                    catch (InvocationTargetException e) {
                        String errorTitle = PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_save_errordialog_title;
                        String errorMessage = Messages.format(PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_save_errordialog_message, e.getMessage());
                        ExceptionHandler.handle(e, this.getShell(), errorTitle, errorMessage);
                        return;
                    }
                    catch (InterruptedException interruptedException) {
                        return;
                    }
                    String savedTitle = PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_save_ok_title;
                    String savedMessage = PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_save_ok_message;
                    MessageDialog.openInformation((Shell)this.getShell(), (String)savedTitle, (String)savedMessage);
                }
                catch (IOException exception) {
                    JavaPlugin.log(exception);
                }
            } else {
                HashSet<String> map = new HashSet<String>(this.fExistingLibraries.size());
                int k = 0;
                while (k < this.fExistingLibraries.size()) {
                    CPUserLibraryElement elem = this.fExistingLibraries.get(k);
                    map.add(elem.getName());
                    ++k;
                }
                int nReplaced = 0;
                List<CPUserLibraryElement> elements = this.getLoadedLibraries();
                int i = 0;
                while (i < elements.size()) {
                    CPUserLibraryElement curr = elements.get(i);
                    if (map.contains(curr.getName())) {
                        ++nReplaced;
                    }
                    ++i;
                }
                if (nReplaced > 0) {
                    String replaceTitle = PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_load_replace_title;
                    String replaceMessage = nReplaced == 1 ? PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_load_replace_message : Messages.format(PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_load_replace_multiple_message, String.valueOf(nReplaced));
                    if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)replaceTitle, (String)replaceMessage)) {
                        return;
                    }
                }
            }
            super.okPressed();
        }

        public boolean close() {
            Point point = this.getShell().getSize();
            this.fSettings.put(PREF_USER_LIBRARY_LOADSAVE_SIZE, StringConverter.asString((Point)point));
            return super.close();
        }

        private IStatus validateSettings() {
            String name = this.fLocationField.getText();
            this.fLastFile = null;
            if (this.isSave()) {
                if (name.length() == 0) {
                    return new StatusInfo(4, PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_location_error_save_enterlocation);
                }
                File file = new File(name);
                if (file.isDirectory()) {
                    return new StatusInfo(4, PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_location_error_save_invalid);
                }
                if (this.fExportImportList.getCheckedSize() == 0) {
                    return new StatusInfo(4, PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_list_error_save_nothingselected);
                }
                this.fLastFile = file;
            } else {
                if (name.length() == 0) {
                    return new StatusInfo(4, PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_location_error_load_enterlocation);
                }
                if (!new File(name).isFile()) {
                    return new StatusInfo(4, PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_location_error_load_invalid);
                }
                if (this.fExportImportList.getSize() > 0 && this.fExportImportList.getCheckedSize() == 0) {
                    return new StatusInfo(4, PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_list_error_load_nothingselected);
                }
            }
            return new StatusInfo();
        }

        protected static void saveLibraries(List<CPUserLibraryElement> libraries, File file, String encoding, IProgressMonitor monitor) throws IOException {
            FileOutputStream stream = new FileOutputStream(file);
            try {
                try {
                    DocumentBuilder docBuilder = null;
                    DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                    factory.setValidating(false);
                    docBuilder = factory.newDocumentBuilder();
                    Document document = docBuilder.newDocument();
                    Element rootElement = document.createElement(TAG_ROOT);
                    document.appendChild(rootElement);
                    rootElement.setAttribute(TAG_VERSION, CURRENT_VERSION);
                    int i = 0;
                    while (i < libraries.size()) {
                        Element libraryElement = document.createElement(TAG_LIBRARY);
                        rootElement.appendChild(libraryElement);
                        CPUserLibraryElement curr = libraries.get(i);
                        libraryElement.setAttribute(TAG_NAME, curr.getName());
                        libraryElement.setAttribute(TAG_SYSTEMLIBRARY, String.valueOf(curr.isSystemLibrary()));
                        CPListElement[] children = curr.getChildren();
                        int k = 0;
                        while (k < children.length) {
                            IAccessRule[] accessRules;
                            String nativeLibPath;
                            String javadocLocation;
                            String sourceEncoding;
                            CPListElement child = children[k];
                            Element childElement = document.createElement(TAG_ARCHIVE);
                            libraryElement.appendChild(childElement);
                            childElement.setAttribute(TAG_ARCHIVE_PATH, child.getPath().toPortableString());
                            IPath sourceAttachment = (IPath)child.getAttribute("sourcepath");
                            if (sourceAttachment != null) {
                                childElement.setAttribute(TAG_SOURCEATTACHMENT, sourceAttachment.toPortableString());
                            }
                            if ((sourceEncoding = (String)child.getAttribute(TAG_SOURCE_ATTACHMENT_ENCODING)) != null) {
                                childElement.setAttribute(TAG_SOURCE_ATTACHMENT_ENCODING, sourceEncoding);
                            }
                            if ((javadocLocation = (String)child.getAttribute("javadoc_location")) != null) {
                                childElement.setAttribute(TAG_JAVADOC, javadocLocation);
                            }
                            if ((nativeLibPath = (String)child.getAttribute(CPListElement.NATIVE_LIB_PATH)) != null) {
                                childElement.setAttribute(TAG_NATIVELIB_PATHS, nativeLibPath);
                            }
                            if ((accessRules = (IAccessRule[])child.getAttribute(TAG_ACCESSRULES)) != null && accessRules.length > 0) {
                                Element rulesElement = document.createElement(TAG_ACCESSRULES);
                                childElement.appendChild(rulesElement);
                                int n = 0;
                                while (n < accessRules.length) {
                                    IAccessRule rule = accessRules[n];
                                    Element ruleElement = document.createElement(TAG_ACCESSRULE);
                                    rulesElement.appendChild(ruleElement);
                                    ruleElement.setAttribute(TAG_RULE_KIND, String.valueOf(rule.getKind()));
                                    ruleElement.setAttribute(TAG_RULE_PATTERN, rule.getPattern().toPortableString());
                                    ++n;
                                }
                            }
                            ++k;
                        }
                        ++i;
                    }
                    Transformer transformer = TransformerFactory.newInstance().newTransformer();
                    transformer.setOutputProperty("method", "xml");
                    transformer.setOutputProperty("encoding", encoding);
                    transformer.setOutputProperty("indent", "yes");
                    transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
                    DOMSource source = new DOMSource(document);
                    StreamResult result = new StreamResult(stream);
                    transformer.transform(source, result);
                }
                catch (ParserConfigurationException e) {
                    throw new IOException(e.getMessage());
                }
                catch (TransformerException e) {
                    throw new IOException(e.getMessage());
                }
            }
            catch (Throwable throwable) {
                try {
                    ((OutputStream)stream).close();
                }
                catch (IOException iOException) {}
                if (monitor != null) {
                    monitor.done();
                }
                throw throwable;
            }
            try {
                ((OutputStream)stream).close();
            }
            catch (IOException iOException) {}
            if (monitor != null) {
                monitor.done();
            }
        }

        private static List<CPUserLibraryElement> loadLibraries(File file) throws IOException {
            Element cpElement;
            FileInputStream stream = new FileInputStream(file);
            try {
                try {
                    DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                    parser.setErrorHandler(new DefaultHandler());
                    cpElement = parser.parse(new InputSource(stream)).getDocumentElement();
                }
                catch (SAXException sAXException) {
                    throw new IOException(PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_load_badformat);
                }
                catch (ParserConfigurationException parserConfigurationException) {
                    throw new IOException(PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_load_badformat);
                }
            }
            finally {
                ((InputStream)stream).close();
            }
            if (!cpElement.getNodeName().equalsIgnoreCase(TAG_ROOT)) {
                throw new IOException(PreferencesMessages.UserLibraryPreferencePage_LoadSaveDialog_load_badformat);
            }
            String version = cpElement.getAttribute(TAG_VERSION);
            NodeList libList = cpElement.getElementsByTagName(TAG_LIBRARY);
            int length = libList.getLength();
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            ArrayList<CPUserLibraryElement> result = new ArrayList<CPUserLibraryElement>(length);
            int i = 0;
            while (i < length) {
                Node lib = libList.item(i);
                if (lib instanceof Element) {
                    Element libElement = (Element)lib;
                    String name = libElement.getAttribute(TAG_NAME);
                    boolean isSystem = Boolean.valueOf(libElement.getAttribute(TAG_SYSTEMLIBRARY));
                    CPUserLibraryElement newLibrary = new CPUserLibraryElement(name, isSystem, null);
                    result.add(newLibrary);
                    NodeList archiveList = libElement.getElementsByTagName(TAG_ARCHIVE);
                    int k = 0;
                    while (k < archiveList.getLength()) {
                        Node archiveNode = archiveList.item(k);
                        if (archiveNode instanceof Element) {
                            Element ruleParentElement;
                            NodeList ruleElements;
                            int nRuleElements;
                            NodeList rulesParentNodes;
                            String javadoc;
                            Element archiveElement = (Element)archiveNode;
                            String pathString = archiveElement.getAttribute(TAG_ARCHIVE_PATH);
                            IPath path = version.equals(VERSION1) ? Path.fromOSString((String)pathString) : Path.fromPortableString((String)pathString);
                            IResource resource = root.findMember(path = path.makeAbsolute());
                            if (!(resource instanceof IFile)) {
                                resource = null;
                            }
                            CPListElement newArchive = new CPListElement(newLibrary, null, 1, path, resource);
                            newLibrary.add(newArchive);
                            if (archiveElement.hasAttribute(TAG_SOURCEATTACHMENT)) {
                                String sourceAttachString = archiveElement.getAttribute(TAG_SOURCEATTACHMENT);
                                IPath sourceAttach = version.equals(VERSION1) ? Path.fromOSString((String)sourceAttachString) : Path.fromPortableString((String)sourceAttachString);
                                newArchive.setAttribute("sourcepath", sourceAttach);
                            }
                            if (archiveElement.hasAttribute(TAG_SOURCE_ATTACHMENT_ENCODING)) {
                                javadoc = archiveElement.getAttribute(TAG_SOURCE_ATTACHMENT_ENCODING);
                                newArchive.setAttribute(TAG_SOURCE_ATTACHMENT_ENCODING, javadoc);
                            }
                            if (archiveElement.hasAttribute(TAG_JAVADOC)) {
                                javadoc = archiveElement.getAttribute(TAG_JAVADOC);
                                newArchive.setAttribute("javadoc_location", javadoc);
                            }
                            if (archiveElement.hasAttribute(TAG_NATIVELIB_PATHS)) {
                                String nativeLibPath = archiveElement.getAttribute(TAG_NATIVELIB_PATHS);
                                newArchive.setAttribute(CPListElement.NATIVE_LIB_PATH, nativeLibPath);
                            }
                            if ((rulesParentNodes = archiveElement.getElementsByTagName(TAG_ACCESSRULES)).getLength() > 0 && rulesParentNodes.item(0) instanceof Element && (nRuleElements = (ruleElements = (ruleParentElement = (Element)rulesParentNodes.item(0)).getElementsByTagName(TAG_ACCESSRULE)).getLength()) > 0) {
                                ArrayList<IAccessRule> resultingRules = new ArrayList<IAccessRule>(nRuleElements);
                                int n = 0;
                                while (n < nRuleElements) {
                                    Node node = ruleElements.item(n);
                                    if (node instanceof Element) {
                                        Element ruleElement = (Element)node;
                                        try {
                                            int kind = Integer.parseInt(ruleElement.getAttribute(TAG_RULE_KIND));
                                            IPath pattern = Path.fromPortableString((String)ruleElement.getAttribute(TAG_RULE_PATTERN));
                                            resultingRules.add(JavaCore.newAccessRule((IPath)pattern, (int)kind));
                                        }
                                        catch (NumberFormatException numberFormatException) {}
                                    }
                                    ++n;
                                }
                                newArchive.setAttribute(TAG_ACCESSRULES, resultingRules.toArray(new IAccessRule[resultingRules.size()]));
                            }
                        }
                        ++k;
                    }
                }
                ++i;
            }
            return result;
        }

        public List<CPUserLibraryElement> getLoadedLibraries() {
            return this.fExportImportList.getCheckedElements();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class UserLibraryAdapter
    implements ITreeListAdapter<CPUserLibraryElement> {
        private final Object[] EMPTY = new Object[0];

        private UserLibraryAdapter() {
        }

        @Override
        public void customButtonPressed(TreeListDialogField<CPUserLibraryElement> field, int index) {
            UserLibraryPreferencePage.this.doCustomButtonPressed(field, index);
        }

        @Override
        public void selectionChanged(TreeListDialogField<CPUserLibraryElement> field) {
            UserLibraryPreferencePage.this.doSelectionChanged(field);
        }

        @Override
        public void doubleClicked(TreeListDialogField<CPUserLibraryElement> field) {
            UserLibraryPreferencePage.this.doDoubleClicked(field);
        }

        @Override
        public void keyPressed(TreeListDialogField<CPUserLibraryElement> field, KeyEvent event) {
            UserLibraryPreferencePage.this.doKeyPressed(field, event);
        }

        @Override
        public Object[] getChildren(TreeListDialogField<CPUserLibraryElement> field, Object element) {
            CPListElementAttribute attribute;
            if (element instanceof CPUserLibraryElement) {
                CPUserLibraryElement elem = (CPUserLibraryElement)element;
                return elem.getChildren();
            }
            if (element instanceof CPListElement) {
                return ((CPListElement)element).getChildren(false);
            }
            if (element instanceof CPListElementAttribute && "accessrules".equals((attribute = (CPListElementAttribute)element).getKey())) {
                return (IAccessRule[])attribute.getValue();
            }
            return this.EMPTY;
        }

        @Override
        public Object getParent(TreeListDialogField<CPUserLibraryElement> field, Object element) {
            if (element instanceof CPListElementAttribute) {
                return ((CPListElementAttribute)element).getParent();
            }
            if (element instanceof CPListElement) {
                return ((CPListElement)element).getParentContainer();
            }
            return null;
        }

        @Override
        public boolean hasChildren(TreeListDialogField<CPUserLibraryElement> field, Object element) {
            return this.getChildren(field, element).length > 0;
        }
    }
}

