/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.reporting.util;

import java.io.OutputStream;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.rcptt.reporting.Q7Info;
import org.eclipse.rcptt.reporting.Q7Statistics;
import org.eclipse.rcptt.reporting.core.SimpleSeverity;
import org.eclipse.rcptt.reporting.util.ReportUtils;
import org.eclipse.rcptt.reporting.util.internal.Plugin;
import org.eclipse.rcptt.reporting.util.internal.Reports;
import org.eclipse.rcptt.reporting.util.internal.XMLUtils;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Node;
import org.eclipse.rcptt.sherlock.core.model.sherlock.report.Report;

public class JUnitXMLReportGenerator {
    private static final String formatTime(Node nde) {
        return ReportUtils.formatTime(nde.getEndTime() - nde.getStartTime());
    }

    public void writeContent(Reports reports, OutputStream stream) throws CoreException {
        XMLStreamWriter writer = XMLUtils.createWriter(stream);
        try {
            try {
                writer.writeStartDocument();
                writer.writeStartElement("testsuites");
                for (String suite : reports.getSuiteIds()) {
                    Q7Statistics statistics = ReportUtils.calculateStatistics(reports.getReports(suite));
                    this.writeSuite(writer, suite, reports.getReports(suite), statistics);
                }
                writer.writeEndElement();
                writer.writeEndDocument();
                writer.flush();
            }
            catch (Exception ex) {
                throw new CoreException(Plugin.UTILS.createError((Throwable)ex));
            }
        }
        finally {
            XMLUtils.closeWriter(writer);
        }
    }

    public void writeSuite(XMLStreamWriter writer, String name, Iterator<Report> reportList, Q7Statistics stats) throws XMLStreamException {
        writer.writeStartElement("testsuite");
        writer.writeAttribute("name", name);
        writer.writeAttribute("time", ReportUtils.formatTime(stats.getTime()));
        writer.writeAttribute("failures", Integer.toString(stats.getFailed()));
        writer.writeAttribute("tests", Integer.toString(stats.getTotal()));
        writer.writeAttribute("skipped", Integer.toString(stats.getSkipped()));
        writer.writeAttribute("errors", "0");
        while (reportList.hasNext()) {
            this.writeTestcase(writer, reportList.next());
        }
        writer.writeEndElement();
    }

    public void writeTestcase(XMLStreamWriter writer, Report report) throws XMLStreamException {
        Node item = report.getRoot();
        Q7Info info = (Q7Info)item.getProperties().get((Object)"q7");
        String name = info != null && info.getVariant() != null && info.getVariant().size() != 0 ? String.valueOf(item.getName()) + "_" + ReportUtils.combineNames((EList<String>)info.getVariant(), "_") : item.getName();
        writer.writeStartElement("testcase");
        writer.writeAttribute("name", name);
        writer.writeAttribute("time", JUnitXMLReportGenerator.formatTime(item));
        SimpleSeverity severity = SimpleSeverity.create((Q7Info)info);
        switch (severity) {
            case OK: {
                break;
            }
            case CANCEL: {
                writer.writeAttribute("incomplete", "true");
                break;
            }
            case ERROR: {
                writer.writeStartElement("failure");
                writer.writeAttribute("type", "testcase");
                writer.writeAttribute("message", ReportUtils.getFailMessage(item));
                String data = ReportUtils.getDetails(item).trim();
                if (data != null && !data.trim().isEmpty()) {
                    writer.writeCData(data);
                }
                writer.writeEndElement();
            }
        }
        writer.writeEndElement();
    }

    public static void collectFailures(Node item, StringBuilder result) {
        Q7Info info = (Q7Info)item.getProperties().get((Object)"q7");
        if (info != null && info.getResult().getSeverity() != 0) {
            String msg = info.getResult().getMessage();
            if (msg.contains("]]>")) {
                msg = msg.replace("]]>", "]] >");
            }
            if (msg != null) {
                result.append(msg).append(" [" + item.getName() + "]").append("\n");
            }
        }
        EList children = item.getChildren();
        for (Node node : children) {
            JUnitXMLReportGenerator.collectFailures(node, result);
        }
    }
}

