/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui.templating;

import aQute.bnd.service.RepositoryPlugin;
import java.io.File;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import org.eclipse.pde.bnd.ui.templating.BundleLocator;

public class RepoPluginsBundleLocator
implements BundleLocator {
    private final List<RepositoryPlugin> plugins;

    public RepoPluginsBundleLocator(List<RepositoryPlugin> plugins) {
        this.plugins = plugins;
    }

    @Override
    public File locate(String bsn, String hash, String algo, URI location) throws Exception {
        HashMap<String, Object> searchProps = new HashMap<String, Object>();
        searchProps.put("version", "hash");
        searchProps.put("hash", algo + ":" + hash);
        for (RepositoryPlugin plugin : this.plugins) {
            try {
                File file = plugin.get(bsn, null, searchProps, new RepositoryPlugin.DownloadListener[0]);
                if (file == null) continue;
                return file;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        Path tempFile = Files.createTempFile("download", "jar", new FileAttribute[0]);
        tempFile.toFile().deleteOnExit();
        Object object = null;
        Object var8_9 = null;
        try (InputStream stream = location.toURL().openStream();){
            Files.copy(stream, tempFile, new CopyOption[0]);
        }
        catch (Throwable throwable) {
            if (object == null) {
                object = throwable;
            } else if (object != throwable) {
                ((Throwable)object).addSuppressed(throwable);
            }
            throw object;
        }
        return tempFile.toFile();
    }
}

