/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.base;

import org.eclipse.rdf4j.model.IRI;

public abstract class AbstractIRI
implements IRI {
    private static final long serialVersionUID = 7799969821538513046L;
    private int cachedHashCode = 0;

    @Override
    public String stringValue() {
        return this.getNamespace() + this.getLocalName();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o != null) {
            if (o instanceof AbstractIRI) {
                return this.stringValue().equals(o.toString());
            }
            return o.equals(this);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int hashCode() {
        int cached = this.cachedHashCode;
        if (cached == 0) {
            AbstractIRI abstractIRI = this;
            synchronized (abstractIRI) {
                cached = this.cachedHashCode;
                if (cached == 0) {
                    this.cachedHashCode = cached = this.stringValue().hashCode();
                }
            }
            this.cachedHashCode = cached = this.stringValue().hashCode();
        }
        return cached;
    }

    public String toString() {
        return this.stringValue();
    }

    static class GenericIRI
    extends AbstractIRI {
        private static final long serialVersionUID = 2209156550690548467L;
        private final String iri;
        private int split;

        GenericIRI(String iri) {
            this.iri = iri;
            this.split = 0;
        }

        GenericIRI(String namespace, String localName) {
            this.iri = namespace + localName;
            this.split = namespace.length();
        }

        @Override
        public String stringValue() {
            return this.iri;
        }

        @Override
        public String getNamespace() {
            return this.iri.substring(0, this.split());
        }

        @Override
        public String getLocalName() {
            return this.iri.substring(this.split());
        }

        private int split() {
            if (this.split > 0) {
                return this.split;
            }
            this.split = this.iri.indexOf(35) + 1;
            if (this.split > 0) {
                return this.split;
            }
            this.split = this.iri.lastIndexOf(47) + 1;
            if (this.split > 0) {
                return this.split;
            }
            this.split = this.iri.lastIndexOf(58) + 1;
            if (this.split > 0) {
                return this.split;
            }
            return 0;
        }
    }
}

