/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.impl.evaluationsteps;

import java.util.function.Function;
import java.util.function.Supplier;
import org.eclipse.rdf4j.collection.factory.api.CollectionFactory;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.IntersectIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryEvaluationStep;

public class IntersectionQueryEvaluationStep
implements QueryEvaluationStep {
    private final QueryEvaluationStep leftArg;
    private final Function<BindingSet, QueryEvaluationStep.DelayedEvaluationIteration> rightArgDelayed;
    private final Supplier<CollectionFactory> cfs;

    public IntersectionQueryEvaluationStep(QueryEvaluationStep leftArg, QueryEvaluationStep rightArg, Supplier<CollectionFactory> cfs) {
        this.cfs = cfs;
        this.leftArg = leftArg;
        this.rightArgDelayed = bs -> new QueryEvaluationStep.DelayedEvaluationIteration(rightArg, (BindingSet)bs);
    }

    @Override
    public CloseableIteration<BindingSet> evaluate(BindingSet bs) {
        final CollectionFactory cf = this.cfs.get();
        return new IntersectIteration<BindingSet>(this.leftArg.evaluate(bs), (CloseableIteration)this.rightArgDelayed.apply(bs), cf::createSetOfBindingSets){

            @Override
            protected void handleClose() {
                try {
                    cf.close();
                }
                finally {
                    super.handleClose();
                }
            }
        };
    }
}

