/*
 * Decompiled with CFR 0.152.
 */
package no.hasmac.rdf;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Collection;
import no.hasmac.jsonld.StringUtils;
import no.hasmac.jsonld.http.media.MediaType;
import no.hasmac.jsonld.lang.BlankNode;
import no.hasmac.jsonld.uri.UriUtils;
import no.hasmac.rdf.RdfDataset;
import no.hasmac.rdf.RdfGraph;
import no.hasmac.rdf.RdfLiteral;
import no.hasmac.rdf.RdfNQuad;
import no.hasmac.rdf.RdfResource;
import no.hasmac.rdf.RdfTriple;
import no.hasmac.rdf.RdfValue;
import no.hasmac.rdf.RdfValueFactory;
import no.hasmac.rdf.io.RdfReader;
import no.hasmac.rdf.io.RdfWriter;
import no.hasmac.rdf.io.error.UnsupportedContentException;
import no.hasmac.rdf.spi.RdfProvider;

public final class Rdf {
    private Rdf() {
    }

    public static RdfGraph createGraph() {
        return RdfProvider.provider().createGraph();
    }

    public static Collection<MediaType> canRead() {
        return RdfProvider.provider().canRead();
    }

    public static RdfReader createReader(MediaType contentType, Reader reader) throws UnsupportedContentException {
        if (reader == null || contentType == null) {
            throw new IllegalArgumentException();
        }
        return RdfProvider.provider().createReader(contentType, reader);
    }

    public static RdfReader createReader(MediaType contentType, InputStream is) throws UnsupportedContentException {
        if (is == null || contentType == null) {
            throw new IllegalArgumentException();
        }
        return Rdf.createReader(contentType, new InputStreamReader(is));
    }

    public static Collection<MediaType> canWrite() {
        return RdfProvider.provider().canWrite();
    }

    public static RdfWriter createWriter(MediaType contentType, Writer writer) throws UnsupportedContentException {
        if (writer == null || contentType == null) {
            throw new IllegalArgumentException();
        }
        return RdfProvider.provider().createWriter(contentType, writer);
    }

    public static RdfWriter createWriter(MediaType contentType, OutputStream os) throws UnsupportedContentException {
        if (os == null || contentType == null) {
            throw new IllegalArgumentException();
        }
        return Rdf.createWriter(contentType, new OutputStreamWriter(os));
    }

    public static RdfDataset createDataset() {
        return RdfProvider.provider().createDataset();
    }

    public static RdfTriple createTriple(RdfResource subject, RdfResource predicate, RdfValue object) {
        if (subject == null || predicate == null || object == null) {
            throw new IllegalArgumentException();
        }
        return (RdfTriple)RdfProvider.provider().createTriple(subject, predicate, object);
    }

    public static RdfNQuad createNQuad(RdfResource subject, RdfResource predicate, RdfValue object, RdfResource graphName) {
        if (subject == null) {
            throw new IllegalArgumentException("Subject cannot be null.");
        }
        if (predicate == null) {
            throw new IllegalArgumentException("Predicate cannot be null.");
        }
        if (object == null) {
            throw new IllegalArgumentException("Object cannot be null.");
        }
        return (RdfNQuad)RdfProvider.provider().createQuad(subject, predicate, object, graphName);
    }

    public static RdfNQuad createNQuad(RdfTriple triple, RdfResource graphName) {
        if (triple == null) {
            throw new IllegalArgumentException("Triple cannot be null.");
        }
        return (RdfNQuad)RdfProvider.provider().createQuad(triple.getSubject(), triple.getPredicate(), triple.getObject(), graphName);
    }

    public static RdfValue createValue(String value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        if (BlankNode.isWellFormed(value)) {
            return (RdfValue)RdfProvider.provider().createBlankNode(value);
        }
        if (UriUtils.isAbsoluteUri(value, true)) {
            return (RdfValue)RdfProvider.provider().createIRI(value);
        }
        return (RdfValue)RdfProvider.provider().createTypedLiteral(value, "http://www.w3.org/2001/XMLSchema#string");
    }

    public static RdfLiteral createString(String lexicalForm) {
        if (lexicalForm == null) {
            throw new IllegalArgumentException();
        }
        return (RdfLiteral)RdfProvider.provider().createTypedLiteral(lexicalForm, "http://www.w3.org/2001/XMLSchema#string");
    }

    public static RdfLiteral createTypedString(String lexicalForm, String dataType) {
        if (lexicalForm == null) {
            throw new IllegalArgumentException();
        }
        return (RdfLiteral)RdfProvider.provider().createTypedLiteral(lexicalForm, dataType);
    }

    public static RdfLiteral createLangString(String lexicalForm, String langTag) {
        if (lexicalForm == null) {
            throw new IllegalArgumentException();
        }
        return (RdfLiteral)RdfProvider.provider().createLangString(lexicalForm, langTag);
    }

    public static RdfResource createResource(String resource) {
        if (resource == null) {
            throw new IllegalArgumentException("The resource value cannot be null.");
        }
        if (BlankNode.isWellFormed(resource)) {
            return (RdfResource)RdfProvider.provider().createBlankNode(resource);
        }
        if (UriUtils.isAbsoluteUri(resource, true)) {
            return (RdfResource)RdfProvider.provider().createIRI(resource);
        }
        throw new IllegalArgumentException("The resource must be an absolute IRI or blank node identifier, but was [" + resource + "].");
    }

    public static RdfResource createBlankNode(String value) {
        if (value == null || StringUtils.isBlank(value)) {
            throw new IllegalArgumentException();
        }
        return (RdfResource)RdfProvider.provider().createBlankNode(value);
    }

    public static RdfResource createIRI(String value) {
        if (value == null || StringUtils.isBlank(value)) {
            throw new IllegalArgumentException();
        }
        return (RdfResource)RdfProvider.provider().createIRI(value);
    }

    public static RdfValueFactory<RdfTriple, RdfNQuad, RdfResource, RdfResource, RdfResource, RdfLiteral, RdfValue> createValueFactory() {
        return RdfProvider.provider();
    }
}

