/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.MathContext;
import java.math.RoundingMode;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.query.algebra.MathExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;

public class MathUtil {
    public static final int DEFAULT_DECIMAL_EXPANSION_SCALE = 24;
    private static int decimalExpansionScale = 24;

    public static Literal compute(Literal leftLit, Literal rightLit, MathExpr.MathOp op) throws ValueExprEvaluationException {
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        return MathUtil.compute(leftLit, rightLit, op, vf);
    }

    public static Literal compute(Literal leftLit, Literal rightLit, MathExpr.MathOp op, ValueFactory vf) throws ValueExprEvaluationException {
        CoreDatatype leftDatatype = leftLit.getCoreDatatype();
        CoreDatatype rightDatatype = rightLit.getCoreDatatype();
        CoreDatatype.XSD leftDatatypeXSD = MathUtil.validateNumericArgument(leftLit, leftDatatype);
        CoreDatatype.XSD rightDatatypeXSD = MathUtil.validateNumericArgument(rightLit, rightDatatype);
        CoreDatatype.XSD commonDatatype = MathUtil.determineCommonDatatype(op, leftDatatypeXSD, rightDatatypeXSD);
        try {
            switch (commonDatatype) {
                case DOUBLE: {
                    return MathUtil.computeForXsdDouble(leftLit, rightLit, op, vf);
                }
                case FLOAT: {
                    return MathUtil.computeForXsdFloat(leftLit, rightLit, op, vf);
                }
                case DECIMAL: {
                    return MathUtil.computeForXsdDecimal(leftLit, rightLit, op, vf);
                }
            }
            return MathUtil.computeForXsdInteger(leftLit, rightLit, op, vf);
        }
        catch (ArithmeticException | NumberFormatException e) {
            throw new ValueExprEvaluationException(e);
        }
    }

    private static CoreDatatype.XSD validateNumericArgument(Literal lit, CoreDatatype datatype) {
        if (!datatype.isXSDDatatype()) {
            throw new ValueExprEvaluationException("Not a number: " + String.valueOf(lit));
        }
        CoreDatatype.XSD leftDatatypeXSD = (CoreDatatype.XSD)datatype;
        if (!leftDatatypeXSD.isNumericDatatype()) {
            throw new ValueExprEvaluationException("Not a number: " + String.valueOf(lit));
        }
        return leftDatatypeXSD;
    }

    private static Literal computeForXsdInteger(Literal leftLit, Literal rightLit, MathExpr.MathOp op, ValueFactory vf) {
        BigInteger left = leftLit.integerValue();
        BigInteger right = rightLit.integerValue();
        switch (op) {
            case PLUS: {
                return vf.createLiteral(left.add(right));
            }
            case MINUS: {
                return vf.createLiteral(left.subtract(right));
            }
            case MULTIPLY: {
                return vf.createLiteral(left.multiply(right));
            }
            case DIVIDE: {
                throw new RuntimeException("Integer divisions should be processed as decimal divisions");
            }
        }
        throw new IllegalArgumentException("Unknown operator: " + String.valueOf((Object)op));
    }

    private static Literal computeForXsdDecimal(Literal leftLit, Literal rightLit, MathExpr.MathOp op, ValueFactory vf) {
        BigDecimal left = leftLit.decimalValue();
        BigDecimal right = rightLit.decimalValue();
        switch (op) {
            case PLUS: {
                return vf.createLiteral(left.add(right));
            }
            case MINUS: {
                return vf.createLiteral(left.subtract(right));
            }
            case MULTIPLY: {
                return vf.createLiteral(left.multiply(right));
            }
            case DIVIDE: {
                BigDecimal result;
                try {
                    result = left.divide(right, MathContext.UNLIMITED);
                }
                catch (ArithmeticException e) {
                    result = left.setScale(MathUtil.getDecimalExpansionScale(), RoundingMode.HALF_UP).divide(right, RoundingMode.HALF_UP);
                }
                return vf.createLiteral(result);
            }
        }
        throw new IllegalArgumentException("Unknown operator: " + String.valueOf((Object)op));
    }

    private static Literal computeForXsdFloat(Literal leftLit, Literal rightLit, MathExpr.MathOp op, ValueFactory vf) {
        float left = leftLit.floatValue();
        float right = rightLit.floatValue();
        switch (op) {
            case PLUS: {
                return vf.createLiteral(left + right);
            }
            case MINUS: {
                return vf.createLiteral(left - right);
            }
            case MULTIPLY: {
                return vf.createLiteral(left * right);
            }
            case DIVIDE: {
                return vf.createLiteral(left / right);
            }
        }
        throw new IllegalArgumentException("Unknown operator: " + String.valueOf((Object)op));
    }

    private static Literal computeForXsdDouble(Literal leftLit, Literal rightLit, MathExpr.MathOp op, ValueFactory vf) {
        double left = leftLit.doubleValue();
        double right = rightLit.doubleValue();
        switch (op) {
            case PLUS: {
                return vf.createLiteral(left + right);
            }
            case MINUS: {
                return vf.createLiteral(left - right);
            }
            case MULTIPLY: {
                return vf.createLiteral(left * right);
            }
            case DIVIDE: {
                return vf.createLiteral(left / right);
            }
        }
        throw new IllegalArgumentException("Unknown operator: " + String.valueOf((Object)op));
    }

    private static CoreDatatype.XSD determineCommonDatatype(MathExpr.MathOp op, CoreDatatype.XSD leftDatatype, CoreDatatype.XSD rightDatatype) {
        CoreDatatype.XSD commonDatatype = leftDatatype.equals(CoreDatatype.XSD.DOUBLE) || rightDatatype.equals(CoreDatatype.XSD.DOUBLE) ? CoreDatatype.XSD.DOUBLE : (leftDatatype.equals(CoreDatatype.XSD.FLOAT) || rightDatatype.equals(CoreDatatype.XSD.FLOAT) ? CoreDatatype.XSD.FLOAT : (leftDatatype.equals(CoreDatatype.XSD.DECIMAL) || rightDatatype.equals(CoreDatatype.XSD.DECIMAL) ? CoreDatatype.XSD.DECIMAL : (op == MathExpr.MathOp.DIVIDE ? CoreDatatype.XSD.DECIMAL : CoreDatatype.XSD.INTEGER)));
        return commonDatatype;
    }

    public static int getDecimalExpansionScale() {
        return decimalExpansionScale;
    }

    public static void setDecimalExpansionScale(int decimalExpansionScale) {
        MathUtil.decimalExpansionScale = decimalExpansionScale;
    }
}

