/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.cloud.autoscaling;

import java.io.IOException;
import org.apache.solr.common.MapWriter;

class RangeVal
implements MapWriter {
    final Number min;
    final Number max;
    final Number actual;

    RangeVal(Number min, Number max, Number actual) {
        this.min = min;
        this.max = max;
        this.actual = actual;
    }

    public boolean match(Number testVal) {
        if (testVal == null) {
            return false;
        }
        return Double.compare(testVal.doubleValue(), this.min.doubleValue()) >= 0 && Double.compare(testVal.doubleValue(), this.max.doubleValue()) <= 0;
    }

    public Double realDelta(double v) {
        if (this.actual != null) {
            return v - this.actual.doubleValue();
        }
        return this.delta(v);
    }

    public Double delta(double v) {
        if (v >= this.max.doubleValue()) {
            return v - this.max.doubleValue();
        }
        if (v <= this.min.doubleValue()) {
            return v - this.min.doubleValue();
        }
        return 0.0;
    }

    public String toString() {
        return this.jsonStr();
    }

    @Override
    public void writeMap(MapWriter.EntryWriter ew) throws IOException {
        ew.put((CharSequence)"min", this.min).put((CharSequence)"max", this.max).putIfNotNull("actual", this.actual);
    }
}

