/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.impact.merge;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.diffmerge.api.IMatchPolicy;
import org.eclipse.emf.diffmerge.api.IMergePolicy;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.scopes.IFeaturedModelScope;
import org.eclipse.emf.diffmerge.diffdata.EComparison;
import org.eclipse.emf.diffmerge.diffdata.impl.EComparisonImpl;
import org.eclipse.emf.diffmerge.impl.scopes.RootedModelScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.polarsys.reqcycle.impact.merge.CustomRootedModelScope;
import org.polarsys.reqcycle.impact.merge.ITrackingModelScope;
import org.polarsys.reqcycle.impact.merge.MergerException;
import org.polarsys.reqcycle.impact.merge.TrackingFragmentedModelScope;
import org.polarsys.reqcycle.impact.merge.filters.IDifferenceFilter;
import org.polarsys.reqcycle.impact.merge.filters.OrderDifferenceFilter;

public class Merger {
    private static Function<EObject, String> GET_FRAGMENT_FUNCTION = new Function<EObject, String>(){

        public String apply(EObject o) {
            if (o.eResource() != null) {
                return o.eResource().getURIFragment(o);
            }
            return "";
        }
    };

    public static MergeResult offlineMerge(IProgressMonitor monitor_p, List<? extends EObject> targetObjects, List<? extends EObject> refObjects, List<? extends EObject> ancestorObjects, IDifferenceFilter diffFilter) throws MergerException {
        return Merger.offlineMerge(monitor_p, targetObjects, refObjects, ancestorObjects, diffFilter, null, null);
    }

    public static MergeResult offlineMerge(IProgressMonitor monitor_p, List<? extends EObject> targetObjects, List<? extends EObject> refObjects, List<? extends EObject> ancestorObjects, IDifferenceFilter diffFilter, IMatchPolicy matchPolicy, IMergePolicy mergePolicy) throws MergerException {
        if (monitor_p == null) {
            monitor_p = new NullProgressMonitor();
        }
        if (diffFilter == null) {
            diffFilter = new OrderDifferenceFilter();
        }
        try {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)monitor_p, (String)"merge", (int)2);
            CustomRootedModelScope refScope = new CustomRootedModelScope(refObjects);
            CustomRootedModelScope targetScope = new CustomRootedModelScope(targetObjects);
            EComparisonImpl comparison = new EComparisonImpl((IFeaturedModelScope)targetScope, (IFeaturedModelScope)refScope, (IFeaturedModelScope)(ancestorObjects == null ? null : new RootedModelScope(ancestorObjects)));
            comparison.compute(matchPolicy, null, mergePolicy, (IProgressMonitor)monitor.newChild(2));
            ArrayList toMergeDiffs = Lists.newArrayList((Iterable)comparison.getRemainingDifferences());
            diffFilter.filter(toMergeDiffs);
            comparison.merge((Collection)toMergeDiffs, Role.TARGET, true, null);
            return Merger.computeMergeResult(targetScope, refScope);
        }
        catch (Exception e) {
            throw new MergerException(e);
        }
    }

    public static MergeResult computeMergeResult(IFeaturedModelScope targetScope, IFeaturedModelScope refScope) {
        MergeResult result = new MergeResult();
        if (refScope instanceof ITrackingModelScope) {
            result.refAddedObjectIds.addAll(Collections2.transform(((ITrackingModelScope)refScope).getAddedObjects(), GET_FRAGMENT_FUNCTION));
            result.refRemovedObjectIds.addAll(((ITrackingModelScope)refScope).getRemovedObjectIds());
        }
        if (targetScope instanceof ITrackingModelScope) {
            result.targetAddedObjectIds.addAll(Collections2.transform(((ITrackingModelScope)targetScope).getAddedObjects(), GET_FRAGMENT_FUNCTION));
            result.targetRemovedObjectIds.addAll(((ITrackingModelScope)targetScope).getRemovedObjectIds());
        }
        return result;
    }

    public static MergeResult compareAndMerge(Resource targetRes, Resource refRes, Resource ancestorRes, String targetDisplayName, String refDisplayName, IDifferenceFilter automergeFilter) throws MergerException {
        EComparison comparison = Merger.createComparison(targetRes, refRes, ancestorRes, targetDisplayName, refDisplayName);
        comparison.compute(null, null, null, null);
        if (automergeFilter != null) {
            ArrayList toMergeDiffs = Lists.newArrayList((Iterable)comparison.getRemainingDifferences());
            automergeFilter.filter(toMergeDiffs);
            if (!toMergeDiffs.isEmpty()) {
                comparison.merge((Collection)toMergeDiffs, Role.TARGET, true, null);
            }
        }
        return Merger.computeMergeResult(comparison.getTargetScope(), comparison.getReferenceScope());
    }

    public static EComparison createComparison(Resource targetRes, Resource refRes, Resource ancestorRes, String targetDisplayName, String refDisplayName) {
        TrackingFragmentedModelScope refScope = new TrackingFragmentedModelScope(refRes, refDisplayName);
        TrackingFragmentedModelScope targetScope = new TrackingFragmentedModelScope(targetRes, targetDisplayName);
        TrackingFragmentedModelScope ancestorScope = null;
        if (ancestorRes != null) {
            ancestorScope = new TrackingFragmentedModelScope(ancestorRes, null);
        }
        return new EComparisonImpl((IFeaturedModelScope)targetScope, (IFeaturedModelScope)refScope, (IFeaturedModelScope)ancestorScope);
    }

    public static class MergeResult {
        public Set<String> refAddedObjectIds = new HashSet<String>();
        public Set<String> refRemovedObjectIds = new HashSet<String>();
        public Set<String> targetAddedObjectIds = new HashSet<String>();
        public Set<String> targetRemovedObjectIds = new HashSet<String>();
    }
}

