/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.repository.connector.ui.wizard;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.polarsys.reqcycle.repository.connector.ui.Activator;
import org.polarsys.reqcycle.repository.data.MappingModel.impl.MappingAttributeImpl;
import org.polarsys.reqcycle.repository.data.MappingModel.impl.MappingElementImpl;
import org.polarsys.reqcycle.repository.data.types.IAttribute;
import org.polarsys.reqcycle.repository.data.types.IEnumerationType;
import org.polarsys.reqcycle.repository.data.types.IRequirementType;

public abstract class MappingComposite
extends Composite {
    private TreeViewer sourceViewer;
    private Button btnLink;
    private TreeViewer targetViewer;
    private TreeViewer resultViewer;
    private Button btnRemoveLink;
    private Object sourceSelection;
    protected Object targetSelection;
    private Collection<EObject> result = new ArrayList<EObject>();
    private Label lblSource;
    private Label lblTarget;
    private Label lblMapping;
    private WizardPage page;
    private Button btnEditLink;
    private Button btnAutoMap;
    public static ITreeContentProvider contentProvider = new ITreeContentProvider(){

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void dispose() {
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public Object getParent(Object element) {
            return null;
        }

        public Object[] getElements(Object inputElement) {
            return ArrayContentProvider.getInstance().getElements(inputElement);
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }
    };
    public static ILabelProvider labelProvider = new ILabelProvider(){

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof MappingAttributeImpl) {
                MappingAttributeImpl att = (MappingAttributeImpl)element;
                return String.valueOf(att.getDescription()) + " <--> " + att.getTargetAttribute().getName();
            }
            if (element instanceof MappingElementImpl) {
                MappingElementImpl elt = (MappingElementImpl)element;
                return String.valueOf(elt.getDescription()) + " <--> " + elt.getTargetElement().getName();
            }
            return element.toString();
        }
    };

    public MappingComposite(Composite parent, int style, WizardPage page) {
        super(parent, style);
        this.setLayout((Layout)new GridLayout(1, false));
        this.page = page;
        Composite selectionComposite = new Composite((Composite)this, 0);
        selectionComposite.setLayout((Layout)new GridLayout(3, false));
        selectionComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.lblSource = new Label(selectionComposite, 0);
        String sourceDetail = this.getSourceDetail();
        if (sourceDetail != null && !sourceDetail.isEmpty()) {
            this.lblSource.setText("Source (" + sourceDetail + ")");
        } else {
            this.lblSource.setText("Source");
        }
        new Label(selectionComposite, 0);
        this.lblTarget = new Label(selectionComposite, 0);
        String targetDetail = this.getTargetDetail();
        if (targetDetail != null && !targetDetail.isEmpty()) {
            this.lblTarget.setText("Target (" + targetDetail + ")");
        } else {
            this.lblTarget.setText("Target");
        }
        this.sourceViewer = new TreeViewer(selectionComposite, 2048);
        this.sourceViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.sourceViewer.setLabelProvider(this.getSourceLabelProvider());
        this.sourceViewer.setContentProvider(this.getSourceContentProvider());
        this.sourceViewer.setInput(this.getSourceInput());
        this.btnLink = new Button(selectionComposite, 0);
        this.btnLink.setImage(Activator.getImageDescriptor("icons/chain--plus.png").createImage());
        this.btnLink.setToolTipText("Link");
        this.btnLink.setEnabled(false);
        this.targetViewer = new TreeViewer(selectionComposite, 2048);
        this.targetViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.targetViewer.setLabelProvider(this.getTargetLabelProvider());
        this.targetViewer.setContentProvider(this.getTargetContentProvider());
        this.targetViewer.setInput(this.getTargetInput());
        Composite resultComposite = new Composite((Composite)this, 0);
        resultComposite.setLayout((Layout)new GridLayout(2, false));
        resultComposite.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.lblMapping = new Label(resultComposite, 0);
        String resultDetail = this.getResultDetail();
        if (resultDetail != null && !resultDetail.isEmpty()) {
            this.lblMapping.setText("Mapping (" + resultDetail + ")");
        } else {
            this.lblMapping.setText("Mapping");
        }
        new Label(resultComposite, 0);
        this.resultViewer = new TreeViewer(resultComposite, 2048);
        this.resultViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true, 1, 4));
        this.resultViewer.setLabelProvider(this.getResultLabelProvider());
        this.resultViewer.setContentProvider(this.getResultContentProvider());
        this.init(this.result);
        this.resultViewer.setInput(this.result);
        this.btnRemoveLink = new Button(resultComposite, 0);
        this.btnRemoveLink.setLayoutData((Object)new GridData(0x1000000, 128, false, false, 1, 1));
        this.btnRemoveLink.setToolTipText("Remove Link");
        this.btnRemoveLink.setImage(Activator.getImageDescriptor("icons/chain--minus.png").createImage());
        this.btnRemoveLink.setEnabled(false);
        this.btnEditLink = new Button(resultComposite, 0);
        this.btnEditLink.setLayoutData((Object)new GridData(0x1000000, 128, false, false, 1, 1));
        this.btnEditLink.setToolTipText("Edit Link");
        this.btnEditLink.setImage(Activator.getImageDescriptor("icons/chain--pencil.png").createImage());
        this.btnEditLink.setEnabled(this.getCanEditLink());
        this.btnEditLink.setVisible(this.getCanEditLink());
        this.btnAutoMap = new Button(resultComposite, 0);
        this.btnAutoMap.setText("auto");
        this.btnAutoMap.setEnabled(false);
        this.btnAutoMap.setVisible(false);
        this.btnAutoMap.setLayoutData((Object)new GridData(0x1000000, 128, false, false, 1, 1));
        this.hookListeners();
    }

    protected void init(Collection<EObject> result) {
    }

    protected void hookListeners() {
        this.sourceViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    MappingComposite.this.sourceSelection = ((IStructuredSelection)selection).getFirstElement();
                }
                MappingComposite.this.btnLink.setEnabled(!MappingComposite.this.targetViewer.getSelection().isEmpty() && !selection.isEmpty());
            }
        });
        this.targetViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                if (selection instanceof IStructuredSelection) {
                    MappingComposite.this.targetSelection = ((IStructuredSelection)selection).getFirstElement();
                }
                MappingComposite.this.btnLink.setEnabled(!event.getSelection().isEmpty() && !MappingComposite.this.sourceViewer.getSelection().isEmpty());
            }
        });
        this.resultViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                MappingComposite.this.btnRemoveLink.setEnabled(!selection.isEmpty());
            }
        });
        this.btnLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EObject linkedElement = MappingComposite.this.linkElements(MappingComposite.this.sourceSelection, MappingComposite.this.targetSelection);
                if (linkedElement != null) {
                    MappingComposite.this.result.add(linkedElement);
                    MappingComposite.this.resultViewer.refresh();
                    if (MappingComposite.this.page != null) {
                        MappingComposite.this.page.setPageComplete(true);
                    }
                }
            }
        });
        this.btnRemoveLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ISelection selection = MappingComposite.this.resultViewer.getSelection();
                if (selection instanceof IStructuredSelection) {
                    Object fElement = ((IStructuredSelection)selection).getFirstElement();
                    MappingComposite.this.result.remove(fElement);
                    MappingComposite.this.resultViewer.refresh();
                    if (MappingComposite.this.page != null && MappingComposite.this.result.isEmpty()) {
                        MappingComposite.this.page.setPageComplete(false);
                    }
                }
            }
        });
    }

    protected IContentProvider getResultContentProvider() {
        return contentProvider;
    }

    protected IBaseLabelProvider getResultLabelProvider() {
        return labelProvider;
    }

    protected abstract String getResultDetail();

    protected abstract Object getTargetInput();

    protected IContentProvider getTargetContentProvider() {
        return contentProvider;
    }

    protected IBaseLabelProvider getTargetLabelProvider() {
        return new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof IRequirementType) {
                    return ((IRequirementType)element).getName();
                }
                if (element instanceof IEnumerationType) {
                    return ((IEnumerationType)element).getName();
                }
                if (element instanceof IAttribute) {
                    IAttribute attr = (IAttribute)element;
                    String typeName = attr.getType().getName();
                    return String.valueOf(attr.getName()) + " : " + typeName;
                }
                return super.getText(element);
            }
        };
    }

    protected abstract Object getSourceInput();

    protected abstract IContentProvider getSourceContentProvider();

    protected abstract IBaseLabelProvider getSourceLabelProvider();

    protected abstract String getTargetDetail();

    protected abstract String getSourceDetail();

    public abstract EObject linkElements(Object var1, Object var2);

    protected abstract boolean getCanEditLink();

    public Collection<EObject> getResult() {
        return this.result;
    }

    public void addToResult(EObject element) {
        this.result.add(element);
        if (this.resultViewer != null) {
            this.resultViewer.refresh();
            this.page.setPageComplete(true);
        }
    }

    public void addToResult(Collection<EObject> elements) {
        this.result.addAll(elements);
        if (this.resultViewer != null) {
            this.resultViewer.refresh();
            this.page.setPageComplete(true);
        }
    }
}

