/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.ui.providers;

import javax.inject.Inject;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.polarsys.reqcycle.traceability.model.Link;
import org.polarsys.reqcycle.traceability.model.TType;
import org.polarsys.reqcycle.traceability.types.ITypesConfigurationProvider;
import org.polarsys.reqcycle.traceability.types.RelationUtils;
import org.polarsys.reqcycle.traceability.types.configuration.preferences.dialogs.IconRegistry;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.Configuration;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.Relation;
import org.polarsys.reqcycle.traceability.types.ui.IStylePredicateProvider;
import org.polarsys.reqcycle.traceability.ui.TraceabilityUtils;
import org.polarsys.reqcycle.traceability.ui.providers.BusinessDeffered;
import org.polarsys.reqcycle.uri.model.Reachable;

public class RequestLabelProvider
extends LabelProvider
implements IFontProvider,
IColorProvider {
    @Inject
    IStylePredicateProvider provider;
    @Inject
    ITypesConfigurationProvider typeConfProvider;

    public String getText(Object element) {
        if (element instanceof BusinessDeffered) {
            element = ((BusinessDeffered)element).getBusinessElement();
        }
        if (element instanceof Reachable) {
            Reachable reach = (Reachable)element;
            return TraceabilityUtils.getText(reach);
        }
        if (element instanceof Link) {
            return ((Link)element).getLabel();
        }
        return super.getText(element);
    }

    public Image getImage(Object element) {
        Reachable reach;
        Image image;
        if (element instanceof BusinessDeffered && (element = ((BusinessDeffered)element).getBusinessElement()) instanceof Link) {
            Relation relation;
            Link link = (Link)element;
            Configuration config = this.typeConfProvider.getDefaultConfiguration();
            if (config != null && (relation = RelationUtils.getMatchingRelation((Configuration)config, (TType)link.getKind(), (Reachable)((Reachable)link.getSources().iterator().next()), (Reachable)((Reachable)link.getTargets().iterator().next()))) != null) {
                return IconRegistry.getImage((String)relation.getIcon());
            }
        }
        if (element instanceof Reachable && (image = TraceabilityUtils.getImage(reach = (Reachable)element)) != null) {
            return image;
        }
        return super.getImage(element);
    }

    public Color getForeground(Object element) {
        BusinessDeffered deferred;
        if (element instanceof BusinessDeffered && (deferred = (BusinessDeffered)element).getBusinessElement() instanceof Link) {
            Link link = (Link)deferred.getBusinessElement();
            return this.provider.getColorForRelation(link);
        }
        return null;
    }

    public Font getFont(Object element) {
        BusinessDeffered deferred;
        if (element instanceof BusinessDeffered && (deferred = (BusinessDeffered)element).getBusinessElement() instanceof Link) {
            Link link = (Link)deferred.getBusinessElement();
            return this.provider.getFontForRelation(link);
        }
        return null;
    }

    public Color getBackground(Object element) {
        return null;
    }
}

