/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.utils.iterators.pickers;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.polarsys.reqcycle.utils.iterators.exceptions.PickerExecutionException;
import org.polarsys.reqcycle.utils.iterators.pickers.IArc;
import org.polarsys.reqcycle.utils.iterators.pickers.IArcPicker;
import org.polarsys.reqcycle.utils.iterators.pickers.IPickableArc;
import org.polarsys.reqcycle.utils.iterators.pickers.IPicker;

public class ArcPicker
implements IArcPicker {
    protected IPicker basicPicker;

    public ArcPicker(IPicker picker) {
        this.basicPicker = picker;
    }

    @Override
    public Iterable<?> getNexts(Object element) throws PickerExecutionException {
        IArc arc;
        Object destination;
        Iterable<?> nexts;
        LinkedList result = Lists.newLinkedList();
        if (element instanceof IArc && (nexts = this.basicPicker.getNexts(destination = (arc = (IArc)element).getDestination())) != null) {
            for (Object child : nexts) {
                PickableArc arcChild = new PickableArc(this.basicPicker, arc, destination, child);
                result.add(arcChild);
            }
        }
        return result;
    }

    @Override
    public IPicker getBasePicker() {
        return this.basicPicker;
    }

    protected class PickableArc
    implements IPickableArc {
        private Object origin;
        private Object destination;
        private IPicker picker;
        private IArc parentArc;

        public PickableArc(IPicker picker, IArc parentArc, Object origin, Object destination) {
            this.picker = picker;
            this.origin = origin;
            this.destination = destination;
            this.parentArc = parentArc;
        }

        @Override
        public Object getOrigin() {
            return this.origin;
        }

        @Override
        public Object getDestination() {
            return this.destination;
        }

        @Override
        public IPicker getPicker() {
            return this.picker;
        }

        @Override
        public IArc getParentArc() {
            return this.parentArc;
        }

        public boolean equals(Object arg0) {
            if (arg0 instanceof PickableArc) {
                PickableArc arc = (PickableArc)arg0;
                boolean sameOrigin = false;
                sameOrigin = this.getOrigin() != null && arc.getOrigin() != null ? this.getOrigin().equals(arc.getOrigin()) : this.getOrigin() == null && arc.getOrigin() == null;
                boolean sameDestination = false;
                sameDestination = this.getDestination() != null && arc.getDestination() != null ? this.getDestination().equals(arc.getDestination()) : this.getDestination() == null && arc.getDestination() == null;
                boolean samePicker = false;
                if (this.getPicker() != null && arc.getDestination() != null) {
                    samePicker = this.getPicker().equals(arc.getPicker());
                } else {
                    boolean bl = samePicker = this.getPicker() == null && arc.getPicker() == null;
                }
                return sameOrigin && sameDestination && samePicker;
            }
            return false;
        }

        public int hashCode() {
            return this.getOrigin().hashCode();
        }

        @Override
        public boolean provokesCycling() {
            IArc currentAncestor = this.getParentArc();
            while (currentAncestor instanceof IPickableArc) {
                if (currentAncestor.equals(this)) {
                    return true;
                }
                currentAncestor = ((IPickableArc)currentAncestor).getParentArc();
            }
            return false;
        }

        @Override
        public List<Object> getCycle() {
            ArrayList result = Lists.newArrayList();
            result.add(this.getDestination());
            result.add(this.getOrigin());
            IArc currentAncestor = this.getParentArc();
            while (currentAncestor instanceof IPickableArc && currentAncestor != this) {
                result.add(currentAncestor.getOrigin());
                currentAncestor = ((IPickableArc)currentAncestor).getParentArc();
            }
            return result;
        }
    }
}

