/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.compare.report;

import com.google.common.base.Objects;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.Monitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.compare.AttributeChange;
import org.eclipse.emf.compare.Comparison;
import org.eclipse.emf.compare.Diff;
import org.eclipse.emf.compare.DifferenceKind;
import org.eclipse.emf.compare.DifferenceSource;
import org.eclipse.emf.compare.Match;
import org.eclipse.emf.compare.MatchResource;
import org.eclipse.emf.compare.ReferenceChange;
import org.eclipse.emf.compare.postprocessor.IPostProcessor;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sphinx.emf.compare.util.ModelCompareUtil;
import org.eclipse.sphinx.emf.util.EObjectUtil;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.util.EcoreResourceUtil;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Pair;

public abstract class AbstractModelCompareReportGenerator
implements IPostProcessor {
    public static final String MODEL_DIFF_REPORT_KIND = "kind";
    public static final String MODEL_DIFF_REPORT_LEFT_DIFF_URI = "leftURI";
    public static final String MODEL_DIFF_REPORT_LEFT_DIFF_TEXT = "leftChangeText";
    public static final String MODEL_DIFF_REPORT_RIGHT_DIFF_URI = "rightURI";
    public static final String MODEL_DIFF_REPORT_RIGHT_DIFF_TEXT = "rightChangeText";
    public static final String MODEL_DIFF_REPORT_TARGET_REPORT_FOLDER_NAME = "reports";

    protected abstract CharSequence doGenerate(Comparison var1);

    public void generate(Comparison comparison, IFile targetFile) {
        this.writeFile(targetFile, this.doGenerate(comparison));
    }

    public Notifier getLeftObject(Comparison comparison) {
        boolean _notEquals;
        Object _xblockexpression = null;
        boolean bl = _notEquals = !Objects.equal((Object)comparison, null);
        if (_notEquals) {
            boolean _not_1;
            boolean _not;
            boolean _isEmpty = comparison.getMatchedResources().isEmpty();
            boolean bl2 = _not = !_isEmpty;
            if (_not) {
                MatchResource matchResource = (MatchResource)comparison.getMatchedResources().get(0);
                return matchResource.getLeft();
            }
            boolean _isEmpty_1 = comparison.getMatches().isEmpty();
            boolean bl3 = _not_1 = !_isEmpty_1;
            if (_not_1) {
                Match match = (Match)comparison.getMatches().get(0);
                return match.getLeft();
            }
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    public Notifier getRightObject(Comparison comparison) {
        boolean _notEquals;
        Object _xblockexpression = null;
        boolean bl = _notEquals = !Objects.equal((Object)comparison, null);
        if (_notEquals) {
            boolean _not_1;
            boolean _not;
            boolean _isEmpty = comparison.getMatchedResources().isEmpty();
            boolean bl2 = _not = !_isEmpty;
            if (_not) {
                MatchResource matchResource = (MatchResource)comparison.getMatchedResources().get(0);
                return matchResource.getRight();
            }
            boolean _isEmpty_1 = comparison.getMatches().isEmpty();
            boolean bl3 = _not_1 = !_isEmpty_1;
            if (_not_1) {
                Match match = (Match)comparison.getMatches().get(0);
                return match.getRight();
            }
        }
        _xblockexpression = null;
        return _xblockexpression;
    }

    public IProject getTargetProject(Comparison comparison) {
        block6: {
            boolean _notEquals;
            boolean bl = _notEquals = !Objects.equal((Object)comparison, null);
            if (!_notEquals) break block6;
            boolean _isEmpty = comparison.getMatchedResources().isEmpty();
            if (_isEmpty) {
                EList _matches = comparison.getMatches();
                for (Match match : _matches) {
                    boolean _notEquals_1;
                    IFile file = EcorePlatformUtil.getFile((EObject)match.getLeft());
                    boolean _equals = Objects.equal((Object)file, null);
                    if (_equals) {
                        file = EcorePlatformUtil.getFile((EObject)match.getRight());
                    }
                    boolean bl2 = _notEquals_1 = !Objects.equal((Object)file, null);
                    if (!_notEquals_1) continue;
                    return file.getProject();
                }
            } else {
                EList _matchedResources = comparison.getMatchedResources();
                for (MatchResource matchResource : _matchedResources) {
                    boolean _notEquals_1;
                    IFile file = EcorePlatformUtil.getFile((Resource)matchResource.getLeft());
                    boolean _equals = Objects.equal((Object)file, null);
                    if (_equals) {
                        file = EcorePlatformUtil.getFile((Resource)matchResource.getRight());
                    }
                    boolean bl3 = _notEquals_1 = !Objects.equal((Object)file, null);
                    if (!_notEquals_1) continue;
                    return file.getProject();
                }
            }
        }
        return null;
    }

    public String getModelCompareInputText(Object object) {
        String label = "";
        if (object instanceof EObject) {
            URI uri = EcoreResourceUtil.getURI((EObject)((EObject)object), (boolean)true);
            label = uri.trimQuery().toString();
        } else if (object instanceof Resource) {
            label = ((Resource)object).getURI().trimQuery().toString();
        }
        return label;
    }

    public String getName(Object object) {
        String name = "";
        if (object instanceof EObject) {
            boolean _notEquals;
            EStructuralFeature eStructuralFeature = EObjectUtil.getEStructuralFeature((Object)((EObject)object).eClass(), (String)"name");
            boolean bl = _notEquals = !Objects.equal((Object)eStructuralFeature, null);
            if (_notEquals) {
                Object _eGet = ((EObject)object).eGet(eStructuralFeature, false);
                String _string = null;
                if (_eGet != null) {
                    _string = _eGet.toString();
                }
                name = _string;
            } else {
                String _plus_1;
                String _name = ((EObject)object).eClass().getName();
                String _plus = String.valueOf(_name) + "@";
                String _hexString = Integer.toHexString(((EObject)object).hashCode());
                name = _plus_1 = String.valueOf(_plus) + _hexString;
            }
        } else if (object instanceof Resource) {
            name = ((Resource)object).getURI().trimQuery().lastSegment();
        }
        return name;
    }

    public String getDiffKindText(Diff diff) {
        DifferenceKind kind;
        boolean _equals;
        DifferenceKind _kind = null;
        if (diff != null) {
            _kind = diff.getKind();
        }
        if (_equals = Objects.equal((Object)(kind = _kind), (Object)DifferenceKind.DELETE)) {
            if (diff instanceof ReferenceChange) {
                EReference reference = ((ReferenceChange)diff).getReference();
                boolean _isContainment = reference.isContainment();
                if (_isContainment) {
                    return "DELETED from ";
                }
                return "REMOVED from ";
            }
        } else {
            boolean _equals_1 = Objects.equal((Object)kind, (Object)DifferenceKind.ADD);
            if (_equals_1) {
                return "ADDED to ";
            }
        }
        return kind + "D ";
    }

    public String getDiffKindLabel(DifferenceKind kind) {
        if (kind != null) {
            switch (kind) {
                case ADD: {
                    return "+-";
                }
                case DELETE: {
                    return "-+";
                }
                case CHANGE: {
                    return "<>";
                }
                case MOVE: {
                    return "~";
                }
            }
            return "<>";
        }
        return "<>";
    }

    public Map<String, Object> handleDifferences(Comparison comparison, Diff diff) {
        boolean _notEquals;
        HashMap map = CollectionLiterals.newHashMap((Pair[])new Pair[0]);
        boolean bl = _notEquals = !Objects.equal((Object)diff, null);
        if (_notEquals) {
            DifferenceKind kind = diff.getKind();
            map.put(MODEL_DIFF_REPORT_KIND, this.getDiffKindLabel(kind));
            map.put(MODEL_DIFF_REPORT_LEFT_DIFF_URI, this.getDiffObjectURIFragment(diff, DifferenceSource.LEFT));
            map.put(MODEL_DIFF_REPORT_RIGHT_DIFF_URI, this.getDiffObjectURIFragment(diff, DifferenceSource.RIGHT));
            if (diff instanceof AttributeChange) {
                map.put(MODEL_DIFF_REPORT_LEFT_DIFF_TEXT, this.getAttributeChangeText((AttributeChange)diff));
                map.put(MODEL_DIFF_REPORT_RIGHT_DIFF_TEXT, this.getAttributeChangeText((AttributeChange)diff));
            } else {
                DifferenceSource _source = diff.getSource();
                boolean _equals = Objects.equal((Object)_source, (Object)DifferenceSource.LEFT);
                if (_equals) {
                    boolean _equals_1 = Objects.equal((Object)kind, (Object)DifferenceKind.ADD);
                    if (_equals_1) {
                        map.put(MODEL_DIFF_REPORT_LEFT_DIFF_TEXT, this.getReferenceChangeText(diff, false));
                        map.put(MODEL_DIFF_REPORT_RIGHT_DIFF_TEXT, this.getReferenceChangeText(diff, true));
                    } else {
                        boolean _equals_2 = Objects.equal((Object)kind, (Object)DifferenceKind.DELETE);
                        if (_equals_2) {
                            map.put(MODEL_DIFF_REPORT_LEFT_DIFF_TEXT, this.getReferenceChangeText(diff, false));
                            map.put(MODEL_DIFF_REPORT_RIGHT_DIFF_TEXT, this.getReferenceChangeText(diff, true));
                        } else {
                            boolean _equals_3 = Objects.equal((Object)kind, (Object)DifferenceKind.MOVE);
                            if (_equals_3) {
                                map.put(MODEL_DIFF_REPORT_LEFT_DIFF_TEXT, this.getReferenceChangeText(diff, false));
                                map.put(MODEL_DIFF_REPORT_RIGHT_DIFF_TEXT, this.getReferenceChangeText(diff, true));
                            }
                        }
                    }
                } else {
                    boolean _equals_4 = Objects.equal((Object)kind, (Object)DifferenceKind.ADD);
                    if (_equals_4) {
                        map.put(MODEL_DIFF_REPORT_LEFT_DIFF_TEXT, this.getReferenceChangeText(diff, true));
                        map.put(MODEL_DIFF_REPORT_RIGHT_DIFF_TEXT, this.getReferenceChangeText(diff, false));
                    } else {
                        boolean _equals_5 = Objects.equal((Object)kind, (Object)DifferenceKind.DELETE);
                        if (_equals_5) {
                            map.put(MODEL_DIFF_REPORT_LEFT_DIFF_TEXT, this.getReferenceChangeText(diff, true));
                            map.put(MODEL_DIFF_REPORT_RIGHT_DIFF_TEXT, this.getReferenceChangeText(diff, false));
                        } else {
                            boolean _equals_6 = Objects.equal((Object)kind, (Object)DifferenceKind.MOVE);
                            if (_equals_6) {
                                map.put(MODEL_DIFF_REPORT_LEFT_DIFF_TEXT, this.getReferenceChangeText(diff, true));
                                map.put(MODEL_DIFF_REPORT_RIGHT_DIFF_TEXT, this.getReferenceChangeText(diff, false));
                            }
                        }
                    }
                }
            }
        }
        return map;
    }

    public StringBuffer getDiffObjectURIFragment(Diff diff, DifferenceSource source) {
        boolean _notEquals;
        StringBuffer _xblockexpression = null;
        StringBuffer label = new StringBuffer();
        EObject value = null;
        if (diff instanceof AttributeChange) {
            Match match = ((AttributeChange)diff).getMatch();
            EObject _xifexpression = null;
            boolean _equals = Objects.equal((Object)source, (Object)DifferenceSource.LEFT);
            _xifexpression = _equals ? match.getLeft() : match.getRight();
            value = _xifexpression;
        } else if (diff instanceof ReferenceChange) {
            value = ModelCompareUtil.getValue(((ReferenceChange)diff).getMatch().getComparison(), diff);
        }
        boolean bl = _notEquals = !Objects.equal(value, null);
        if (_notEquals) {
            URI _uRI = EcoreResourceUtil.getURI((EObject)value);
            String _fragment = null;
            if (_uRI != null) {
                _fragment = _uRI.fragment();
            }
            label.append(_fragment);
        }
        _xblockexpression = label;
        return _xblockexpression;
    }

    public StringBuffer getAttributeChangeText(AttributeChange attributeChange) {
        boolean _notEquals;
        StringBuffer _xblockexpression = null;
        StringBuffer label = new StringBuffer();
        boolean bl = _notEquals = !Objects.equal((Object)attributeChange, null);
        if (_notEquals) {
            EAttribute _attribute = attributeChange.getAttribute();
            String _name = null;
            if (_attribute != null) {
                _name = _attribute.getName();
            }
            String _plus = "[" + _name;
            String _plus_1 = String.valueOf(_plus) + " ";
            DifferenceKind _kind = attributeChange.getKind();
            String _plus_2 = String.valueOf(_plus_1) + _kind;
            String _plus_3 = String.valueOf(_plus_2) + "D";
            String _plus_4 = String.valueOf(_plus_3) + "]";
            label.append(_plus_4);
        }
        _xblockexpression = label;
        return _xblockexpression;
    }

    public StringBuffer getReferenceChangeText(Diff diff, boolean opposite) {
        StringBuffer _xblockexpression = null;
        StringBuffer label = new StringBuffer();
        if (diff instanceof ReferenceChange) {
            DifferenceKind kind = ((ReferenceChange)diff).getKind();
            String kindLabel = "";
            if (!opposite) {
                kindLabel = this.getDiffKindText(diff);
            } else {
                boolean _equals = Objects.equal((Object)kind, (Object)DifferenceKind.ADD);
                if (_equals) {
                    boolean _not;
                    kindLabel = "DELETED from ";
                    EReference reference = ((ReferenceChange)diff).getReference();
                    boolean _isContainment = reference.isContainment();
                    boolean bl = _not = !_isContainment;
                    if (_not) {
                        kindLabel = "REMOVED from ";
                    }
                } else {
                    String _plus;
                    boolean _equals_1 = Objects.equal((Object)kind, (Object)DifferenceKind.DELETE);
                    kindLabel = _equals_1 ? "ADDED to " : (_plus = kind + "D ");
                }
            }
            EObject _xifexpression = null;
            _xifexpression = !opposite ? ((ReferenceChange)diff).getMatch().getLeft() : ((ReferenceChange)diff).getMatch().getRight();
            EObject matchValue = _xifexpression;
            StringBuffer _append = label.append(" [").append(kindLabel);
            String _name = this.getName(matchValue);
            String _plus_1 = String.valueOf(_name) + ".";
            EReference _reference = ((ReferenceChange)diff).getReference();
            String _name_1 = null;
            if (_reference != null) {
                _name_1 = _reference.getName();
            }
            String _plus_2 = String.valueOf(_plus_1) + _name_1;
            return _append.append(_plus_2).append("]");
        }
        _xblockexpression = label;
        return _xblockexpression;
    }

    public void writeFile(IFile targetFile, CharSequence content) {
        try {
            NullProgressMonitor monitor = new NullProgressMonitor();
            boolean _exists = targetFile.exists();
            if (_exists) {
                targetFile.delete(true, (IProgressMonitor)monitor);
            }
            byte[] _bytes = content.toString().getBytes();
            ByteArrayInputStream _byteArrayInputStream = new ByteArrayInputStream(_bytes);
            targetFile.create((InputStream)_byteArrayInputStream, true, (IProgressMonitor)monitor);
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void createFolder(IFolder folder) {
        try {
            boolean _not;
            NullProgressMonitor monitor = new NullProgressMonitor();
            boolean _exists = folder.exists();
            boolean bl = _not = !_exists;
            if (_not) {
                folder.create(true, false, (IProgressMonitor)monitor);
            }
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public void postComparison(Comparison comparison, Monitor monitor) {
    }

    public void postConflicts(Comparison comparison, Monitor monitor) {
    }

    public void postDiff(Comparison comparison, Monitor monitor) {
    }

    public void postEquivalences(Comparison comparison, Monitor monitor) {
    }

    public void postMatch(Comparison comparison, Monitor monitor) {
    }

    public void postRequirements(Comparison comparison, Monitor monitor) {
    }
}

