/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.testing.internal.testunit;

import java.io.File;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.ASTVisitor;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.expressions.CallExpression;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.environment.IEnvironment;
import org.eclipse.dltk.launching.InterpreterConfig;
import org.eclipse.dltk.ruby.ast.RubyClassDeclaration;
import org.eclipse.dltk.ruby.testing.internal.AbstractRubyTestingEngine;
import org.eclipse.dltk.ruby.testing.internal.AbstractTestingEngineValidateVisitor;
import org.eclipse.dltk.ruby.testing.internal.Messages;
import org.eclipse.dltk.ruby.testing.internal.ResolverUtils;
import org.eclipse.dltk.ruby.testing.internal.RubyTestingLaunchConfigurationDelegate;
import org.eclipse.dltk.ruby.testing.internal.testunit.ShouldaUtils;
import org.eclipse.dltk.ruby.testing.internal.testunit.TestUnitTestRunnerUI;
import org.eclipse.dltk.testing.ITestRunnerUI;
import org.eclipse.osgi.util.NLS;

public class TestUnitTestingEngine
extends AbstractRubyTestingEngine {
    static final String TEST_UNIT_RUNNER = "dltk-testunit-runner.rb";
    static /* synthetic */ Class class$0;

    public IStatus validateSourceModule(ISourceModule module) {
        ModuleDeclaration declaration = ResolverUtils.parse(module);
        if (declaration == null) {
            return TestUnitTestingEngine.createStatus(2, Messages.validate_sourceErrors);
        }
        TestUnitValidateVisitor visitor = new TestUnitValidateVisitor(module);
        try {
            declaration.traverse((ASTVisitor)visitor);
        }
        catch (Exception e) {
            return TestUnitTestingEngine.createStatus(2, NLS.bind((String)Messages.validate_runtimeError, (Object)e.getMessage()));
        }
        return visitor.getStatus();
    }

    public void configureLaunch(InterpreterConfig config, ILaunchConfiguration configuration, ILaunch launch) throws CoreException {
        String strPort = String.valueOf(this.allocatePort());
        launch.setAttribute("org.eclipse.dltk.testing.PORT", strPort);
        config.addEnvVar("RUBY_TESTING_PORT", strPort);
        if (!RubyTestingLaunchConfigurationDelegate.isContainerMode(configuration)) {
            if (config.getEnvironment().isLocal() && !this.isDevelopmentMode(config, TEST_UNIT_RUNNER)) {
                File runnerFile = this.getRunnerFile(this.getBundle(), "/testing/", TEST_UNIT_RUNNER);
                config.addInterpreterArg("-r");
                config.addInterpreterArg(runnerFile.getPath());
            }
        } else {
            String containerHandle = configuration.getAttribute("org.eclipse.dltk.testing.CONTAINER", "");
            Assert.isLegal((containerHandle.length() != 0 ? 1 : 0) != 0);
            IModelElement element = DLTKCore.create((String)containerHandle);
            Assert.isNotNull((Object)element);
            IResource resource = element.getUnderlyingResource();
            Assert.isNotNull((Object)resource);
            IPath path = resource.getProjectRelativePath();
            if (path.isEmpty()) {
                config.addEnvVar("RUBY_TESTING_PATH", ".");
            } else {
                config.addEnvVar("RUBY_TESTING_PATH", path.toOSString());
            }
        }
    }

    public String getMainScriptPath(ILaunchConfiguration configuration, IEnvironment scriptEnvironment) throws CoreException {
        if (RubyTestingLaunchConfigurationDelegate.isContainerMode(configuration)) {
            return this.getRunnerFile(this.getBundle(), "/testing/", TEST_UNIT_RUNNER).getPath();
        }
        return null;
    }

    public ITestRunnerUI getTestRunnerUI(IScriptProject project, ILaunchConfiguration configuration) {
        return new TestUnitTestRunnerUI(this, project);
    }

    static /* synthetic */ IStatus access$0(int n, String string) {
        return AbstractRubyTestingEngine.createStatus(n, string);
    }

    static class TestUnitValidateVisitor
    extends AbstractTestingEngineValidateVisitor {
        private static final String TEST_UNIT = "test/unit";
        private static final String SHOULDA = "shoulda";
        private static final String TEST_UNIT_TEST_CASE = "Test::Unit::TestCase";
        private static final String TEST = "test";
        private ISourceModule module;
        private int testUnitWeight = 0;
        private int shouldaWeight = 0;
        static final int REQUIRE_WEIGHT = 10;
        static final int TESTCASE_WEIGHT = 10;
        static final int METHOD_WEIGHT = 1;

        public TestUnitValidateVisitor(ISourceModule module) {
            this.module = module;
        }

        public boolean visitGeneral(ASTNode node) throws Exception {
            if (node instanceof CallExpression) {
                CallExpression call = (CallExpression)node;
                if (this.isRequire(call, TEST_UNIT)) {
                    this.testUnitWeight += 10;
                } else if (this.isRequire(call, SHOULDA)) {
                    this.shouldaWeight += 10;
                } else if (this.isMethodCall(call, ShouldaUtils.METHODS)) {
                    ++this.shouldaWeight;
                }
            } else if (node instanceof RubyClassDeclaration) {
                if (this.isSuperClassOf(this.module, (RubyClassDeclaration)node, TEST_UNIT_TEST_CASE)) {
                    this.testUnitWeight += 10;
                }
            } else if (node instanceof MethodDeclaration) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.dltk.ruby.ast.RubyClassDeclaration");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (this.isNodeOnStack(clazz) && this.isMethodPrefix((MethodDeclaration)node, TEST)) {
                    ++this.testUnitWeight;
                }
            }
            return super.visitGeneral(node);
        }

        public IStatus getStatus() {
            if (this.testUnitWeight + this.shouldaWeight > Math.min(10, 10)) {
                return Status.OK_STATUS;
            }
            if (this.testUnitWeight + this.shouldaWeight >= 1) {
                return TestUnitTestingEngine.access$0(1, Messages.validate_probablyTestUnit);
            }
            return TestUnitTestingEngine.access$0(2, Messages.validate_notTestUnit);
        }
    }
}

