/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.index.lucene;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.apache.lucene.index.ConcurrentMergeScheduler;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.MergeScheduler;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.SimpleFSLockFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.core.index.lucene.LucenePlugin;
import org.eclipse.dltk.internal.core.index.lucene.IndexDirectory;
import org.eclipse.dltk.internal.core.index.lucene.IndexRecovery;
import org.eclipse.dltk.internal.core.index.lucene.IndexType;
import org.eclipse.dltk.internal.core.index.lucene.Logger;
import org.eclipse.dltk.internal.core.index.lucene.Utils;

class IndexContainer {
    private static final String TIMESTAMPS_DIR = "timestamps";
    private static final long WRITE_LOCK_TIMEOUT = 3000L;
    private final String fIndexRoot;
    private final String fContainerId;
    private IndexWriter fTimestampsWriter;
    private SearcherManager fTimestampsSearcher;
    private Map<IndexType, Map<Integer, IndexWriter>> fIndexWriters;
    private Map<IndexType, Map<Integer, SearcherManager>> fIndexSearchers;

    public IndexContainer(String indexRoot, String containerId) {
        this.fIndexRoot = indexRoot;
        this.fContainerId = containerId;
        this.initialize();
    }

    private void initialize() {
        this.fIndexWriters = new HashMap<IndexType, Map<Integer, IndexWriter>>();
        this.fIndexWriters.put(IndexType.DECLARATIONS, new HashMap());
        this.fIndexWriters.put(IndexType.REFERENCES, new HashMap());
        this.fIndexSearchers = new HashMap<IndexType, Map<Integer, SearcherManager>>();
        this.fIndexSearchers.put(IndexType.DECLARATIONS, new HashMap());
        this.fIndexSearchers.put(IndexType.REFERENCES, new HashMap());
    }

    private void purgeLocks(Path path) {
        Path writeLockPath = path.resolve("write.lock");
        if (writeLockPath.toFile().exists()) {
            try {
                Files.delete(writeLockPath);
            }
            catch (IOException e) {
                Logger.logException(e);
            }
        }
    }

    private IndexWriter createWriter(Path path) throws IOException {
        IndexDirectory indexDir = new IndexDirectory(path, (LockFactory)SimpleFSLockFactory.INSTANCE);
        this.purgeLocks(path);
        IndexWriterConfig config = new IndexWriterConfig((Analyzer)new SimpleAnalyzer());
        ConcurrentMergeScheduler mergeScheduler = new ConcurrentMergeScheduler();
        mergeScheduler.setDefaultMaxMergesAndThreads(true);
        config.setMergeScheduler((MergeScheduler)mergeScheduler);
        config.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        config.setWriteLockTimeout(3000L);
        config.setCommitOnClose(false);
        return new IndexWriter((Directory)indexDir, config);
    }

    private IndexWriter getWriter(Path path) {
        IndexWriter indexWriter = null;
        try {
            indexWriter = this.createWriter(path);
        }
        catch (IOException e) {
            IndexRecovery.tryRecover(this, path, e);
            try {
                indexWriter = this.createWriter(path);
            }
            catch (IOException ex) {
                Logger.logException(ex);
            }
        }
        return indexWriter;
    }

    public final String getId() {
        return this.fContainerId;
    }

    public synchronized IndexWriter getTimestampsWriter() {
        if (this.fTimestampsWriter == null) {
            Path writerPath = Paths.get(this.fIndexRoot, this.fContainerId, TIMESTAMPS_DIR);
            this.fTimestampsWriter = this.getWriter(writerPath);
        }
        return this.fTimestampsWriter;
    }

    public synchronized SearcherManager getTimestampsSearcher() {
        try {
            if (this.fTimestampsSearcher == null) {
                this.fTimestampsSearcher = new SearcherManager(this.getTimestampsWriter(), true, new SearcherFactory());
            }
            this.fTimestampsSearcher.maybeRefresh();
        }
        catch (IOException e) {
            Logger.logException(e);
        }
        return this.fTimestampsSearcher;
    }

    public synchronized IndexWriter getIndexWriter(IndexType dataType, int elementType) {
        IndexWriter writer = this.fIndexWriters.get((Object)dataType).get(elementType);
        if (writer == null) {
            Path writerPath = Paths.get(this.fIndexRoot, this.fContainerId, dataType.getDirectory(), String.valueOf(elementType));
            writer = this.getWriter(writerPath);
            this.fIndexWriters.get((Object)dataType).put(elementType, writer);
        }
        return writer;
    }

    public synchronized SearcherManager getIndexSearcher(IndexType dataType, int elementType) {
        SearcherManager searcher = this.fIndexSearchers.get((Object)dataType).get(elementType);
        try {
            if (searcher == null) {
                searcher = new SearcherManager(this.getIndexWriter(dataType, elementType), true, new SearcherFactory());
                this.fIndexSearchers.get((Object)dataType).put(elementType, searcher);
            }
            searcher.maybeRefresh();
        }
        catch (IOException e) {
            Logger.logException(e);
        }
        return searcher;
    }

    public synchronized void delete(String sourceModule) {
        Term term = new Term("path", sourceModule);
        try {
            this.getTimestampsWriter().deleteDocuments(new Term[]{term});
            for (Map<Integer, IndexWriter> dataWriters : this.fIndexWriters.values()) {
                for (IndexWriter writer : dataWriters.values()) {
                    writer.deleteDocuments(new Term[]{term});
                }
            }
        }
        catch (IOException e) {
            Logger.logException(e);
        }
    }

    public synchronized void delete(boolean wait) {
        new IndexCleaner().clean(!wait);
    }

    public synchronized void close() {
        try {
            if (this.fTimestampsSearcher != null) {
                this.fTimestampsSearcher.close();
            }
            if (this.fTimestampsWriter != null) {
                this.fTimestampsWriter.close();
            }
            for (Map<Integer, SearcherManager> map : this.fIndexSearchers.values()) {
                for (SearcherManager searcherManager : map.values()) {
                    if (searcherManager == null) continue;
                    searcherManager.close();
                }
            }
            for (Map<Integer, SearcherManager> map : this.fIndexWriters.values()) {
                for (IndexWriter indexWriter : map.values()) {
                    if (indexWriter == null) continue;
                    indexWriter.close();
                }
            }
        }
        catch (IOException iOException) {
            Logger.logException(iOException);
        }
    }

    synchronized boolean hasChanges() {
        for (Map<Integer, IndexWriter> dataWriters : this.fIndexWriters.values()) {
            for (IndexWriter writer : dataWriters.values()) {
                if (writer == null || !writer.hasUncommittedChanges()) continue;
                return true;
            }
            if (this.fTimestampsWriter == null) continue;
            return this.fTimestampsWriter.hasUncommittedChanges();
        }
        return false;
    }

    synchronized void commit(IProgressMonitor monitor, boolean mergeDeletes) {
        int ticks = 1;
        for (Map<Integer, IndexWriter> dataWriters : this.fIndexWriters.values()) {
            ticks += dataWriters.size();
        }
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)ticks);
        try {
            for (Map<Integer, IndexWriter> dataWriters : this.fIndexWriters.values()) {
                for (IndexWriter writer : dataWriters.values()) {
                    if (writer == null || subMonitor.isCanceled()) continue;
                    writer.forceMergeDeletes(mergeDeletes);
                    writer.commit();
                    subMonitor.worked(1);
                }
            }
            if (this.fTimestampsWriter != null && !subMonitor.isCanceled()) {
                this.fTimestampsWriter.forceMergeDeletes(mergeDeletes);
                this.fTimestampsWriter.commit();
                subMonitor.worked(1);
            }
            subMonitor.done();
        }
        catch (IOException e) {
            Logger.logException(e);
        }
    }

    private final class IndexCleaner
    extends Job {
        public IndexCleaner() {
            super("");
            this.setUser(false);
            this.setSystem(true);
        }

        public boolean belongsTo(Object family) {
            return family == LucenePlugin.LUCENE_JOB_FAMILY;
        }

        protected IStatus run(IProgressMonitor monitor) {
            this.doClean();
            return Status.OK_STATUS;
        }

        void clean(boolean fork) {
            if (fork) {
                this.schedule();
            } else {
                this.doClean();
            }
        }

        private void doClean() {
            IndexContainer.this.close();
            Path containerPath = Paths.get(IndexContainer.this.fIndexRoot, IndexContainer.this.getId());
            try {
                Utils.delete(containerPath);
            }
            catch (IOException e) {
                Logger.logException(e);
            }
        }
    }
}

