/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.index.lucene;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.text.MessageFormat;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.OutputStreamIndexOutput;
import org.apache.lucene.store.RAFDirectory;

public class IndexDirectory
extends RAFDirectory {
    public IndexDirectory(Path path) throws IOException {
        super(path);
    }

    public IndexDirectory(Path path, LockFactory lockFactory) throws IOException {
        super(path, lockFactory);
    }

    public IndexOutput createOutput(String name, IOContext context) throws IOException {
        this.ensureOpen();
        this.ensureCanWrite(name);
        return new RAFIndexOutput(name);
    }

    final class RAFIndexOutput
    extends OutputStreamIndexOutput {
        private static final int CHUNK_SIZE = 8192;
        private static final String DESCRIPTION = "RAFIndexOutput(path=\"{0}\")";

        public RAFIndexOutput(String name) throws IOException {
            super(MessageFormat.format(DESCRIPTION, IndexDirectory.this.directory.resolve(name)), (OutputStream)new RAFOutputStream(new FileOutputStream(new File(IndexDirectory.this.directory.resolve(name).toString())), 8192), 8192);
        }
    }

    static final class RAFOutputStream
    extends FilterOutputStream {
        private final int fChunkSize;

        public RAFOutputStream(OutputStream out, int chunkSize) {
            super(out);
            this.fChunkSize = chunkSize;
        }

        @Override
        public void write(byte[] b, int offset, int length) throws IOException {
            while (length > 0) {
                int chunk = Math.min(length, this.fChunkSize);
                this.out.write(b, offset, chunk);
                length -= chunk;
                offset += chunk;
            }
        }
    }
}

