/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.debug.ui.launcher;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.StringVariableSelectionDialog;
import org.eclipse.dltk.debug.ui.DLTKDebugUIPlugin;
import org.eclipse.dltk.debug.ui.actions.ControlAccessibleListener;
import org.eclipse.dltk.debug.ui.launchConfigurations.CommonScriptLaunchTab;
import org.eclipse.dltk.debug.ui.messages.ScriptLaunchMessages;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class InterpreterArgumentsBlock
extends CommonScriptLaunchTab {
    protected Text fInterpreterArgumentsText;
    private Button fPgrmArgVariableButton;

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Group group = new Group(parent, 0);
        this.setControl((Control)group);
        GridLayout topLayout = new GridLayout();
        group.setLayout((Layout)topLayout);
        GridData gd = new GridData(1808);
        group.setLayoutData((Object)gd);
        group.setFont(font);
        group.setText(ScriptLaunchMessages.InterpreterArgumentsTab_Interpreter_ar_guments);
        this.fInterpreterArgumentsText = new Text((Composite)group, 2626);
        gd = new GridData(1808);
        gd.heightHint = 40;
        gd.widthHint = 100;
        this.fInterpreterArgumentsText.setLayoutData((Object)gd);
        this.fInterpreterArgumentsText.setFont(font);
        this.fInterpreterArgumentsText.addModifyListener(evt -> this.updateLaunchConfigurationDialog());
        ControlAccessibleListener.addListener((Control)this.fInterpreterArgumentsText, group.getText());
        this.fPgrmArgVariableButton = this.createPushButton((Composite)group, ScriptLaunchMessages.InterpreterArgumentsBlock, null);
        this.fPgrmArgVariableButton.setFont(font);
        this.fPgrmArgVariableButton.setLayoutData((Object)new GridData(128));
        this.fPgrmArgVariableButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StringVariableSelectionDialog dialog = new StringVariableSelectionDialog(InterpreterArgumentsBlock.this.getShell());
                dialog.open();
                String variable = dialog.getVariableExpression();
                if (variable != null) {
                    InterpreterArgumentsBlock.this.fInterpreterArgumentsText.insert(variable);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("interpreterArguments", null);
    }

    @Override
    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.fInterpreterArgumentsText.setText(configuration.getAttribute("interpreterArguments", ""));
        }
        catch (CoreException e) {
            this.setErrorMessage(NLS.bind((String)ScriptLaunchMessages.InterpreterArgumentsTab_Exception_occurred_reading_configuration, (Object)e.getStatus().getMessage()));
            DLTKDebugUIPlugin.log(e);
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("interpreterArguments", this.getAttributeValueFrom(this.fInterpreterArgumentsText));
    }

    public String getName() {
        return ScriptLaunchMessages.InterpreterArgumentsBlock_Interpreter_Arguments;
    }

    protected String getAttributeValueFrom(Text text) {
        String content = text.getText().trim();
        if (content.length() > 0) {
            return content;
        }
        return null;
    }

    public void setEnabled(boolean enabled) {
        this.fInterpreterArgumentsText.setEnabled(enabled);
        this.fPgrmArgVariableButton.setEnabled(enabled);
    }
}

