/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.editor;

import java.util.Stack;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public abstract class BracketInserter
implements VerifyKeyListener,
ILinkedModeListener {
    protected final ScriptEditor editor;
    protected boolean fCloseBrackets = true;
    protected boolean fCloseStrings = true;
    protected boolean fCloseAngularBrackets = true;
    protected final String CATEGORY;
    protected IPositionUpdater fUpdater;
    protected Stack<ScriptEditor.BracketLevel> fBracketLevelStack = new Stack();

    protected BracketInserter(ScriptEditor editor) {
        this.editor = editor;
        this.CATEGORY = this.editor.toString();
        this.fUpdater = new ScriptEditor.ExclusivePositionUpdater(this.CATEGORY);
    }

    public void setCloseBracketsEnabled(boolean enabled) {
        this.fCloseBrackets = enabled;
    }

    public void setCloseStringsEnabled(boolean enabled) {
        this.fCloseStrings = enabled;
    }

    public void setCloseAngularBracketsEnabled(boolean enabled) {
        this.fCloseAngularBrackets = enabled;
    }

    protected boolean isAngularIntroducer(String identifier) {
        return false;
    }

    protected static char getEscapeCharacter(char character) {
        switch (character) {
            case '\"': 
            case '\'': {
                return '\\';
            }
        }
        return '\u0000';
    }

    protected static char getPeerCharacter(char character) {
        switch (character) {
            case '(': {
                return ')';
            }
            case ')': {
                return '(';
            }
            case '<': {
                return '>';
            }
            case '>': {
                return '<';
            }
            case '[': {
                return ']';
            }
            case ']': {
                return '[';
            }
            case '{': {
                return '}';
            }
            case '}': {
                return '{';
            }
            case '\"': {
                return character;
            }
            case '\'': {
                return character;
            }
        }
        throw new IllegalArgumentException();
    }

    public abstract void verifyKey(VerifyEvent var1);

    public void left(LinkedModeModel environment, int flags) {
        ScriptEditor.BracketLevel level = this.fBracketLevelStack.pop();
        if (flags != 8) {
            return;
        }
        ISourceViewer sourceViewer = this.editor.getScriptSourceViewer();
        IDocument document = sourceViewer.getDocument();
        if (document instanceof IDocumentExtension) {
            IDocumentExtension extension = (IDocumentExtension)document;
            extension.registerPostNotificationReplace(null, (d, owner) -> {
                if ((bracketLevel.fFirstPosition.isDeleted || bracketLevel.fFirstPosition.length == 0) && !bracketLevel.fSecondPosition.isDeleted && bracketLevel.fSecondPosition.offset == bracketLevel.fFirstPosition.offset) {
                    try {
                        document.replace(bracketLevel.fSecondPosition.offset, bracketLevel.fSecondPosition.length, "");
                    }
                    catch (BadLocationException e1) {
                        DLTKUIPlugin.log(e1);
                    }
                }
                if (this.fBracketLevelStack.size() == 0) {
                    document.removePositionUpdater(this.fUpdater);
                    try {
                        document.removePositionCategory(this.CATEGORY);
                    }
                    catch (BadPositionCategoryException e2) {
                        DLTKUIPlugin.log(e2);
                    }
                }
            });
        }
    }

    public void suspend(LinkedModeModel environment) {
    }

    public void resume(LinkedModeModel environment, int flags) {
    }

    protected void insertBrackets(IDocument document, int offset, int length, char character, char closingCharacter) throws BadLocationException, BadPositionCategoryException {
        document.replace(offset, length, new String(new char[]{character, closingCharacter}));
        ScriptEditor.BracketLevel level = new ScriptEditor.BracketLevel();
        this.fBracketLevelStack.push(level);
        LinkedPositionGroup group = new LinkedPositionGroup();
        group.addPosition(new LinkedPosition(document, offset + 1, 0, -1));
        LinkedModeModel model = new LinkedModeModel();
        model.addLinkingListener((ILinkedModeListener)this);
        model.addGroup(group);
        model.forceInstall();
        level.fOffset = offset;
        level.fLength = 2;
        if (this.fBracketLevelStack.size() == 1) {
            document.addPositionCategory(this.CATEGORY);
            document.addPositionUpdater(this.fUpdater);
        }
        level.fFirstPosition = new Position(offset, 1);
        level.fSecondPosition = new Position(offset + 1, 1);
        document.addPosition(this.CATEGORY, level.fFirstPosition);
        document.addPosition(this.CATEGORY, level.fSecondPosition);
        ISourceViewer sourceViewer = this.editor.getScriptSourceViewer();
        level.fUI = new EditorLinkedModeUI(model, (ITextViewer)sourceViewer);
        level.fUI.setSimpleMode(true);
        LinkedModeUI linkedModeUI = level.fUI;
        ScriptEditor scriptEditor = this.editor;
        scriptEditor.getClass();
        linkedModeUI.setExitPolicy((LinkedModeUI.IExitPolicy)scriptEditor.new ScriptEditor.ExitPolicy(closingCharacter, BracketInserter.getEscapeCharacter(closingCharacter), this.fBracketLevelStack));
        level.fUI.setExitPosition((ITextViewer)sourceViewer, offset + 2, 0, Integer.MAX_VALUE);
        level.fUI.setCyclingMode(LinkedModeUI.CYCLE_NEVER);
        level.fUI.enter();
        IRegion newSelection = level.fUI.getSelectedRegion();
        sourceViewer.setSelectedRange(newSelection.getOffset(), newSelection.getLength());
    }

    protected static boolean validatePartitioning(IDocument document, int offset, String partitioning, String ... contentTypes) throws BadLocationException {
        ITypedRegion partition = TextUtilities.getPartition((IDocument)document, (String)partitioning, (int)offset, (boolean)true);
        if (contentTypes.length != 0) {
            String[] stringArray = contentTypes;
            int n = contentTypes.length;
            int n2 = 0;
            while (n2 < n) {
                String contentType = stringArray[n2];
                if (contentType.equals(partition.getType())) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        return "__dftl_partition_content_type".equals(partition.getType());
    }
}

