/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.compiler.problem;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.dltk.compiler.problem.IProblemIdentifier;
import org.eclipse.dltk.compiler.problem.IProblemIdentifierFactory;
import org.eclipse.dltk.compiler.problem.ProblemIdentifierInt;
import org.eclipse.dltk.compiler.problem.ProblemIdentifierString;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.utils.NatureExtensionManager;

public enum DefaultProblemIdentifier implements IProblemIdentifier
{
    TASK;

    private static final Set<String> reportedProblemIds;
    private static final char SEPARATOR = '#';
    private static Manager manager;

    static {
        reportedProblemIds = new HashSet<String>();
        manager = null;
    }

    @Override
    public String contributor() {
        return "org.eclipse.dltk.core";
    }

    private static synchronized Manager getManager() {
        if (manager == null) {
            manager = new Manager();
        }
        return manager;
    }

    public static IProblemIdentifier decode(int id) {
        if (id == 0 || id == -1) {
            return null;
        }
        return new ProblemIdentifierInt(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static IProblemIdentifier decode(String id) {
        if (id != null && id.length() != 0) {
            IProblemIdentifierFactory[] factories;
            int pos = id.indexOf(35);
            if (pos >= 0 && (factories = (IProblemIdentifierFactory[])DefaultProblemIdentifier.getManager().getInstances(id.substring(0, pos))) != null) {
                String localName = id.substring(pos + 1);
                IProblemIdentifierFactory[] iProblemIdentifierFactoryArray = factories;
                int n = factories.length;
                int n2 = 0;
                while (n2 < n) {
                    IProblemIdentifierFactory factory = iProblemIdentifierFactoryArray[n2];
                    try {
                        IProblemIdentifier value = factory.valueOf(localName);
                        if (value != null) {
                            return value;
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                    ++n2;
                }
            }
            Set<String> set = reportedProblemIds;
            synchronized (set) {
                if (reportedProblemIds.size() < 100 && reportedProblemIds.add(id)) {
                    DLTKCore.warn("Error decoding problem idenfier \"" + id + "\"");
                }
            }
            try {
                return new ProblemIdentifierInt(Integer.parseInt(id));
            }
            catch (NumberFormatException numberFormatException) {
                return new ProblemIdentifierString(id);
            }
        }
        return null;
    }

    public static IProblemIdentifier getProblemId(IMarker marker) {
        return DefaultProblemIdentifier.decode(marker.getAttribute("id", null));
    }

    public static String encode(IProblemIdentifier identifier) {
        if (identifier == null) {
            return "";
        }
        if (identifier instanceof Enum) {
            return String.valueOf(identifier.getClass().getName()) + '#' + identifier.name();
        }
        return identifier.name();
    }

    public static DefaultProblemIdentifier[] values() {
        DefaultProblemIdentifier[] defaultProblemIdentifierArray = ENUM$VALUES;
        int n = defaultProblemIdentifierArray.length;
        DefaultProblemIdentifier[] defaultProblemIdentifierArray2 = new DefaultProblemIdentifier[n];
        System.arraycopy(ENUM$VALUES, 0, defaultProblemIdentifierArray2, 0, n);
        return defaultProblemIdentifierArray2;
    }

    private static class Manager
    extends NatureExtensionManager<IProblemIdentifierFactory> {
        public Manager() {
            super("org.eclipse.dltk.core.problemFactory", IProblemIdentifierFactory.class);
        }

        @Override
        protected boolean isValidElement(IConfigurationElement element) {
            return "problemIdentifierFactory".equals(element.getName());
        }

        @Override
        protected String getCategoryAttributeName() {
            return "namespace";
        }
    }
}

