/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core.refactoring.descriptors;

import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.internal.core.refactoring.descriptors.RefactoringDescriptorUtil;
import org.eclipse.dltk.internal.corext.refactoring.ScriptRefactoringDescriptor;

public final class RenameModelElementDescriptor
extends ScriptRefactoringDescriptor {
    private static final String ATTRIBUTE_DELEGATE = "delegate";
    private static final String ATTRIBUTE_DEPRECATE = "deprecate";
    private static final String ATTRIBUTE_HIERARCHICAL = "hierarchical";
    private static final String ATTRIBUTE_MATCH_STRATEGY = "matchStrategy";
    private static final String ATTRIBUTE_PARAMETER = "parameter";
    private static final String ATTRIBUTE_PATTERNS = "patterns";
    private static final String ATTRIBUTE_QUALIFIED = "qualified";
    private static final String ATTRIBUTE_RENAME_GETTER = "getter";
    private static final String ATTRIBUTE_RENAME_SETTER = "setter";
    private static final String ATTRIBUTE_SIMILAR_DECLARATIONS = "similarDeclarations";
    private static final String ATTRIBUTE_TEXTUAL_MATCHES = "textual";
    public static final int STRATEGY_EMBEDDED = 2;
    public static final int STRATEGY_EXACT = 1;
    public static final int STRATEGY_SUFFIX = 3;
    private IModelElement fModelElement = null;
    private String fName = null;
    private boolean fReferences = false;

    public RenameModelElementDescriptor(String id) {
        super(id);
        Assert.isLegal((boolean)this.checkId(id), (String)"Refactoring id is not a rename refactoring id");
    }

    public RenameModelElementDescriptor(String id, String project, String description, String comment, Map arguments, int flags) {
        super(id, project, description, comment, arguments, flags);
        Assert.isLegal((boolean)this.checkId(id), (String)"Refactoring id is not a rename refactoring id");
        this.fName = RefactoringDescriptorUtil.getString(this.fArguments, "name");
        this.fModelElement = RefactoringDescriptorUtil.getModelElement(this.fArguments, "input", this.getProject());
        this.fReferences = RefactoringDescriptorUtil.getBoolean(this.fArguments, "references", this.fReferences);
    }

    private boolean checkId(String id) {
        Assert.isNotNull((Object)id);
        return true;
    }

    @Override
    protected void populateArgumentMap() {
        super.populateArgumentMap();
        RefactoringDescriptorUtil.setString(this.fArguments, "name", this.fName);
        RefactoringDescriptorUtil.setModelElement(this.fArguments, "input", this.getProject(), this.fModelElement);
        RefactoringDescriptorUtil.setBoolean(this.fArguments, "references", this.fReferences);
    }

    public void setModelElement(IModelElement element) {
        Assert.isNotNull((Object)element);
        this.fModelElement = element;
    }

    public void setNewName(String name) {
        Assert.isNotNull((Object)name);
        Assert.isLegal((!"".equals(name) ? 1 : 0) != 0, (String)"Name must not be empty");
        this.fName = name;
    }

    public void setProject(String project) {
        super.setProject(project);
    }

    public void setUpdateReferences(boolean update) {
        this.fReferences = update;
    }
}

