/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IProjectFragment;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ISourceManipulation;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.internal.corext.refactoring.Checks;
import org.eclipse.dltk.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.dltk.internal.corext.refactoring.changes.DeleteFileChange;
import org.eclipse.dltk.internal.corext.refactoring.changes.DeleteFolderChange;
import org.eclipse.dltk.internal.corext.refactoring.changes.DeleteFromBuildpathChange;
import org.eclipse.dltk.internal.corext.refactoring.changes.DeleteProjectFragmentChange;
import org.eclipse.dltk.internal.corext.refactoring.changes.DeleteSourceManipulationChange;
import org.eclipse.dltk.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.dltk.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.dltk.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.text.edits.DeleteEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

class DeleteChangeCreator {
    private DeleteChangeCreator() {
    }

    static Change createDeleteChange(TextChangeManager manager, IResource[] resources, IModelElement[] modelElements, String changeName) throws CoreException {
        DynamicValidationStateChange result = new DynamicValidationStateChange(changeName){

            public Change perform(IProgressMonitor pm) throws CoreException {
                super.perform(pm);
                return null;
            }
        };
        int i = 0;
        while (i < modelElements.length) {
            IModelElement element = modelElements[i];
            if (!ReorgUtils.isInsideSourceModule(element)) {
                result.add(DeleteChangeCreator.createDeleteChange(element));
            }
            ++i;
        }
        i = 0;
        while (i < resources.length) {
            result.add(DeleteChangeCreator.createDeleteChange(resources[i]));
            ++i;
        }
        Map grouped = ReorgUtils.groupBySourceModule(DeleteChangeCreator.getElementsSmallerThanCu(modelElements));
        if (grouped.size() != 0) {
            Assert.isNotNull((Object)manager);
            for (ISourceModule cu : grouped.keySet()) {
                Change change = DeleteChangeCreator.createDeleteChange(cu, (List)grouped.get(cu), manager);
                if (change == null) continue;
                result.add(change);
            }
        }
        return result;
    }

    private static Change createDeleteChange(IResource resource) {
        Assert.isTrue((!(resource instanceof IWorkspaceRoot) ? 1 : 0) != 0);
        Assert.isTrue((!(resource instanceof IProject) ? 1 : 0) != 0);
        if (resource instanceof IFile) {
            return new DeleteFileChange((IFile)resource, true);
        }
        if (resource instanceof IFolder) {
            return new DeleteFolderChange((IFolder)resource, true);
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    private static Change createDeleteChange(ISourceModule cu, List<IModelElement> modelElements, TextChangeManager manager) throws CoreException {
        Assert.isNotNull((Object)cu);
        Assert.isNotNull(modelElements);
        Assert.isNotNull((Object)manager);
        TextFileChange textFileChange = null;
        if (cu != null && cu.getResource() instanceof IFile) {
            textFileChange = new TextFileChange(cu.getElementName(), (IFile)cu.getResource());
            MultiTextEdit fileChangeRootEdit = new MultiTextEdit();
            textFileChange.setEdit((TextEdit)fileChangeRootEdit);
            manager.manage(cu, (TextChange)textFileChange);
            IModelElement[] elements = modelElements.toArray(new IModelElement[modelElements.size()]);
            int cnt = 0;
            int max = elements.length;
            while (cnt < max) {
                ISourceRange sourceRange = null;
                if (elements[cnt] instanceof IMember) {
                    IMember type = (IMember)elements[cnt];
                    sourceRange = type.getSourceRange();
                }
                if (sourceRange != null) {
                    DeleteEdit edit = new DeleteEdit(sourceRange.getOffset(), sourceRange.getLength());
                    fileChangeRootEdit.addChild((TextEdit)edit);
                    if (cu.isWorkingCopy()) {
                        textFileChange.setSaveMode(4);
                    }
                }
                ++cnt;
            }
        }
        return textFileChange;
    }

    private static List getElementsSmallerThanCu(IModelElement[] modelElements) {
        ArrayList<IModelElement> result = new ArrayList<IModelElement>();
        int i = 0;
        while (i < modelElements.length) {
            IModelElement element = modelElements[i];
            if (ReorgUtils.isInsideSourceModule(element)) {
                result.add(element);
            }
            ++i;
        }
        return result;
    }

    private static Change createDeleteChange(IModelElement modelElement) {
        Assert.isTrue((!ReorgUtils.isInsideSourceModule(modelElement) ? 1 : 0) != 0);
        switch (modelElement.getElementType()) {
            case 3: {
                return DeleteChangeCreator.createProjectFragmentDeleteChange((IProjectFragment)modelElement);
            }
            case 4: {
                return DeleteChangeCreator.createSourceManipulationDeleteChange((ISourceManipulation)((IScriptFolder)modelElement));
            }
            case 5: {
                return DeleteChangeCreator.createSourceManipulationDeleteChange((ISourceManipulation)((ISourceModule)modelElement));
            }
            case 1: {
                Assert.isTrue((boolean)false);
                return null;
            }
            case 2: {
                Assert.isTrue((boolean)false);
                return null;
            }
        }
        Assert.isTrue((boolean)false);
        return new NullChange();
    }

    private static Change createSourceManipulationDeleteChange(ISourceManipulation element) {
        IResource resource;
        if ((element instanceof ISourceModule || element instanceof IScriptFolder) && (resource = element instanceof ISourceModule ? ReorgUtils.getResource((IModelElement)((ISourceModule)element)) : ((IScriptFolder)element).getResource()) != null && resource.isLinked()) {
            return DeleteChangeCreator.createDeleteChange(resource);
        }
        return new DeleteSourceManipulationChange(element, true);
    }

    private static Change createProjectFragmentDeleteChange(IProjectFragment root) {
        IResource resource = root.getResource();
        if (resource != null && resource.isLinked()) {
            DynamicValidationStateChange composite = new DynamicValidationStateChange(RefactoringCoreMessages.DeleteRefactoring_delete_package_fragment_root);
            composite.add((Change)new DeleteFromBuildpathChange(root));
            Assert.isTrue((!Checks.isBuildpathDelete(root) ? 1 : 0) != 0);
            composite.add(DeleteChangeCreator.createDeleteChange(resource));
            return composite;
        }
        Assert.isTrue((!root.isExternal() ? 1 : 0) != 0);
        return new DeleteProjectFragmentChange(root, true, null);
    }
}

