/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.core.model.internal;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.expressions.NumericLiteral;
import org.eclipse.dltk.ruby.core.model.ICalculatedType;
import org.eclipse.dltk.ruby.core.model.IElement;
import org.eclipse.dltk.ruby.core.model.IElementCriteria;
import org.eclipse.dltk.ruby.core.model.IElementKind;
import org.eclipse.dltk.ruby.core.model.IMethod;
import org.eclipse.dltk.ruby.core.model.internal.Model;

public class RubyTypeCalculator {
    private final Model model;

    public RubyTypeCalculator(Model model) {
        this.model = model;
    }

    public ICalculatedType calculateType(ASTNode node) {
        if (node instanceof NumericLiteral) {
            NumericLiteral expression = (NumericLiteral)node;
            return this.createFixnum();
        }
        return null;
    }

    private ICalculatedType createFixnum() {
        ICalculatedType type = new ICalculatedType(){

            @Override
            public IElement[] findChildren(IElementCriteria criteria, String name, IProgressMonitor pm) {
                if (criteria == IElementCriteria.ByKind.METHOD) {
                    final 1 typeParent = this;
                    IMethod ceil = new IMethod(){

                        @Override
                        public IElement[] findChildren(IElementCriteria criteria, String name, IProgressMonitor pm) {
                            return IElement.EMPTY_ARRAY;
                        }

                        @Override
                        public IElement getAncestor(IElementCriteria criteria) {
                            if (criteria == IElementCriteria.ByKind.MODEL) {
                                return RubyTypeCalculator.this.model;
                            }
                            if (criteria == IElementCriteria.ByKind.CLASS || criteria == IElementCriteria.CLASS_OR_MIXIN) {
                                return typeParent;
                            }
                            return null;
                        }

                        @Override
                        public IElementKind getElementKind() {
                            return IElementKind.METHOD;
                        }

                        @Override
                        public String getName() {
                            return "ceil";
                        }
                    };
                    return new IElement[]{ceil};
                }
                return IElement.EMPTY_ARRAY;
            }

            @Override
            public IElement getAncestor(IElementCriteria criteria) {
                if (criteria == IElementCriteria.ByKind.MODEL) {
                    return RubyTypeCalculator.this.model;
                }
                return null;
            }

            @Override
            public IElementKind getElementKind() {
                return IElementKind.CLASS;
            }
        };
        return type;
    }
}

