/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.lexer.yacc;

import java.io.Serializable;
import org.jruby.lexer.yacc.ISourcePosition;

public class SourcePosition
implements ISourcePosition,
Serializable {
    private static final long serialVersionUID = 3762529027281400377L;
    private int startOffset;
    private final int endOffset;

    public SourcePosition() {
        this(0, 0);
    }

    public SourcePosition(String file, int startOffset, int endOffset) {
        this(startOffset, endOffset);
    }

    public SourcePosition(int startOffset, int endOffset) {
        this.startOffset = startOffset;
        this.endOffset = endOffset;
    }

    @Override
    public String getFile() {
        return "";
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SourcePosition)) {
            return false;
        }
        SourcePosition other = (SourcePosition)object;
        return this.startOffset == other.startOffset && this.endOffset == other.endOffset;
    }

    public int hashCode() {
        return this.startOffset ^ this.endOffset;
    }

    public String toString() {
        return "[" + this.startOffset + "..." + this.endOffset + ']';
    }

    @Override
    public void adjustStartOffset(int relativeValue) {
        this.startOffset += relativeValue;
        if (this.startOffset < 0) {
            this.startOffset = 0;
        }
    }

    @Override
    public int getStartOffset() {
        return this.startOffset;
    }

    @Override
    public int getEndOffset() {
        return this.endOffset;
    }

    @Override
    public ISourcePosition union(ISourcePosition other) {
        return new SourcePosition(this.startOffset, other.getEndOffset());
    }

    public static SourcePosition combinePosition(ISourcePosition firstPos, ISourcePosition secondPos) {
        int startOffset = firstPos.getStartOffset();
        int endOffset = firstPos.getEndOffset();
        if (startOffset > secondPos.getStartOffset()) {
            startOffset = secondPos.getStartOffset();
        }
        if (endOffset < secondPos.getEndOffset()) {
            endOffset = secondPos.getEndOffset();
        }
        SourcePosition combinedPosition = new SourcePosition(startOffset, endOffset);
        return combinedPosition;
    }
}

