/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.corext.refactoring.changes;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ISourceManipulation;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.dltk.internal.corext.refactoring.changes.AbstractDeleteChange;
import org.eclipse.dltk.internal.corext.refactoring.changes.UndoDeleteResourceChange;
import org.eclipse.dltk.internal.corext.refactoring.util.ModelElementUtil;
import org.eclipse.dltk.internal.corext.util.Messages;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ui.ide.undo.ResourceDescription;

public class DeleteSourceManipulationChange
extends AbstractDeleteChange {
    private final String fHandle;
    private final boolean fIsExecuteChange;

    public DeleteSourceManipulationChange(ISourceManipulation sm, boolean isExecuteChange) {
        Assert.isNotNull((Object)sm);
        this.fHandle = DeleteSourceManipulationChange.getScriptElement(sm).getHandleIdentifier();
        this.fIsExecuteChange = isExecuteChange;
    }

    public String getName() {
        return Messages.format(RefactoringCoreMessages.DeleteSourceManipulationChange_0, this.getElementName());
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        ISourceManipulation element = this.getSourceModification();
        if (this.fIsExecuteChange) {
            if (element instanceof ISourceModule) {
                return super.isValid(pm, 0);
            }
            return super.isValid(pm, 2);
        }
        return super.isValid(pm, 3);
    }

    private String getElementName() {
        IModelElement modelElement = DeleteSourceManipulationChange.getScriptElement(this.getSourceModification());
        if (ModelElementUtil.isDefaultPackage(modelElement)) {
            return RefactoringCoreMessages.DeleteSourceManipulationChange_1;
        }
        return modelElement.getElementName();
    }

    public Object getModifiedElement() {
        return DLTKCore.create((String)this.fHandle);
    }

    @Override
    protected Change doDelete(IProgressMonitor pm) throws CoreException {
        ISourceManipulation element = this.getSourceModification();
        if (element instanceof ISourceModule) {
            pm.beginTask("", 2);
            ISourceModule unit = (ISourceModule)element;
            DeleteSourceManipulationChange.saveCUnitIfNeeded(unit, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            IResource resource = unit.getResource();
            if (resource != null) {
                ResourceDescription resourceDescription = ResourceDescription.fromResource((IResource)resource);
                element.delete(false, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                resourceDescription.recordStateFromHistory(resource, (IProgressMonitor)new SubProgressMonitor(pm, 1));
                return new UndoDeleteResourceChange(resourceDescription);
            }
            element.delete(false, pm);
            return null;
        }
        if (element instanceof IScriptFolder) {
            ISourceModule[] units = ((IScriptFolder)element).getSourceModules();
            pm.beginTask("", units.length + 1);
            int i = 0;
            while (i < units.length) {
                DeleteSourceManipulationChange.saveCUnitIfNeeded(units[i], (IProgressMonitor)new SubProgressMonitor(pm, 1));
                ++i;
            }
            element.delete(false, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            return new NullChange();
        }
        element.delete(false, pm);
        return null;
    }

    private ISourceManipulation getSourceModification() {
        return (ISourceManipulation)this.getModifiedElement();
    }

    private static IModelElement getScriptElement(ISourceManipulation sm) {
        return (IModelElement)sm;
    }

    private static void saveCUnitIfNeeded(ISourceModule unit, IProgressMonitor pm) throws CoreException {
        if (unit.getResource() != null) {
            DeleteSourceManipulationChange.saveFileIfNeeded((IFile)unit.getResource(), pm);
        }
    }
}

