/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.mylyn.editor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.mylyn.DLTKStructureBridge;
import org.eclipse.dltk.internal.mylyn.DLTKUiBridgePlugin;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.text.folding.IFoldingStructureProvider;
import org.eclipse.dltk.ui.text.folding.IFoldingStructureProviderExtension;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.context.core.AbstractContextListener;
import org.eclipse.mylyn.context.core.ContextChangeEvent;
import org.eclipse.mylyn.context.core.ContextCore;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ActiveFoldingListener
extends AbstractContextListener {
    private final IEditorPart editor;
    private IFoldingStructureProviderExtension updater;
    private static DLTKStructureBridge bridge = (DLTKStructureBridge)ContextCore.getStructureBridge((String)"DLTK");
    private boolean enabled = false;
    private final Preferences.IPropertyChangeListener PREFERENCE_LISTENER = new Preferences.IPropertyChangeListener(){

        public void propertyChange(Preferences.PropertyChangeEvent event) {
            if (event.getProperty().equals("org.eclipse.mylyn.context.ui.editor.folding.enabled")) {
                if (event.getNewValue().equals(Boolean.TRUE.toString())) {
                    ActiveFoldingListener.this.enabled = true;
                } else {
                    ActiveFoldingListener.this.enabled = false;
                }
                ActiveFoldingListener.this.updateFolding();
            }
        }
    };

    public ActiveFoldingListener(ScriptEditor editor) {
        this.editor = editor;
        ContextCore.getContextManager().addListener((AbstractContextListener)this);
        DLTKUiBridgePlugin.getDefault().getPluginPreferences().addPropertyChangeListener(this.PREFERENCE_LISTENER);
        this.enabled = DLTKUiBridgePlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.context.ui.editor.folding.enabled");
        try {
            Object adapter = editor.getAdapter(IFoldingStructureProvider.class);
            if (adapter instanceof IFoldingStructureProviderExtension) {
                this.updater = (IFoldingStructureProviderExtension)adapter;
            } else {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.dltk.mylyn", "Could not install active folding on provider: " + adapter + ", must extend " + IFoldingStructureProviderExtension.class.getName()));
            }
        }
        catch (Exception e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.dltk.mylyn", "Could not install auto folding, reflection denied", (Throwable)e));
        }
        this.updateFolding();
    }

    public void dispose() {
        ContextCore.getContextManager().removeListener((AbstractContextListener)this);
        DLTKUiBridgePlugin.getDefault().getPluginPreferences().removePropertyChangeListener(this.PREFERENCE_LISTENER);
    }

    public static void resetProjection(IEditorPart javaEditor) {
    }

    public void updateFolding() {
        if (!this.enabled || !ContextCore.getContextManager().isContextActive()) {
            if (this.editor instanceof ScriptEditor) {
                ((ScriptEditor)this.editor).resetProjection();
            }
        } else {
            if (this.editor.getEditorInput() == null) {
                return;
            }
            try {
                ArrayList<IModelElement> toExpand = new ArrayList<IModelElement>();
                ArrayList<IModelElement> toCollapse = new ArrayList<IModelElement>();
                ISourceModule element = DLTKUIPlugin.getEditorInputModelElement((IEditorInput)this.editor.getEditorInput());
                if (element instanceof ISourceModule) {
                    ISourceModule compilationUnit = element;
                    List<IModelElement> allChildren = ActiveFoldingListener.getAllChildren((IParent)compilationUnit);
                    for (IModelElement child : allChildren) {
                        IInteractionElement interactionElement = ContextCore.getContextManager().getElement(bridge.getHandleIdentifier(child));
                        if (interactionElement != null && interactionElement.getInterest().isInteresting()) {
                            toExpand.add(child);
                            continue;
                        }
                        toCollapse.add(child);
                    }
                }
                if (this.updater != null) {
                    this.updater.collapseComments();
                    this.updater.collapseMembers();
                    this.updater.expandElements(toExpand.toArray(new IModelElement[toExpand.size()]));
                }
            }
            catch (Exception e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.dltk.mylyn", "Could not update folding", (Throwable)e));
            }
        }
    }

    private static List<IModelElement> getAllChildren(IParent parentElement) {
        ArrayList<IModelElement> allChildren = new ArrayList<IModelElement>();
        try {
            IModelElement[] iModelElementArray = parentElement.getChildren();
            int n = iModelElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IModelElement child = iModelElementArray[n2];
                allChildren.add(child);
                if (child instanceof IParent) {
                    allChildren.addAll(ActiveFoldingListener.getAllChildren((IParent)child));
                }
                ++n2;
            }
        }
        catch (ModelException modelException) {
            // empty catch block
        }
        return allChildren;
    }

    public void updateFolding(List<IInteractionElement> elements) {
        for (IInteractionElement element : elements) {
            if (this.updater == null || !this.enabled) {
                return;
            }
            Object object = bridge.getObjectForHandle(element.getHandleIdentifier());
            if (!(object instanceof IMember)) continue;
            IMember member = (IMember)object;
            if (element.getInterest().isInteresting()) {
                this.updater.expandElements(new IModelElement[]{member});
                try {
                    IModelElement[] childsChildren;
                    IModelElement[] children = member.getChildren();
                    if (children.length != 1) continue;
                    this.updater.expandElements(new IModelElement[]{children[0]});
                    if (!(children[0] instanceof IParent) || (childsChildren = ((IParent)children[0]).getChildren()).length != 1) continue;
                    this.updater.expandElements(new IModelElement[]{childsChildren[0]});
                }
                catch (ModelException modelException) {}
                continue;
            }
            this.updater.collapseElements(new IModelElement[]{member});
        }
    }

    public void contextChanged(ContextChangeEvent event) {
        switch (event.getEventKind()) {
            case ACTIVATED: 
            case DEACTIVATED: {
                if (!DLTKUiBridgePlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.context.ui.editor.folding.enabled")) break;
                this.updateFolding();
                break;
            }
            case CLEARED: {
                if (!event.isActiveContext() || !DLTKUiBridgePlugin.getDefault().getPreferenceStore().getBoolean("org.eclipse.mylyn.context.ui.editor.folding.enabled")) break;
                this.updateFolding();
                break;
            }
            case INTEREST_CHANGED: {
                this.updateFolding(event.getElements());
            }
        }
    }
}

