/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.navigation;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.DLTKLanguageManager;
import org.eclipse.dltk.core.ElementChangedEvent;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IElementChangedListener;
import org.eclipse.dltk.core.IExternalSourceModule;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ExternalScriptFolder;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.internal.ui.filters.IFilterElementNameProvider;
import org.eclipse.dltk.tcl.core.TclLanguageToolkit;
import org.eclipse.dltk.tcl.internal.ui.TclUI;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.ModelElementSorter;
import org.eclipse.dltk.ui.actions.CustomFiltersActionGroup;
import org.eclipse.dltk.ui.viewsupport.ScriptUILabelProvider;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;

public abstract class ElementsView
extends ViewPart {
    private ElementsTreeViewer treeViewer;
    protected ElementsContentProvider provider;
    private CustomFiltersActionGroup fCustomFiltersActionGroup;
    private boolean lookIntoExternal;
    protected ElementsViewLabelProvider labelProvider;
    private Job currentJob;

    protected abstract String getPreferencesId();

    protected IPreferenceStore getStore() {
        return TclUI.getDefault().getPreferenceStore();
    }

    public abstract String getElementName(Object var1);

    public abstract boolean isElement(IModelElement var1);

    public abstract boolean needProcessChildren(IModelElement var1);

    private void addElements(IModelElement element, IProgressMonitor monitor) {
        boolean bad;
        if (monitor.isCanceled()) {
            return;
        }
        monitor.worked(1);
        if (this.isElement(element)) {
            this.provider.addElement(element);
        }
        if (element instanceof ISourceModule) {
            this.asyncRefresh();
        }
        boolean bl = bad = !this.lookIntoExternal && (element instanceof ExternalScriptFolder || element instanceof IExternalSourceModule);
        if (element instanceof IParent && !bad) {
            IModelElement[] children = null;
            try {
                children = ((IParent)element).getChildren();
            }
            catch (ModelException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
                return;
            }
            if (children != null) {
                int j = 0;
                while (j < children.length) {
                    this.addElements(children[j], monitor);
                    ++j;
                }
            }
        }
        monitor.done();
    }

    public abstract String getJobTitle();

    private void addElementsJob(final IModelElement element) {
        Job job = new Job(this.getTitle()){

            protected IStatus run(IProgressMonitor monitor) {
                ElementsView.this.addElements(element, monitor);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private void removeElements(IModelElement element) {
        IDLTKLanguageToolkit languageToolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)element);
        if (languageToolkit != null && !languageToolkit.getNatureId().equals(TclLanguageToolkit.getDefault().getNatureId())) {
            return;
        }
        if (this.isElement(element)) {
            this.provider.removeElement(element);
            this.asyncRefresh();
        }
        if (element instanceof IParent) {
            IModelElement[] children = null;
            try {
                children = ((IParent)element).getChildren();
            }
            catch (ModelException e) {
                if (DLTKCore.DEBUG) {
                    e.printStackTrace();
                }
                return;
            }
            if (children != null) {
                int j = 0;
                while (j < children.length) {
                    this.removeElements(children[j]);
                    ++j;
                }
            }
        }
    }

    private void removeTypesJob(final IModelElement element) {
        Job job = new Job(this.getTitle()){

            protected IStatus run(IProgressMonitor monitor) {
                ElementsView.this.removeElements(element);
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    private void asyncRefresh() {
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                if (ElementsView.this.treeViewer != null && !ElementsView.this.treeViewer.getTree().isDisposed()) {
                    ElementsView.this.treeViewer.refresh(true);
                }
            }
        });
    }

    protected void runAsync() {
        if (this.currentJob != null && this.currentJob.getResult() == null) {
            this.currentJob.cancel();
            this.provider.clear();
            this.currentJob = null;
        }
        Job job = new Job(this.getJobTitle()){

            protected IStatus run(IProgressMonitor monitor) {
                IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                int i = 0;
                while (i < projects.length) {
                    if (monitor.isCanceled()) {
                        return Status.OK_STATUS;
                    }
                    try {
                        IScriptProject project;
                        if (projects[i].isAccessible() && projects[i].hasNature("org.eclipse.dltk.tcl.core.nature") && (project = DLTKCore.create((IProject)projects[i])) != null) {
                            ElementsView.this.addElements((IModelElement)project, monitor);
                        }
                    }
                    catch (CoreException e) {
                        e.printStackTrace();
                    }
                    monitor.worked(1);
                    ++i;
                }
                ElementsView.this.asyncRefresh();
                monitor.done();
                return Status.OK_STATUS;
            }
        };
        job.schedule();
        this.currentJob = job;
    }

    public void createPartControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new FillLayout());
        this.treeViewer = new ElementsTreeViewer(container, 2048);
        this.provider = new ElementsContentProvider();
        this.labelProvider = new ElementsViewLabelProvider();
        this.treeViewer.setLabelProvider(this.labelProvider);
        this.treeViewer.setContentProvider((IContentProvider)this.provider);
        this.treeViewer.setInput(ResourcesPlugin.getWorkspace().getRoot());
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ITreeSelection selection = (ITreeSelection)event.getSelection();
                Object source = selection.getFirstElement();
                if (source == null) {
                    return;
                }
                try {
                    ElementList el;
                    List elements;
                    if (source instanceof IModelElement) {
                        IEditorPart editor = EditorUtility.openInEditor((Object)source);
                        EditorUtility.revealInEditor((IEditorPart)editor, (IModelElement)((IModelElement)source));
                    } else if (source instanceof ElementList && (elements = (el = (ElementList)source).getElements()) != null) {
                        int i = 0;
                        while (i < elements.size()) {
                            Object element = elements.get(i);
                            if (element instanceof IModelElement) {
                                IEditorPart editor = EditorUtility.openInEditor(element);
                                EditorUtility.revealInEditor((IEditorPart)editor, (IModelElement)((IModelElement)element));
                            } else {
                                EditorUtility.openInEditor(element);
                            }
                            ++i;
                        }
                    }
                }
                catch (PartInitException e) {
                    e.printStackTrace();
                }
                catch (ModelException e) {
                    e.printStackTrace();
                }
            }
        });
        IViewSite site = (IViewSite)this.getSite();
        IActionBars bars = site.getActionBars();
        this.registerToolbarActions(bars);
        this.runAsync();
    }

    private void registerToolbarActions(IActionBars actionBars) {
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        if (toolBarManager != null) {
            toolBarManager.add((IAction)new LexicalSortingAction());
            toolBarManager.add((IAction)new ToggleExternalAction());
        }
        this.fCustomFiltersActionGroup = new CustomFiltersActionGroup((IViewPart)this, (StructuredViewer)this.treeViewer){};
        this.fCustomFiltersActionGroup.fillActionBars(actionBars);
        IMenuManager viewMenuManager = actionBars.getMenuManager();
        viewMenuManager.add((IContributionItem)new Separator("EndFilterGroup"));
    }

    public void dispose() {
        if (this.fCustomFiltersActionGroup != null) {
            this.fCustomFiltersActionGroup.dispose();
            this.fCustomFiltersActionGroup = null;
        }
        super.dispose();
    }

    public void setFocus() {
    }

    public String getOriginalElementText(Object o) {
        return this.labelProvider.getOriginalText(o);
    }

    class ElementList
    implements IAdaptable {
        private String name;
        private List childs;

        ElementList(String name, List childs) {
            this.name = name;
            this.childs = childs;
        }

        Object getFirstElement() {
            if (this.childs != null && this.childs.size() > 0) {
                return this.childs.get(0);
            }
            return null;
        }

        public String toString() {
            return this.name;
        }

        public int hashCode() {
            int PRIME = 31;
            int result = 1;
            result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ElementList other = (ElementList)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public List getElements() {
            return this.childs;
        }

        public Object getAdapter(Class adapter) {
            if (adapter == IModelElement.class) {
                return this.getFirstElement();
            }
            if (adapter == List.class) {
                return this.childs;
            }
            return null;
        }
    }

    private class ElementsContentProvider
    implements ITreeContentProvider {
        private Object[] NO_ELEMENT = new Object[0];
        private Map elements = new HashMap();

        public ElementsContentProvider() {
            DLTKCore.addElementChangedListener((IElementChangedListener)new IElementChangedListener(){

                public void elementChanged(ElementChangedEvent event) {
                    IModelElementDelta delta = event.getDelta();
                    this.processChildren(delta);
                    ElementsView.this.asyncRefresh();
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void processChildren(IModelElementDelta delta) {
                    IModelElement element = delta.getElement();
                    if (delta.getKind() == 1) {
                        ElementsView.this.addElementsJob(element);
                    }
                    if (delta.getKind() == 2) {
                        ElementsView.this.removeTypesJob(element);
                    }
                    if ((delta.getFlags() & 0x40) != 0) {
                        ElementsView.this.addElementsJob(element);
                    }
                    if ((delta.getFlags() & 0x80) != 0) {
                        Map map = ElementsContentProvider.this.elements;
                        synchronized (map) {
                            ElementsContentProvider.this.elements.clear();
                        }
                        ElementsView.this.runAsync();
                    }
                    if ((delta.getFlags() & 8) != 0) {
                        IModelElementDelta[] affectedChildren = delta.getAffectedChildren();
                        int i = 0;
                        while (i < affectedChildren.length) {
                            IModelElementDelta child = affectedChildren[i];
                            this.processChildren(child);
                            ++i;
                        }
                    }
                }
            });
        }

        public synchronized Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IWorkspaceRoot) {
                ArrayList<Object> result = new ArrayList<Object>();
                Set keys = this.elements.keySet();
                for (Object e : keys) {
                    Object o = this.elements.get(e);
                    if (o instanceof IModelElement) {
                        if (result.contains(o)) continue;
                        result.add(o);
                        continue;
                    }
                    if (!(o instanceof List)) continue;
                    ElementList el = new ElementList((String)e, (List)o);
                    if (result.contains(o)) continue;
                    result.add(el);
                }
                return result.toArray();
            }
            return this.NO_ELEMENT;
        }

        public Object getParent(Object element) {
            if (element instanceof IModelElement) {
                return ResourcesPlugin.getWorkspace().getRoot();
            }
            return this.NO_ELEMENT;
        }

        public boolean hasChildren(Object element) {
            return element instanceof IWorkspaceRoot;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(inputElement);
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public synchronized void addElement(IModelElement element) {
            IDLTKLanguageToolkit languageToolkit = DLTKLanguageManager.getLanguageToolkit((IModelElement)element);
            if (!languageToolkit.getNatureId().equals(TclLanguageToolkit.getDefault().getNatureId())) {
                return;
            }
            String name = ElementsView.this.labelProvider.getText(element);
            if (this.elements.containsKey(name)) {
                List els;
                Object o = this.elements.get(name);
                if (o instanceof IModelElement) {
                    ArrayList<Object> els2 = new ArrayList<Object>();
                    els2.add(o);
                    if (!els2.contains(element)) {
                        els2.add(element);
                    }
                    this.elements.put(name, els2);
                } else if (o instanceof List && !(els = (List)o).contains(o)) {
                    els.add(element);
                }
            } else {
                this.elements.put(name, element);
            }
        }

        public synchronized void clear() {
            this.elements.clear();
        }

        public synchronized void removeElement(IModelElement element) {
            String name = ElementsView.this.labelProvider.getText(element);
            if (this.elements.containsKey(name)) {
                Object o = this.elements.get(name);
                if (o instanceof IModelElement && o.equals(element)) {
                    this.elements.remove(name);
                } else if (o instanceof List) {
                    List els = (List)o;
                    els.remove(element);
                    if (els.size() == 0) {
                        this.elements.remove(name);
                    }
                }
            }
        }
    }

    private class ElementsTreeViewer
    extends TreeViewer
    implements IFilterElementNameProvider {
        public ElementsTreeViewer(Composite container, int border) {
            super(container, border);
        }

        public String getElementName(Object element) {
            return ElementsView.this.labelProvider.getText(element);
        }
    }

    public class ElementsViewLabelProvider
    extends ScriptUILabelProvider
    implements IBaseLabelProvider {
        public Image getImage(Object element) {
            if (element instanceof ElementList) {
                return this.getImage(((ElementList)element).getFirstElement());
            }
            return super.getImage(element);
        }

        public String getOriginalText(Object element) {
            return super.getText(element);
        }

        public String getText(Object element) {
            String text = ElementsView.this.getElementName(element);
            if (text != null) {
                return text;
            }
            if (element instanceof ElementList) {
                return ((ElementList)element).toString();
            }
            return super.getText(element);
        }
    }

    class LexicalSortingAction
    extends Action {
        private ModelElementSorter fSorter = new ModelElementSorter(){

            protected String getElementName(Object element) {
                return ((LexicalSortingAction)LexicalSortingAction.this).ElementsView.this.labelProvider.getText(element);
            }

            public int compare(Viewer viewer, Object e1, Object e2) {
                Object o1 = e1;
                Object o2 = e2;
                if (e1 != null && e1 instanceof ElementList) {
                    o1 = ((ElementList)e1).getFirstElement();
                }
                if (e2 != null && e2 instanceof ElementList) {
                    o2 = ((ElementList)e2).getFirstElement();
                }
                return super.compare(viewer, o1, o2);
            }
        };

        public LexicalSortingAction() {
            if (DLTKCore.DEBUG) {
                System.err.println("LexicalSortingAction: Need to set correct info here.");
            }
            this.setText("Alphabetical Sort");
            DLTKPluginImages.setLocalImageDescriptors((IAction)this, (String)"alphab_sort_co.gif");
            boolean checked = ElementsView.this.getStore().getBoolean(String.valueOf(ElementsView.this.getPreferencesId()) + "LexicalSortingAction.isChecked");
            this.valueChanged(checked, false);
        }

        public void run() {
            this.valueChanged(this.isChecked(), true);
        }

        private void valueChanged(final boolean on, boolean store) {
            this.setChecked(on);
            BusyIndicator.showWhile((Display)ElementsView.this.treeViewer.getControl().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    ElementsView.this.treeViewer.setSorter((ViewerSorter)(on ? LexicalSortingAction.this.fSorter : null));
                }
            });
            if (store) {
                ElementsView.this.getStore().setValue(String.valueOf(ElementsView.this.getPreferencesId()) + "LexicalSortingAction.isChecked", on);
            }
        }
    }

    class ToggleExternalAction
    extends Action {
        public ToggleExternalAction() {
            this.setText("Show external elements");
            this.setImageDescriptor(DLTKPluginImages.getDescriptor((String)"org.eclipse.dltk.ui.package_obj.png"));
            boolean checked = ElementsView.this.getStore().getBoolean(String.valueOf(ElementsView.this.getPreferencesId()) + "ToggleExternalAction.isChecked");
            this.valueChanged(checked, false);
        }

        public void run() {
            this.valueChanged(this.isChecked(), true);
        }

        private void valueChanged(final boolean on, boolean store) {
            this.setChecked(on);
            if (store) {
                ElementsView.this.getStore().setValue(String.valueOf(ElementsView.this.getPreferencesId()) + "ToggleExternalAction.isChecked", on);
            }
            BusyIndicator.showWhile((Display)ElementsView.this.treeViewer.getControl().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    ElementsView.this.lookIntoExternal = on;
                    ((ToggleExternalAction)ToggleExternalAction.this).ElementsView.this.provider.clear();
                    ElementsView.this.runAsync();
                }
            });
        }
    }
}

