/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.presentation;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProvider;
import org.eclipse.emf.edit.ui.action.ControlAction;
import org.eclipse.emf.edit.ui.action.LoadResourceAction;
import org.eclipse.emf.edit.ui.action.ValidateAction;
import org.eclipse.emf.edit.ui.provider.DiagnosticDecorator;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubContributionItem;
import org.eclipse.jface.bindings.Binding;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.oomph.base.Annotation;
import org.eclipse.oomph.base.BaseFactory;
import org.eclipse.oomph.base.BasePackage;
import org.eclipse.oomph.base.ModelElement;
import org.eclipse.oomph.base.provider.BaseEditUtil;
import org.eclipse.oomph.base.provider.ModelElementItemProvider;
import org.eclipse.oomph.base.util.EAnnotations;
import org.eclipse.oomph.internal.ui.GeneralDragAdapter;
import org.eclipse.oomph.internal.ui.OomphEditingDomainActionBarContributor;
import org.eclipse.oomph.internal.ui.OomphTransferDelegate;
import org.eclipse.oomph.resources.ResourcesUtil;
import org.eclipse.oomph.setup.CompoundTask;
import org.eclipse.oomph.setup.InstallationTask;
import org.eclipse.oomph.setup.Product;
import org.eclipse.oomph.setup.ProductCatalog;
import org.eclipse.oomph.setup.ProductVersion;
import org.eclipse.oomph.setup.Project;
import org.eclipse.oomph.setup.ProjectCatalog;
import org.eclipse.oomph.setup.RedirectionTask;
import org.eclipse.oomph.setup.ResourceCreationTask;
import org.eclipse.oomph.setup.Scope;
import org.eclipse.oomph.setup.SetupFactory;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.VariableChoice;
import org.eclipse.oomph.setup.VariableTask;
import org.eclipse.oomph.setup.WorkspaceTask;
import org.eclipse.oomph.setup.impl.DynamicSetupTaskImpl;
import org.eclipse.oomph.setup.internal.core.SetupTaskPerformer;
import org.eclipse.oomph.setup.p2.util.MarketPlaceListing;
import org.eclipse.oomph.setup.presentation.AbstractTableAction;
import org.eclipse.oomph.setup.presentation.EnablementAction;
import org.eclipse.oomph.setup.presentation.Messages;
import org.eclipse.oomph.setup.presentation.PreferenceCaptureDialog;
import org.eclipse.oomph.setup.presentation.SetupEditor;
import org.eclipse.oomph.setup.presentation.SetupEditorPlugin;
import org.eclipse.oomph.setup.ui.SetupEditorSupport;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.setup.ui.recorder.RecorderManager;
import org.eclipse.oomph.setup.ui.recorder.RecorderTransaction;
import org.eclipse.oomph.setup.util.SetupUtil;
import org.eclipse.oomph.ui.DockableDialog;
import org.eclipse.oomph.ui.UIUtil;
import org.eclipse.oomph.util.ReflectUtil;
import org.eclipse.oomph.util.StringUtil;
import org.eclipse.oomph.workingsets.WorkingSet;
import org.eclipse.oomph.workingsets.WorkingSetsPackage;
import org.eclipse.oomph.workingsets.presentation.WorkingSetsActionBarContributor;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.registry.EditorRegistry;
import org.eclipse.ui.keys.IBindingService;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.services.IServiceLocator;
import org.eclipse.ui.views.properties.PropertySheet;

public class SetupActionBarContributor
extends OomphEditingDomainActionBarContributor
implements ISelectionChangedListener {
    private static final String ENABLEMENT_ITEM_PREFIX = EnablementAction.class.getName() + "-";
    private static final Comparator<? super IAction> ACTION_COMPARATOR = new Comparator<IAction>(){

        @Override
        public int compare(IAction a1, IAction a2) {
            return StringUtil.safe((String)a1.getText()).compareTo(StringUtil.safe((String)a2.getText()));
        }
    };
    protected IEditorPart activeEditorPart;
    protected ISelectionProvider selectionProvider;
    protected ShowPropertiesViewAction showPropertiesViewAction = new ShowPropertiesViewAction();
    protected IAction refreshViewerAction = new Action(SetupEditorPlugin.INSTANCE.getString("_UI_RefreshViewer_menu_item")){

        public boolean isEnabled() {
            return SetupActionBarContributor.this.activeEditorPart instanceof IViewerProvider;
        }

        public void run() {
            Viewer viewer;
            if (SetupActionBarContributor.this.activeEditorPart instanceof IViewerProvider && (viewer = ((IViewerProvider)SetupActionBarContributor.this.activeEditorPart).getViewer()) != null) {
                viewer.refresh();
            }
        }
    };
    protected Collection<IAction> createChildActions;
    protected MenuManager createChildMenuManager;
    protected Collection<IAction> createSiblingActions;
    protected MenuManager createSiblingMenuManager;
    private final ToggleViewerInputAction toggleViewerInputAction = new ToggleViewerInputAction();
    private final PreferenceRecorderToolbarAction recordPreferencesAction = new PreferenceRecorderToolbarAction(true);
    private final PreferenceCaptureToolbarAction capturePreferencesAction = new PreferenceCaptureToolbarAction(false);
    private final PreferenceCaptureToolbarAction importPreferencesAction = new PreferenceCaptureToolbarAction(true);
    private final CommandTableAction commandTableAction = new CommandTableAction();
    private final EditorTableAction editorTableAction = new EditorTableAction();
    private final TestInstallAction testInstallAction = new TestInstallAction();
    private final OpenInSetupEditorAction openInSetupEditorAction = new OpenInSetupEditorAction();
    private final OpenInTextEditorAction openInTextEditorAction = new OpenInTextEditorAction();
    private final ShowTooltipsAction showTooltipsAction = new ShowTooltipsAction();
    private final ShowInformationBrowserAction showInformationBrowserAction = new ShowInformationBrowserAction();
    protected final WorkingSetsActionBarContributor.ShowPreviewAction showPreviewAction = new WorkingSetsActionBarContributor.ShowPreviewAction(Messages.SetupActionBarContributor_action_showWorkingSetsPreview);
    protected final DeleteUnrecognizedContentAction deleteUnrecognizedContentAction = new DeleteUnrecognizedContentAction();
    protected final ShowLaunchConfigurationsAction showLaunchConfigurationAction = new ShowLaunchConfigurationsAction();
    private int lastSubMenuID;

    public SetupActionBarContributor() {
        super(1);
        this.loadResourceAction = new LoadResourceAction();
        this.validateAction = new ValidateAction();
        this.liveValidationAction = new DiagnosticDecorator.LiveValidator.LiveValidationAction(SetupEditorPlugin.getPlugin().getDialogSettings());
        this.controlAction = new ControlAction(){

            public void run() {
                super.run();
                if (this.command != null && this.domain instanceof AdapterFactoryEditingDomain) {
                    for (Object object : this.command.getResult()) {
                        Resource resource;
                        if (!(object instanceof EObject) || (resource = ((EObject)object).eResource()) == null) continue;
                        ((AdapterFactoryEditingDomain)this.domain).getResourceToReadOnlyMap().put(resource, Boolean.FALSE);
                    }
                }
            }
        };
    }

    public void init(IActionBars actionBars) {
        this.validateAction = null;
        this.showPropertiesViewAction.setPage(this.getPage());
        this.liveValidationAction.setImageDescriptor(SetupEditorPlugin.INSTANCE.getImageDescriptor("live_validation"));
        this.refreshViewerAction.setImageDescriptor(SetupEditorPlugin.INSTANCE.getImageDescriptor("refresh_view"));
        this.controlAction.setImageDescriptor(SetupEditorPlugin.INSTANCE.getImageDescriptor("control"));
        this.loadResourceAction = new LoadResourceAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ResourceSet resourceSet = this.domain.getResourceSet();
                EList resources = resourceSet.getResources();
                final LinkedHashSet loadedURIs = new LinkedHashSet();
                LoadResourceAction.LoadResourceDialog loadResourceDialog = new LoadResourceAction.LoadResourceDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), this.domain){

                    public List<URI> getURIs() {
                        List uris = super.getURIs();
                        ListIterator<URI> it = uris.listIterator();
                        while (it.hasNext()) {
                            URI uri = (URI)it.next();
                            MarketPlaceListing marketPlaceListing = MarketPlaceListing.getMarketPlaceListing((URI)uri, (URIConverter)this.domain.getResourceSet().getURIConverter());
                            if (marketPlaceListing == null) continue;
                            it.set(marketPlaceListing.getListing());
                        }
                        loadedURIs.clear();
                        loadedURIs.addAll(uris);
                        return uris;
                    }
                };
                if (loadResourceDialog.open() == 0) {
                    ArrayList<Resource> loadedResources = new ArrayList<Resource>();
                    ResourceSet resourceSet2 = resourceSet;
                    synchronized (resourceSet2) {
                        int index = 0;
                        for (URI uri : loadedURIs) {
                            Resource resource = resourceSet.getResource(uri, false);
                            if (resource == null) continue;
                            loadedResources.add(resource);
                            resources.move(++index, (Object)resource);
                        }
                    }
                    if (!loadedResources.isEmpty()) {
                        if (!SetupActionBarContributor.this.toggleViewerInputAction.isChecked()) {
                            SetupActionBarContributor.this.toggleViewerInputAction.run();
                        }
                        SetupActionBarContributor.this.toggleViewerInputAction.select((ISelection)new StructuredSelection(loadedResources));
                    }
                }
            }
        };
        this.loadResourceAction.setImageDescriptor(SetupEditorPlugin.INSTANCE.getImageDescriptor("load"));
        this.loadResourceAction.setId("load");
        this.controlAction.setId("control");
        this.liveValidationAction.setId("live");
        super.init(actionBars);
    }

    public final ToggleViewerInputAction getToggleViewerInputAction() {
        return this.toggleViewerInputAction;
    }

    public void scheduleValidation() {
        this.liveValidationAction.run();
    }

    public void contributeToToolBar(IToolBarManager toolBarManager) {
        toolBarManager.add((IContributionItem)new Separator("setup-settings"));
        toolBarManager.add((IAction)this.recordPreferencesAction);
        toolBarManager.add((IAction)this.capturePreferencesAction);
        toolBarManager.add((IAction)this.importPreferencesAction);
        toolBarManager.add((IAction)this.commandTableAction);
        toolBarManager.add((IAction)this.editorTableAction);
        toolBarManager.add((IAction)this.showInformationBrowserAction);
        toolBarManager.add((IAction)this.showPreviewAction);
        toolBarManager.add((IAction)this.showLaunchConfigurationAction);
        toolBarManager.add((IAction)this.toggleViewerInputAction);
        super.contributeToToolBar(toolBarManager);
        toolBarManager.add((IContributionItem)new Separator("setup-additions"));
    }

    public void contributeToMenuGen(IMenuManager menuManager) {
        super.contributeToMenu(menuManager);
        MenuManager submenuManager = new MenuManager(SetupEditorPlugin.INSTANCE.getString("_UI_SetupEditor_menu"), "org.eclipse.oomph.setupMenuID");
        menuManager.insertAfter("additions", (IContributionItem)submenuManager);
        submenuManager.add((IContributionItem)new Separator("settings"));
        submenuManager.add((IContributionItem)new Separator("actions"));
        submenuManager.add((IContributionItem)new Separator("additions"));
        submenuManager.add((IContributionItem)new Separator("additions-end"));
        this.createChildMenuManager = new MenuManager(SetupEditorPlugin.INSTANCE.getString("_UI_CreateChild_menu_item"));
        submenuManager.insertBefore("additions", (IContributionItem)this.createChildMenuManager);
        this.createSiblingMenuManager = new MenuManager(SetupEditorPlugin.INSTANCE.getString("_UI_CreateSibling_menu_item"));
        submenuManager.insertBefore("additions", (IContributionItem)this.createSiblingMenuManager);
        submenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menuManager) {
                menuManager.updateAll(true);
            }
        });
        this.addGlobalActions((IMenuManager)submenuManager);
    }

    public void contributeToMenu(IMenuManager menuManager) {
        this.contributeToMenuGen(menuManager);
        ReflectUtil.setValue((String)"image", (Object)this.createChildMenuManager, (Object)SetupEditorPlugin.INSTANCE.getImageDescriptor("create_child"));
        ReflectUtil.setValue((String)"image", (Object)this.createSiblingMenuManager, (Object)SetupEditorPlugin.INSTANCE.getImageDescriptor("create_sibling"));
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        this.activeEditorPart = part;
        this.toggleViewerInputAction.setActiveWorkbenchPart((IWorkbenchPart)part);
        this.commandTableAction.setActivePart((IWorkbenchPart)part);
        this.editorTableAction.setActivePart((IWorkbenchPart)part);
        this.openInSetupEditorAction.setActiveWorkbenchPart((IWorkbenchPart)part);
        this.openInTextEditorAction.setActiveWorkbenchPart((IWorkbenchPart)part);
        this.capturePreferencesAction.setActiveWorkbenchPart((IWorkbenchPart)part);
        this.importPreferencesAction.setActiveWorkbenchPart((IWorkbenchPart)part);
        this.showPreviewAction.setActiveWorkbenchPart((IWorkbenchPart)part);
        this.showLaunchConfigurationAction.setActiveWorkbenchPart((IWorkbenchPart)part);
        this.showInformationBrowserAction.setActiveWorkbenchPart((IWorkbenchPart)part);
        this.deleteUnrecognizedContentAction.setActiveWorkbenchPart((IWorkbenchPart)part);
        if (this.selectionProvider != null) {
            this.selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this);
        }
        if (part == null) {
            this.selectionProvider = null;
        } else {
            this.selectionProvider = part.getSite().getSelectionProvider();
            this.selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this);
            if (this.selectionProvider.getSelection() != null) {
                this.selectionChanged(new SelectionChangedEvent(this.selectionProvider, this.selectionProvider.getSelection()));
            }
        }
    }

    public void selectionChangedGen(SelectionChangedEvent event) {
        if (this.createChildMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createChildMenuManager, this.createChildActions);
        }
        if (this.createSiblingMenuManager != null) {
            this.depopulateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions);
        }
        Collection newChildDescriptors = null;
        Collection newSiblingDescriptors = null;
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            Object object = ((IStructuredSelection)selection).getFirstElement();
            EditingDomain domain = ((IEditingDomainProvider)this.activeEditorPart).getEditingDomain();
            newChildDescriptors = domain.getNewChildDescriptors(object, null);
            newSiblingDescriptors = domain.getNewChildDescriptors(null, object);
        }
        this.createChildActions = this.generateCreateChildActions(newChildDescriptors, selection);
        this.createSiblingActions = this.generateCreateSiblingActions(newSiblingDescriptors, selection);
        if (this.createChildMenuManager != null) {
            this.populateManager((IContributionManager)this.createChildMenuManager, this.createChildActions, null);
            this.createChildMenuManager.update(true);
        }
        if (this.createSiblingMenuManager != null) {
            this.populateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions, null);
            this.createSiblingMenuManager.update(true);
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.selectionChangedGen(event);
        this.openInSetupEditorAction.selectionChanged(event);
        this.openInTextEditorAction.selectionChanged(event);
        this.deleteUnrecognizedContentAction.selectionChanged(event);
    }

    protected Collection<IAction> generateCreateChildActionsGen(Collection<?> descriptors, ISelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (descriptors != null) {
            for (Object descriptor : descriptors) {
                actions.add((IAction)new CreateChildAction(this.activeEditorPart, selection, descriptor));
            }
        }
        return actions;
    }

    protected Collection<IAction> generateCreateChildActions(Collection<?> descriptors, ISelection selection) {
        Collection<IAction> actions = this.generateCreateChildActionsGen(descriptors, selection);
        return this.addSpecializedAnnotationCreationActions(descriptors, selection, false, this.addEnablementActions(descriptors, selection, false, actions));
    }

    protected Collection<IAction> generateCreateSiblingActionsGen(Collection<?> descriptors, ISelection selection) {
        ArrayList<IAction> actions = new ArrayList<IAction>();
        if (descriptors != null) {
            for (Object descriptor : descriptors) {
                actions.add((IAction)new CreateSiblingAction(this.activeEditorPart, selection, descriptor));
            }
        }
        return actions;
    }

    protected Collection<IAction> generateCreateSiblingActions(Collection<?> descriptors, ISelection selection) {
        Collection<IAction> actions = this.generateCreateSiblingActionsGen(descriptors, selection);
        return this.addSpecializedAnnotationCreationActions(descriptors, selection, true, this.addEnablementActions(descriptors, selection, true, actions));
    }

    private Collection<IAction> addSpecializedAnnotationCreationActions(Collection<?> descriptors, ISelection selection, boolean sibling, Collection<IAction> actions) {
        actions = new ArrayList<IAction>(actions);
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1) {
            EditingDomain domain = ((IEditingDomainProvider)this.activeEditorPart).getEditingDomain();
            Object object = ((IStructuredSelection)selection).getFirstElement();
            if (sibling) {
                object = domain.getParent(object);
            }
            if (object instanceof VariableTask) {
                Object action;
                CommandParameter descriptor;
                Annotation annotation;
                String name;
                VariableTask variable = (VariableTask)object;
                if (variable.getAnnotation("http://www.eclipse.org/oomph/setup/GlobalVariable") == null && (name = variable.getName()) != null && !name.startsWith("*")) {
                    annotation = BaseFactory.eINSTANCE.createAnnotation("http://www.eclipse.org/oomph/setup/GlobalVariable");
                    descriptor = new CommandParameter(null, (Object)BasePackage.Literals.MODEL_ELEMENT__ANNOTATIONS, (Object)annotation);
                    action = sibling ? new CreateSiblingAction(domain, selection, (Object)descriptor) : new CreateChildAction(domain, selection, (Object)descriptor);
                    action.setText(action.getText() + " - http://www.eclipse.org/oomph/setup/GlobalVariable");
                    actions.add((IAction)action);
                }
                if (!(variable.getAnnotation("http://www.eclipse.org/oomph/setup/SimpleDefaultVariable") != null || (name = variable.getName()) == null || name.startsWith("*") || variable.getDefaultValue() == null && variable.getChoices().isEmpty())) {
                    annotation = BaseFactory.eINSTANCE.createAnnotation("http://www.eclipse.org/oomph/setup/SimpleDefaultVariable");
                    descriptor = new CommandParameter(null, (Object)BasePackage.Literals.MODEL_ELEMENT__ANNOTATIONS, (Object)annotation);
                    action = sibling ? new CreateSiblingAction(domain, selection, (Object)descriptor) : new CreateChildAction(domain, selection, (Object)descriptor);
                    action.setText(action.getText() + " - http://www.eclipse.org/oomph/setup/SimpleDefaultVariable");
                    actions.add((IAction)action);
                }
                if (variable.getAnnotation("http://www.eclipse.org/oomph/setup/InheritedChoices") == null) {
                    Annotation annotation2 = BaseFactory.eINSTANCE.createAnnotation("http://www.eclipse.org/oomph/setup/InheritedChoices");
                    annotation2.getDetails().put((Object)"inherit", (Object)"");
                    CommandParameter descriptor2 = new CommandParameter(null, (Object)BasePackage.Literals.MODEL_ELEMENT__ANNOTATIONS, (Object)annotation2);
                    Object action2 = sibling ? new CreateSiblingAction(domain, selection, (Object)descriptor2) : new CreateChildAction(domain, selection, (Object)descriptor2);
                    action2.setText(action2.getText() + " - http://www.eclipse.org/oomph/setup/InheritedChoices");
                    actions.add((IAction)action2);
                }
            } else if (object instanceof ModelElement) {
                EMap details;
                Object action;
                CommandParameter descriptor;
                Annotation annotation;
                ModelElement modelElement = (ModelElement)object;
                if (modelElement.getAnnotation("http://www.eclipse.org/oomph/setup/FeatureSubstitution") == null && !this.getFeatureSubstitutionAttributes(modelElement).isEmpty()) {
                    annotation = BaseFactory.eINSTANCE.createAnnotation("http://www.eclipse.org/oomph/setup/FeatureSubstitution");
                    descriptor = new CommandParameter(null, (Object)BasePackage.Literals.MODEL_ELEMENT__ANNOTATIONS, (Object)annotation);
                    action = sibling ? new CreateSiblingAction(domain, selection, (Object)descriptor) : new CreateChildAction(domain, selection, (Object)descriptor);
                    action.setText(action.getText() + " - http://www.eclipse.org/oomph/setup/FeatureSubstitution");
                    actions.add((IAction)action);
                }
                if (modelElement instanceof Annotation) {
                    annotation = (Annotation)modelElement;
                    if ("http://www.eclipse.org/oomph/setup/FeatureSubstitution".equals(annotation.getSource())) {
                        details = annotation.getDetails();
                        Set<EAttribute> featureSubstitutionAttributes = this.getFeatureSubstitutionAttributes(annotation.getModelElement());
                        for (EAttribute eAttribute : featureSubstitutionAttributes) {
                            String name = eAttribute.getName();
                            if (details.containsKey((Object)name)) continue;
                            Map.Entry detail = BaseFactory.eINSTANCE.createStringToStringMapEntry();
                            ((EObject)detail).eSet((EStructuralFeature)BasePackage.Literals.STRING_TO_STRING_MAP_ENTRY__KEY, (Object)name);
                            CommandParameter descriptor3 = new CommandParameter(null, (Object)BasePackage.Literals.ANNOTATION__DETAILS, (Object)detail);
                            Object action3 = sibling ? new CreateSiblingAction(domain, selection, (Object)descriptor3) : new CreateChildAction(domain, selection, (Object)descriptor3);
                            action3.setText(action3.getText() + " - " + name);
                            actions.add((IAction)action3);
                        }
                    }
                } else if (modelElement instanceof SetupTask) {
                    if (modelElement.getAnnotation("http://www.eclipse.org/oomph/setup/InducedChoices") == null) {
                        annotation = BaseFactory.eINSTANCE.createAnnotation("http://www.eclipse.org/oomph/setup/InducedChoices");
                        annotation.getDetails().put((Object)"inherit", (Object)"");
                        annotation.getDetails().put((Object)"label", (Object)"");
                        annotation.getDetails().put((Object)"target", (Object)"");
                        annotation.getDetails().put((Object)"description", (Object)"");
                        descriptor = new CommandParameter(null, (Object)BasePackage.Literals.MODEL_ELEMENT__ANNOTATIONS, (Object)annotation);
                        action = sibling ? new CreateSiblingAction(domain, selection, (Object)descriptor) : new CreateChildAction(domain, selection, (Object)descriptor);
                        action.setText(action.getText() + " - http://www.eclipse.org/oomph/setup/InducedChoices");
                        actions.add((IAction)action);
                    }
                } else if (modelElement instanceof VariableChoice) {
                    if (modelElement.getAnnotation("http://www.eclipse.org/oomph/setup/MatchChoice") == null) {
                        annotation = BaseFactory.eINSTANCE.createAnnotation("http://www.eclipse.org/oomph/setup/MatchChoice");
                        descriptor = new CommandParameter(null, (Object)BasePackage.Literals.MODEL_ELEMENT__ANNOTATIONS, (Object)annotation);
                        action = sibling ? new CreateSiblingAction(domain, selection, (Object)descriptor) : new CreateChildAction(domain, selection, (Object)descriptor);
                        action.setText(action.getText() + " - http://www.eclipse.org/oomph/setup/MatchChoice");
                        actions.add((IAction)action);
                    }
                } else if (modelElement instanceof ProjectCatalog || modelElement instanceof Project || modelElement instanceof ProductCatalog || modelElement instanceof Product || modelElement instanceof ProductVersion) {
                    if (modelElement.getAnnotation("http://www.eclipse.org/oomph/setup/BrandingInfo") == null) {
                        annotation = BaseFactory.eINSTANCE.createAnnotation("http://www.eclipse.org/oomph/setup/BrandingInfo");
                        details = annotation.getDetails();
                        if (modelElement instanceof ProductCatalog || modelElement instanceof Product || modelElement instanceof ProductVersion) {
                            details.put((Object)"readmePath", null);
                            details.put((Object)"folderName", null);
                        }
                        details.put((Object)"imageURI", null);
                        details.put((Object)"siteURI", null);
                        CommandParameter descriptor4 = new CommandParameter(null, (Object)BasePackage.Literals.MODEL_ELEMENT__ANNOTATIONS, (Object)annotation);
                        Object action4 = sibling ? new CreateSiblingAction(domain, selection, (Object)descriptor4) : new CreateChildAction(domain, selection, (Object)descriptor4);
                        action4.setText(action4.getText() + " - http://www.eclipse.org/oomph/setup/BrandingInfo");
                        actions.add((IAction)action4);
                    }
                    if ((modelElement instanceof Project || modelElement instanceof Product) && modelElement.getAnnotation("http://www.eclipse.org/oomph/setup/ConfigurationReference") == null) {
                        annotation = BaseFactory.eINSTANCE.createAnnotation("http://www.eclipse.org/oomph/setup/ConfigurationReference");
                        descriptor = new CommandParameter(null, (Object)BasePackage.Literals.MODEL_ELEMENT__ANNOTATIONS, (Object)annotation);
                        action = sibling ? new CreateSiblingAction(domain, selection, (Object)descriptor) : new CreateChildAction(domain, selection, (Object)descriptor);
                        action.setText(action.getText() + " - http://www.eclipse.org/oomph/setup/ConfigurationReference");
                        actions.add((IAction)action);
                    }
                }
            }
        }
        return actions;
    }

    private Set<EAttribute> getFeatureSubstitutionAttributes(ModelElement modelElement) {
        LinkedHashSet<EAttribute> result = new LinkedHashSet<EAttribute>();
        for (EAttribute eAttribute : modelElement.eClass().getEAllAttributes()) {
            String instanceClassName;
            if (!eAttribute.isChangeable() || eAttribute.getEAnnotation("http://www.eclipse.org/oomph/setup/NoExpand") != null || "java.lang.String".equals(instanceClassName = eAttribute.getEAttributeType().getInstanceClassName()) || "org.eclipse.emf.common.util.URI".equals(instanceClassName)) continue;
            result.add(eAttribute);
        }
        return result;
    }

    private Collection<IAction> addEnablementActions(Collection<?> descriptors, ISelection selection, boolean sibling, Collection<IAction> actions) {
        Object object;
        if (selection instanceof IStructuredSelection && ((IStructuredSelection)selection).size() == 1 && (object = ((IStructuredSelection)selection).getFirstElement()) instanceof EObject) {
            actions = new ArrayList<IAction>(actions);
            this.addEnablementActions(descriptors, object, sibling, actions);
        }
        return actions;
    }

    private void addEnablementActions(Collection<?> descriptors, Object object, boolean sibling, Collection<IAction> actions) {
        EditingDomain domain = ((IEditingDomainProvider)this.activeEditorPart).getEditingDomain();
        ResourceSet resourceSet = domain.getResourceSet();
        Object siblingObject = null;
        if (sibling) {
            siblingObject = object;
            if (!((object = domain.getParent(object)) instanceof EObject)) {
                return;
            }
        }
        ReflectiveItemProvider itemProvider = new ReflectiveItemProvider(null){

            protected void gatherAllMetaData(EObject eObject) {
                Resource mainResource = eObject.eResource();
                if (mainResource != null) {
                    ResourceSet resourceSet = mainResource.getResourceSet();
                    if (resourceSet == null) {
                        this.gatherAllMetaData(mainResource);
                    } else {
                        EList resources = resourceSet.getResources();
                        int i = 0;
                        while (i < resources.size()) {
                            this.gatherAllMetaData((Resource)resources.get(i));
                            ++i;
                        }
                    }
                }
            }

            protected void gatherAllMetaData(Resource resource) {
                for (EObject root : resource.getContents()) {
                    if (!(root instanceof EPackage)) continue;
                    this.gatherMetaData((EModelElement)((EPackage)root));
                }
            }
        };
        BaseEditUtil.IconReflectiveItemProvider iconItemProvider = ((SetupEditor)this.activeEditor).getReflectiveItemProvider();
        Shell shell = this.activeEditorPart.getSite().getShell();
        Collection newChildDescriptors = itemProvider.getNewChildDescriptors(object, domain, siblingObject);
        for (Object descriptor : newChildDescriptors) {
            EList enablementTasks;
            EClass eClass;
            Resource eResource;
            EObject eObject;
            Object value;
            if (!(descriptor instanceof CommandParameter) || !((value = ((CommandParameter)descriptor).getValue()) instanceof EObject) || !((eObject = (EObject)value) instanceof DynamicSetupTaskImpl) || (eResource = (eClass = eObject.eClass()).eResource()) == null || eResource.getResourceSet() != resourceSet || (enablementTasks = SetupTaskPerformer.createEnablementTasks((EModelElement)eClass, (boolean)true)) == null) continue;
            String typeText = EAnnotations.getText((EClass)eClass);
            if (typeText == null) {
                typeText = iconItemProvider.getTypeText((Object)eObject);
            }
            EnablementAction action = new EnablementAction(shell, eClass, typeText, (EList<SetupTask>)enablementTasks);
            actions.add((IAction)action);
        }
    }

    protected void populateManagerGen(IContributionManager manager, Collection<? extends IAction> actions, String contributionID) {
        if (actions != null) {
            for (IAction iAction : actions) {
                if (contributionID != null) {
                    manager.insertBefore(contributionID, iAction);
                    continue;
                }
                manager.add(iAction);
            }
        }
    }

    protected void populateManager(IContributionManager manager, Collection<? extends IAction> actions, String contributionID) {
        manager.add((IContributionItem)new Separator("elements"));
        manager.add((IContributionItem)new Separator("elements-end"));
        manager.add((IContributionItem)new Separator("groups"));
        manager.add((IContributionItem)new Separator("groups-end"));
        manager.add((IContributionItem)new Separator("scopes"));
        manager.add((IContributionItem)new Separator("scopes"));
        manager.add((IContributionItem)new Separator("scopes-end"));
        manager.add((IContributionItem)new Separator("defaults"));
        manager.add((IContributionItem)new Separator("defaults-end"));
        manager.add((IContributionItem)new Separator("installations"));
        manager.add((IContributionItem)new Separator("installations-end"));
        manager.add((IContributionItem)new Separator("tasks"));
        manager.add((IContributionItem)new Separator("tasks-end"));
        manager.add((IContributionItem)new Separator("annotations"));
        manager.add((IContributionItem)new Separator("annotations-end"));
        manager.add((IContributionItem)new Separator("additions"));
        manager.add((IContributionItem)new Separator("additions-end"));
        ArrayList<IAction> elements = new ArrayList<IAction>();
        ArrayList<IAction> scopes = new ArrayList<IAction>();
        ArrayList<IAction> defaults = new ArrayList<IAction>();
        ArrayList<IAction> installations = new ArrayList<IAction>();
        ArrayList<IAction> tasks = new ArrayList<IAction>();
        ArrayList<IAction> annotations = new ArrayList<IAction>();
        ArrayList<IAction> additions = new ArrayList<IAction>();
        ArrayList<EnablementAction> additionalTasks = new ArrayList<EnablementAction>();
        ArrayList<EnablementAction> additionalElements = new ArrayList<EnablementAction>();
        LinkedHashMap<String, MenuManager> submenuManagers = new LinkedHashMap<String, MenuManager>();
        HashSet<String> installedClasses = new HashSet<String>();
        for (IAction iAction : actions) {
            Object descriptor;
            if (iAction instanceof EnablementAction) {
                EnablementAction additionalTaskAction = (EnablementAction)iAction;
                EClass eClass = additionalTaskAction.getEClass();
                if (SetupPackage.Literals.SETUP_TASK.isSuperTypeOf(eClass)) {
                    additionalTasks.add(additionalTaskAction);
                    continue;
                }
                additionalElements.add(additionalTaskAction);
                continue;
            }
            if (iAction instanceof CreateChildAction) {
                descriptor = ((CreateChildAction)iAction).getDescriptor();
            } else if (iAction instanceof CreateSiblingAction) {
                descriptor = ((CreateSiblingAction)iAction).getDescriptor();
            } else {
                additions.add(iAction);
                continue;
            }
            if (descriptor instanceof ModelElementItemProvider.GroupingChildCommandParameter) {
                String group = ((ModelElementItemProvider.GroupingChildCommandParameter)descriptor).getGroup();
                MenuManager submenuManager = submenuManagers.computeIfAbsent(contributionID, it -> new MenuManager(group, action.getImageDescriptor(), null));
                submenuManager.add(iAction);
                continue;
            }
            if (descriptor instanceof CommandParameter) {
                CommandParameter parameter = (CommandParameter)descriptor;
                Object value = parameter.getValue();
                if (value instanceof Scope) {
                    scopes.add(iAction);
                } else if (value instanceof CompoundTask || value instanceof VariableTask || value instanceof RedirectionTask) {
                    defaults.add(iAction);
                } else if (value instanceof InstallationTask || value instanceof WorkspaceTask) {
                    installations.add(iAction);
                } else if (value instanceof SetupTask) {
                    tasks.add(iAction);
                } else if (value instanceof Annotation) {
                    annotations.add(iAction);
                } else {
                    elements.add(iAction);
                }
                if (!(value instanceof EObject)) continue;
                EClass eClass = ((EObject)value).eClass();
                String installedClass = this.getInstalledClass(eClass);
                installedClasses.add(installedClass);
                continue;
            }
            additions.add(iAction);
        }
        this.removeInstalledClasses(installedClasses, additionalElements);
        Collections.sort(elements, ACTION_COMPARATOR);
        this.removeInstalledClasses(installedClasses, additionalTasks);
        Collections.sort(tasks, ACTION_COMPARATOR);
        this.populateManagerGen(manager, elements, "elements-end");
        for (MenuManager menuManager : submenuManagers.values()) {
            manager.insertBefore("groups-end", (IContributionItem)menuManager);
        }
        if (!additionalElements.isEmpty()) {
            this.populateManagerEnablements(manager, SetupEditorPlugin.INSTANCE.getString("_UI_AdditionalElements_menu_item"), "elements-end", additionalElements);
        }
        this.populateManagerGen(manager, scopes, "scopes-end");
        this.populateManagerGen(manager, defaults, "defaults-end");
        this.populateManagerGen(manager, installations, "installations-end");
        this.populateManagerGen(manager, tasks, "tasks-end");
        if (!additionalTasks.isEmpty()) {
            this.populateManagerEnablements(manager, SetupEditorPlugin.INSTANCE.getString("_UI_AdditionalTasks_menu_item"), "tasks-end", additionalTasks);
        }
        this.populateManagerGen(manager, annotations, "annotations-end");
        this.populateManagerGen(manager, additions, "additions-end");
    }

    private String getInstalledClass(EClass eClass) {
        return eClass.getEPackage().getNsURI() + "#" + eClass.getName();
    }

    private void removeInstalledClasses(Set<String> installedClasses, List<EnablementAction> actions) {
        Iterator<EnablementAction> it = actions.iterator();
        while (it.hasNext()) {
            EnablementAction action = it.next();
            EClass eClass = action.getEClass();
            String installedClass = this.getInstalledClass(eClass);
            if (!installedClasses.contains(installedClass)) continue;
            it.remove();
        }
    }

    private void populateManagerEnablements(IContributionManager manager, String subMenuText, String insertBeforeID, final List<EnablementAction> additionalTasks) {
        int id = ++this.lastSubMenuID;
        String subMenuID = ENABLEMENT_ITEM_PREFIX + id;
        final MenuManager submenuManager = new MenuManager(subMenuText, subMenuID);
        submenuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                UIUtil.asyncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        final ConcurrentLinkedQueue queue = new ConcurrentLinkedQueue(additionalTasks);
                        int jobs = Math.max(queue.size(), 10);
                        int i = 0;
                        while (i < jobs) {
                            Job iconLoader = new Job("IconLoader-" + i){

                                protected IStatus run(IProgressMonitor monitor) {
                                    EnablementAction action;
                                    while ((action = (EnablementAction)((Object)queue.poll())) != null && submenuManager.isVisible() && !monitor.isCanceled()) {
                                        action.loadImage();
                                    }
                                    return Status.OK_STATUS;
                                }
                            };
                            iconLoader.setSystem(true);
                            iconLoader.schedule();
                            ++i;
                        }
                    }
                });
            }
        });
        Collections.sort(additionalTasks, ACTION_COMPARATOR);
        this.populateManagerGen((IContributionManager)submenuManager, additionalTasks, null);
        manager.insertBefore(insertBeforeID, (IContributionItem)submenuManager);
    }

    protected void depopulateManagerGen(IContributionManager manager, Collection<? extends IAction> actions) {
        if (actions != null) {
            IContributionItem[] items = manager.getItems();
            int i = 0;
            while (i < items.length) {
                IAction action;
                IContributionItem contributionItem = items[i];
                while (contributionItem instanceof SubContributionItem) {
                    contributionItem = ((SubContributionItem)contributionItem).getInnerItem();
                }
                if (contributionItem instanceof ActionContributionItem && actions.contains(action = ((ActionContributionItem)contributionItem).getAction())) {
                    manager.remove(contributionItem);
                }
                ++i;
            }
        }
    }

    protected void depopulateManager(IContributionManager manager, Collection<? extends IAction> actions) {
        IContributionItem[] items = manager.getItems();
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                IContributionItem item = items[i];
                if (item instanceof MenuManager) {
                    manager.remove(item);
                } else {
                    String id = item.getId();
                    if (id != null && id.startsWith(ENABLEMENT_ITEM_PREFIX)) {
                        manager.remove(item);
                    }
                }
                ++i;
            }
        }
        this.depopulateManagerGen(manager, actions);
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        super.menuAboutToShow(menuManager);
        MenuManager submenuManager = null;
        submenuManager = new MenuManager(SetupEditorPlugin.INSTANCE.getString("_UI_CreateChild_menu_item"), SetupEditorPlugin.INSTANCE.getImageDescriptor("create_child"), "CreateChild");
        this.populateManager((IContributionManager)submenuManager, this.createChildActions, null);
        menuManager.insertBefore("edit", (IContributionItem)submenuManager);
        submenuManager = new MenuManager(SetupEditorPlugin.INSTANCE.getString("_UI_CreateSibling_menu_item"), SetupEditorPlugin.INSTANCE.getImageDescriptor("create_sibling"), "CreateSibling");
        this.populateManager((IContributionManager)submenuManager, this.createSiblingActions, null);
        menuManager.insertBefore("edit", (IContributionItem)submenuManager);
        if (this.deleteUnrecognizedContentAction.isApplicable()) {
            menuManager.insertBefore("edit", (IAction)this.deleteUnrecognizedContentAction);
        }
        menuManager.insertBefore("ui-actions", (IAction)this.openInSetupEditorAction);
        menuManager.insertBefore("ui-actions", (IAction)this.openInTextEditorAction);
    }

    protected void addGlobalActionsGen(IMenuManager menuManager) {
        menuManager.insertAfter("additions-end", (IContributionItem)new Separator("ui-actions"));
        menuManager.insertAfter("ui-actions", (IAction)this.showPropertiesViewAction);
        this.refreshViewerAction.setEnabled(this.refreshViewerAction.isEnabled());
        menuManager.insertAfter("ui-actions", this.refreshViewerAction);
        super.addGlobalActions(menuManager);
    }

    protected void addGlobalActions(IMenuManager menuManager) {
        this.addGlobalActionsGen(menuManager);
        this.showTooltipsAction.setChecked(SetupActionBarContributor.isShowTooltips());
        menuManager.insertAfter("live", (IContributionItem)new ActionContributionItem((IAction)this.showTooltipsAction));
        menuManager.insertBefore("properties", (IContributionItem)new ActionContributionItem((IAction)this.showInformationBrowserAction));
        menuManager.insertBefore("properties", (IAction)this.showPreviewAction);
        menuManager.insertBefore("properties", (IAction)this.showLaunchConfigurationAction);
        menuManager.insertBefore("load", menuManager.remove("control"));
    }

    protected boolean removeAllReferencesOnDelete() {
        return true;
    }

    public boolean isLiveValidation() {
        return this.liveValidationAction.isChecked();
    }

    public void setLiveValidation(boolean liveValidation) {
        this.liveValidationAction.setChecked(liveValidation);
        this.liveValidationAction.run();
    }

    public void showInformationBrowser(Object object) {
        this.showInformationBrowserAction.open((IStructuredSelection)new StructuredSelection(object));
    }

    public boolean isInformationBrowserShowing() {
        return this.showInformationBrowserAction.isChecked();
    }

    public void openInTextEditor(Object object) {
        this.openInTextEditorAction.open(object);
    }

    public void openInSetupEditor(Object object) {
        this.openInSetupEditorAction.open(object);
    }

    public void openInPropertiesView(SetupEditor setupEditor, Object object, String property) {
        this.showPropertiesViewAction.open(setupEditor, object, property);
    }

    public void dispose() {
        this.showLaunchConfigurationAction.dispose();
        super.dispose();
    }

    private EObject getScope() {
        EObject eObject;
        IStructuredSelection structuredSelection;
        Object element;
        SetupEditor editor = (SetupEditor)this.getActiveEditor();
        EObject rootObject = (EObject)((Resource)editor.getEditingDomain().getResourceSet().getResources().get(0)).getContents().get(0);
        ISelection selection = editor.getSelection();
        if (selection instanceof IStructuredSelection && (element = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof EObject && EcoreUtil.isAncestor((EObject)rootObject, (EObject)(eObject = (EObject)element))) {
            EObject eContainer = eObject;
            while (eContainer != null) {
                if (eContainer instanceof Scope) {
                    return eContainer;
                }
                eContainer = eContainer.eContainer();
            }
        }
        return rootObject;
    }

    static URI getEditURI(Object object, boolean text) {
        if ((object = AdapterFactoryEditingDomain.unwrap((Object)object)) instanceof EObject) {
            EObject eObject = (EObject)object;
            Resource resource = eObject.eResource();
            if (resource != null) {
                ResourceSet resourceSet = resource.getResourceSet();
                if (text || resourceSet == null || resourceSet.getResources().indexOf((Object)resource) != 0) {
                    return EcoreUtil.getURI((EObject)eObject);
                }
            }
        } else if (object instanceof Resource) {
            Resource resource = (Resource)object;
            return resource.getURI();
        }
        return null;
    }

    public static boolean isShowTooltips() {
        return SetupUIPlugin.INSTANCE.getInstancePreference("showTooltips").get(true);
    }

    public static void setShowTooltips(boolean showTooltips) {
        SetupUIPlugin.INSTANCE.getInstancePreference("showTooltips").set(showTooltips);
    }

    private static final class CommandTableAction
    extends AbstractTableAction {
        public CommandTableAction() {
            super(Messages.SetupActionBarContributor_action_commandTable);
            this.setImageDescriptor(SetupEditorPlugin.INSTANCE.getImageDescriptor("commands"));
            this.setToolTipText(Messages.SetupActionBarContributor_action_commandTable_tooltip);
        }

        @Override
        protected String renderHTML() {
            List commands;
            IBindingService bindingService = (IBindingService)UIUtil.getService((IServiceLocator)PlatformUI.getWorkbench(), IBindingService.class);
            Binding[] bindings = bindingService.getBindings();
            HashMap<String, ArrayList<org.eclipse.core.commands.Command>> map = new HashMap<String, ArrayList<org.eclipse.core.commands.Command>>();
            ICommandService commandService = (ICommandService)UIUtil.getService((IServiceLocator)PlatformUI.getWorkbench(), ICommandService.class);
            org.eclipse.core.commands.Command[] commandArray = commandService.getDefinedCommands();
            int n = commandArray.length;
            int n2 = 0;
            while (n2 < n) {
                org.eclipse.core.commands.Command command = commandArray[n2];
                try {
                    String category = command.getCategory().getName();
                    if (category == null || category.length() == 0) {
                        category = command.getCategory().getId();
                    }
                    if ((commands = (ArrayList<org.eclipse.core.commands.Command>)map.get(category)) == null) {
                        commands = new ArrayList<org.eclipse.core.commands.Command>();
                        map.put(category, (ArrayList<org.eclipse.core.commands.Command>)commands);
                    }
                    commands.add(command);
                }
                catch (NotDefinedException ex) {
                    SetupEditorPlugin.getPlugin().log((Object)ex);
                }
                ++n2;
            }
            ArrayList categories = new ArrayList(map.keySet());
            Collections.sort(categories);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream out = new PrintStream(baos);
            out.println("<table border=\"1\">");
            for (String category : categories) {
                out.println("<tr><td colspan=\"3\" bgcolor=\"eae6ff\"><br><h2>" + category + "</h2></td></tr>");
                commands = (List)map.get(category);
                Collections.sort(commands);
                for (org.eclipse.core.commands.Command command : commands) {
                    String name;
                    StringBuilder keys = new StringBuilder();
                    Binding[] bindingArray = bindings;
                    int n3 = bindings.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Binding binding = bindingArray[n4];
                        ParameterizedCommand parameterizedCommand = binding.getParameterizedCommand();
                        if (parameterizedCommand != null && parameterizedCommand.getId().equals(command.getId())) {
                            if (keys.length() != 0) {
                                keys.append("<br>");
                            }
                            keys.append(binding.getTriggerSequence());
                        }
                        ++n4;
                    }
                    if (keys.length() == 0) {
                        keys.append("&nbsp;");
                    }
                    try {
                        name = command.getName();
                    }
                    catch (NotDefinedException ex) {
                        name = command.getId();
                    }
                    out.println("<tr><td valign=\"top\" width=\"200\">" + name + "</td><td valign=\"top\" width=\"400\">" + command.getId() + "</td><td valign=\"top\" width=\"100\">" + String.valueOf(keys) + "</td></tr>");
                }
            }
            out.println("</table>");
            try {
                out.flush();
                return baos.toString("UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                return Messages.SetupActionBarContributor_html_Utf8IsUnsupported;
            }
        }

        protected Class<CommandTableDialog> getDialogClass() {
            return CommandTableDialog.class;
        }

        protected DockableDialog.Factory<CommandTableDialog> getDialogFactory() {
            return new DockableDialog.Factory<CommandTableDialog>(){

                public CommandTableDialog create(IWorkbenchWindow workbenchWindow) {
                    return new CommandTableDialog(workbenchWindow, this);
                }
            };
        }

        private static final class CommandTableDialog
        extends AbstractTableAction.TableDialog {
            public CommandTableDialog(IWorkbenchWindow workbenchWindow, AbstractTableAction tableAction) {
                super(workbenchWindow, tableAction);
            }

            protected IDialogSettings getDialogBoundsSettings() {
                return SetupEditorPlugin.INSTANCE.getDialogSettings("CommandTable");
            }
        }
    }

    private static final class CreateChildAction
    extends org.eclipse.emf.edit.ui.action.CreateChildAction {
        public CreateChildAction(EditingDomain editingDomain, ISelection selection, Object descriptor) {
            super(editingDomain, selection, descriptor);
        }

        public CreateChildAction(IEditorPart editorPart, ISelection selection, Object descriptor) {
            super(editorPart, selection, descriptor);
        }

        public CreateChildAction(IWorkbenchPart workbenchPart, ISelection selection, Object descriptor) {
            super(workbenchPart, selection, descriptor);
        }

        public Object getDescriptor() {
            return this.descriptor;
        }
    }

    private static final class CreateSiblingAction
    extends org.eclipse.emf.edit.ui.action.CreateSiblingAction {
        public CreateSiblingAction(EditingDomain editingDomain, ISelection selection, Object descriptor) {
            super(editingDomain, selection, descriptor);
        }

        public CreateSiblingAction(IEditorPart editorPart, ISelection selection, Object descriptor) {
            super(editorPart, selection, descriptor);
        }

        public CreateSiblingAction(IWorkbenchPart workbenchPart, ISelection selection, Object descriptor) {
            super(workbenchPart, selection, descriptor);
        }

        public Object getDescriptor() {
            return this.descriptor;
        }
    }

    private static class DeleteUnrecognizedContentAction
    extends Action {
        private XMLResource resource;
        private SetupEditor setupEditor;

        public DeleteUnrecognizedContentAction() {
            this.setText(Messages.SetupActionBarContributor_action_deleteUnrecognizedContent);
            this.setImageDescriptor(SetupEditorPlugin.INSTANCE.getImageDescriptor("remove_unrecognized_content"));
        }

        public void run() {
            EditingDomain editingDomain = this.setupEditor.getEditingDomain();
            AbstractCommand command = new AbstractCommand(this.getText()){
                private Map<EObject, AnyType> eObjectToExtensionMap;

                protected boolean prepare() {
                    this.eObjectToExtensionMap = new LinkedHashMap<EObject, AnyType>(resource.getEObjectToExtensionMap());
                    return true;
                }

                public void execute() {
                    resource.getEObjectToExtensionMap().clear();
                }

                public void undo() {
                    resource.getEObjectToExtensionMap().putAll(this.eObjectToExtensionMap);
                }

                public void redo() {
                    this.execute();
                }
            };
            editingDomain.getCommandStack().execute((Command)command);
        }

        public void setActiveWorkbenchPart(IWorkbenchPart workbenchPart) {
            if (workbenchPart instanceof SetupEditor) {
                this.setupEditor = (SetupEditor)workbenchPart;
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
                this.setupEditor = null;
            }
        }

        public boolean isApplicable() {
            return this.resource != null;
        }

        public final void selectionChanged(SelectionChangedEvent event) {
            Object element;
            this.resource = null;
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (selection.size() == 1 && (element = selection.getFirstElement()) instanceof XMLResource) {
                this.resource = (XMLResource)element;
            }
            this.setEnabled(this.resource != null && !this.resource.getEObjectToExtensionMap().isEmpty());
        }
    }

    private static final class EditorTableAction
    extends AbstractTableAction {
        public EditorTableAction() {
            super(Messages.SetupActionBarContributor_action_editorTable);
            this.setImageDescriptor(SetupEditorPlugin.INSTANCE.getImageDescriptor("FileEditor"));
            this.setToolTipText(Messages.SetupActionBarContributor_action_editorTable_tooltip);
        }

        @Override
        protected String renderHTML() {
            IEditorDescriptor[] editors;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintStream out = new PrintStream(baos);
            out.println("<table border=\"1\">");
            out.println("<tr><td bgcolor=\"eae6ff\">ID</td><td bgcolor=\"eae6ff\">Label</td></tr>");
            EditorRegistry registry = (EditorRegistry)PlatformUI.getWorkbench().getEditorRegistry();
            IEditorDescriptor[] iEditorDescriptorArray = editors = registry.getSortedEditorsFromPlugins();
            int n = editors.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorDescriptor editor = iEditorDescriptorArray[n2];
                out.println("<tr><td>" + editor.getId() + "</td><td>" + editor.getLabel() + "</td></tr>");
                ++n2;
            }
            out.println("</table>");
            try {
                out.flush();
                return baos.toString("UTF-8");
            }
            catch (UnsupportedEncodingException ex) {
                return Messages.SetupActionBarContributor_html_Utf8IsUnsupported;
            }
        }

        protected Class<EditorTableDialog> getDialogClass() {
            return EditorTableDialog.class;
        }

        protected DockableDialog.Factory<EditorTableDialog> getDialogFactory() {
            return new DockableDialog.Factory<EditorTableDialog>(){

                public EditorTableDialog create(IWorkbenchWindow workbenchWindow) {
                    return new EditorTableDialog(workbenchWindow, this);
                }
            };
        }

        private static final class EditorTableDialog
        extends AbstractTableAction.TableDialog {
            public EditorTableDialog(IWorkbenchWindow workbenchWindow, AbstractTableAction tableAction) {
                super(workbenchWindow, tableAction);
            }

            protected IDialogSettings getDialogBoundsSettings() {
                return SetupEditorPlugin.INSTANCE.getDialogSettings("EditorTable");
            }
        }
    }

    public static class LaunchConfigurationsDialog
    extends Dialog {
        private static final Class<?> LAUNCH_VIEW_MODEL_CLASS;
        private static final Constructor<IContentProvider> LAUNCH_VIEW_CONTENT_PROVIDER_CONSTRUCTOR;
        private static final Constructor<DelegatingStyledCellLabelProvider.IStyledLabelProvider> LAUNCH_VIEW_LABEL_PROVIDER_CONSTRUCTOR;
        public static boolean IS_AVAILBLE;
        protected TreeViewer tree;
        protected ISelectionProvider activePart;

        static {
            Class launchViewModelClass = null;
            Constructor launchViewContentProviderConstructor = null;
            Constructor launchViewLabelProviderConstructor = null;
            try {
                Object[] objectArray = new Object[3];
                launchViewModelClass = CommonPlugin.loadClass((String)"org.eclipse.debug.ui.launchview", (String)"org.eclipse.debug.ui.launchview.internal.model.LaunchViewModel");
                objectArray[0] = launchViewModelClass;
                objectArray[1] = launchViewContentProviderConstructor = CommonPlugin.loadClass((String)"org.eclipse.debug.ui.launchview", (String)"org.eclipse.debug.ui.launchview.internal.view.LaunchViewContentProvider").getConstructor(new Class[0]);
                objectArray[2] = launchViewLabelProviderConstructor = CommonPlugin.loadClass((String)"org.eclipse.debug.ui.launchview", (String)"org.eclipse.debug.ui.launchview.internal.view.LaunchViewLabelProvider").getConstructor(new Class[0]);
                Object[] objectArray2 = objectArray;
            }
            catch (ClassNotFoundException | NoSuchMethodException | SecurityException exception) {
                // empty catch block
            }
            LAUNCH_VIEW_MODEL_CLASS = launchViewModelClass;
            LAUNCH_VIEW_CONTENT_PROVIDER_CONSTRUCTOR = launchViewContentProviderConstructor;
            LAUNCH_VIEW_LABEL_PROVIDER_CONSTRUCTOR = launchViewLabelProviderConstructor;
            IS_AVAILBLE = LAUNCH_VIEW_MODEL_CLASS != null && LAUNCH_VIEW_CONTENT_PROVIDER_CONSTRUCTOR != null && LAUNCH_VIEW_LABEL_PROVIDER_CONSTRUCTOR != null;
        }

        public LaunchConfigurationsDialog(IWorkbenchWindow workbenchWindow) {
            super((IShellProvider)workbenchWindow);
            this.setShellStyle(2160);
        }

        protected IDialogSettings getDialogBoundsSettings() {
            return SetupEditorPlugin.INSTANCE.getDialogSettings("LaunchConfigurations");
        }

        protected Control createDialogArea(Composite parent) {
            this.getShell().setText(Messages.SetupActionBarContributor_LaunchConfiguration_title);
            this.tree = new TreeViewer(parent);
            this.tree.setAutoExpandLevel(-1);
            List<OomphTransferDelegate> dndDelegates = Arrays.asList(new OomphTransferDelegate.URLTransferDelegate(), new OomphTransferDelegate.TextTransferDelegate());
            Transfer[] dndTransfers = new Transfer[]{dndDelegates.get(0).getTransfer(), dndDelegates.get(1).getTransfer()};
            this.tree.addDragSupport(7, dndTransfers, (DragSourceListener)new GeneralDragAdapter((Viewer)this.tree, new GeneralDragAdapter.DraggedObjectsFactory(){

                public List<Object> createDraggedObjects(ISelection selection) throws Exception {
                    ArrayList<Object> result = new ArrayList<Object>();
                    Object[] objectArray = ((IStructuredSelection)selection).toArray();
                    int n = objectArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object object = objectArray[n2];
                        Object convertedObject = this.convertLaunchViewObject(object);
                        if (convertedObject != null) {
                            result.add(convertedObject);
                        }
                        ++n2;
                    }
                    return result;
                }
            }, dndDelegates));
            this.init();
            GridLayout layout = new GridLayout();
            layout.marginHeight = this.convertVerticalDLUsToPixels(7);
            layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
            layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
            layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
            Tree treeControl = this.tree.getTree();
            treeControl.setLayout((Layout)layout);
            GridData layoutData = new GridData(1808);
            layoutData.heightHint = 800;
            layoutData.widthHint = 400;
            treeControl.setLayoutData((Object)layoutData);
            LaunchConfigurationsDialog.applyDialogFont((Control)treeControl);
            return treeControl;
        }

        protected Object convertLaunchViewObject(Object object) {
            try {
                Object launchObject = ReflectUtil.invokeMethod((String)"getObject", (Object)object);
                if (launchObject != null) {
                    Object value = ReflectUtil.getValue((String)"config", (Object)launchObject);
                    IFileStore fileStore = (IFileStore)ReflectUtil.invokeMethod((String)"getFileStore", (Object)value);
                    String content = new String(fileStore.openInputStream(0, null).readAllBytes(), StandardCharsets.UTF_8);
                    String escapedContent = SetupUtil.escape((String)content);
                    ResourceCreationTask resourceCreationTask = SetupFactory.eINSTANCE.createResourceCreationTask();
                    resourceCreationTask.setContent(escapedContent);
                    java.net.URI uri = fileStore.toURI();
                    IFile[] filesForLocationURI = ResourcesUtil.findFilesForLocationURI((java.net.URI)uri);
                    if (filesForLocationURI.length != 0) {
                        resourceCreationTask.setTargetURL(URI.createPlatformResourceURI((String)filesForLocationURI[0].getFullPath().toString(), (boolean)true).toString());
                    } else {
                        java.net.URI workspaceLocation = ResourcesPlugin.getWorkspace().getRoot().getLocationURI();
                        java.net.URI workspaceRelativeLocation = workspaceLocation.relativize(uri);
                        if (workspaceRelativeLocation.toString().startsWith(".metadata")) {
                            resourceCreationTask.setTargetURL("${workspace.location|uri}/" + String.valueOf(workspaceRelativeLocation));
                        } else {
                            resourceCreationTask.setTargetURL(uri.toString());
                        }
                    }
                    return resourceCreationTask;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        protected void init() {
            try {
                IContentProvider contentProvider = LAUNCH_VIEW_CONTENT_PROVIDER_CONSTRUCTOR.newInstance(new Object[0]);
                DelegatingStyledCellLabelProvider.IStyledLabelProvider labelProvider = LAUNCH_VIEW_LABEL_PROVIDER_CONSTRUCTOR.newInstance(new Object[0]);
                this.tree.setContentProvider(contentProvider);
                this.tree.setLabelProvider((IBaseLabelProvider)new DelegatingStyledCellLabelProvider(labelProvider));
                this.tree.setInput(ReflectUtil.invokeMethod((String)"getModel", (Object)ReflectUtil.invokeMethod((Method)ReflectUtil.getMethod(LAUNCH_VIEW_MODEL_CLASS, (String)"getService", (Class[])new Class[0]), null, (Object[])new Object[0])));
            }
            catch (Exception ex) {
                SetupEditorPlugin.getPlugin().log(ex);
            }
        }

        protected Control createButtonBar(Composite parent) {
            return null;
        }
    }

    private static final class OpenInSetupEditorAction
    extends Action {
        private URI uri;
        private SetupEditor setupEditor;

        public OpenInSetupEditorAction() {
            this.setText(Messages.SetupActionBarContributor_action_openInSetupEditor);
            this.setImageDescriptor(SetupEditorPlugin.INSTANCE.getImageDescriptor("edit_setup"));
        }

        public void run() {
            this.open(this.uri);
        }

        public void open(Object object) {
            URI uri = SetupActionBarContributor.getEditURI(object, true);
            if ("performer".equals(uri.scheme())) {
                SetupEditorSupport.getEditor((IWorkbenchPage)this.setupEditor.getSite().getWorkbenchWindow().getActivePage(), (IEditorInput)OpenInTextEditorAction.createEditorInput(uri.trimFragment(), object), (URI)uri, (boolean)true, (SetupEditorSupport.LoadHandler[])new SetupEditorSupport.LoadHandler[0]);
            } else {
                this.open(uri);
            }
        }

        public void open(URI uri) {
            SetupEditorSupport.getEditor((IWorkbenchPage)this.setupEditor.getSite().getWorkbenchWindow().getActivePage(), (URI)uri, (boolean)true, (SetupEditorSupport.LoadHandler[])new SetupEditorSupport.LoadHandler[0]);
        }

        public void setActiveWorkbenchPart(IWorkbenchPart workbenchPart) {
            if (workbenchPart instanceof SetupEditor) {
                this.setupEditor = (SetupEditor)workbenchPart;
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
                this.setupEditor = null;
            }
        }

        public final void selectionChanged(SelectionChangedEvent event) {
            this.uri = null;
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (selection.size() == 1) {
                Object object = selection.getFirstElement();
                this.uri = SetupActionBarContributor.getEditURI(object, false);
            }
            this.setEnabled(this.uri != null);
        }
    }

    private static final class OpenInTextEditorAction
    extends Action {
        private Object object;
        private URI uri;
        private SetupEditor setupEditor;

        public OpenInTextEditorAction() {
            this.setText(Messages.SetupActionBarContributor_action_openInTextEditor);
            this.setImageDescriptor(SetupEditorPlugin.INSTANCE.getImageDescriptor("edit_text"));
        }

        public void run() {
            if ("performer".equals(this.uri.scheme())) {
                SetupEditorSupport.getTextEditor((IWorkbenchPage)this.setupEditor.getSite().getWorkbenchWindow().getActivePage(), (IEditorInput)OpenInTextEditorAction.createEditorInput(this.uri.trimFragment(), this.object));
            } else {
                this.open(this.uri);
            }
        }

        public static IEditorInput createEditorInput(final URI uri, Object object) {
            final Resource resource = object instanceof Resource ? (Resource)object : ((EObject)object).eResource();
            IStorageEditorInput editorInput = new IStorageEditorInput(){

                public Object getAdapter(Class adapter) {
                    if (adapter == IStorage.class) {
                        try {
                            return this.getStorage();
                        }
                        catch (CoreException coreException) {
                            // empty catch block
                        }
                    }
                    return null;
                }

                public String getToolTipText() {
                    return uri.toString();
                }

                public IPersistableElement getPersistable() {
                    return null;
                }

                public String getName() {
                    return uri.lastSegment();
                }

                public ImageDescriptor getImageDescriptor() {
                    return null;
                }

                public boolean exists() {
                    return true;
                }

                public IStorage getStorage() throws CoreException {
                    return new IStorage(){

                        public Object getAdapter(Class adapter) {
                            return null;
                        }

                        public boolean isReadOnly() {
                            return true;
                        }

                        public String getName() {
                            return uri.lastSegment();
                        }

                        public IPath getFullPath() {
                            return new Path(uri.toString());
                        }

                        public InputStream getContents() throws CoreException {
                            try {
                                ByteArrayOutputStream out = new ByteArrayOutputStream();
                                resource.save((OutputStream)out, null);
                                return new ByteArrayInputStream(out.toByteArray());
                            }
                            catch (IOException ex) {
                                SetupEditorPlugin.INSTANCE.coreException(ex);
                                return new ByteArrayInputStream(new byte[0]);
                            }
                        }
                    };
                }
            };
            return editorInput;
        }

        public void open(Object object) {
            URI uri = SetupActionBarContributor.getEditURI(object, true);
            if ("performer".equals(uri.scheme())) {
                SetupEditorSupport.getTextEditor((IWorkbenchPage)this.setupEditor.getSite().getWorkbenchWindow().getActivePage(), (IEditorInput)OpenInTextEditorAction.createEditorInput(uri.trimFragment(), object));
            } else {
                this.open(uri);
            }
        }

        public void open(URI uri) {
            SetupEditorSupport.getTextEditor((IWorkbenchPage)this.setupEditor.getSite().getWorkbenchWindow().getActivePage(), (URI)uri);
        }

        public void setActiveWorkbenchPart(IWorkbenchPart workbenchPart) {
            if (workbenchPart instanceof SetupEditor) {
                this.setupEditor = (SetupEditor)workbenchPart;
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
                this.setupEditor = null;
            }
        }

        public final void selectionChanged(SelectionChangedEvent event) {
            this.uri = null;
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (selection.size() == 1) {
                this.object = selection.getFirstElement();
                this.uri = SetupActionBarContributor.getEditURI(this.object, true);
            }
            this.setEnabled(this.uri != null);
        }
    }

    private class PreferenceCaptureToolbarAction
    extends Action {
        private SetupEditor setupEditor;
        private boolean fromEclipsePreferenceFile;

        public PreferenceCaptureToolbarAction(boolean fromEclipsePreferenceFile) {
            super(fromEclipsePreferenceFile ? Messages.SetupActionBarContributor_action_preferenceCapture_importPrefs : Messages.SetupActionBarContributor_action_preferenceCapture_capturePrefs, SetupEditorPlugin.INSTANCE.getImageDescriptor(fromEclipsePreferenceFile ? "preference_importer" : "preference_picker"));
            this.fromEclipsePreferenceFile = fromEclipsePreferenceFile;
        }

        public void run() {
            PreferenceCaptureDialog preferenceCaptureDialog = new PreferenceCaptureDialog(null, this.setupEditor.getAdapterFactory(), this.fromEclipsePreferenceFile);
            if (preferenceCaptureDialog.open() == 0) {
                RecorderManager.INSTANCE.setTemporaryRecorderTarget(EcoreUtil.getURI((EObject)SetupActionBarContributor.this.getScope()));
                RecorderTransaction transaction = RecorderTransaction.open((IEditorPart)this.setupEditor);
                try {
                    transaction.setPreferences(preferenceCaptureDialog.getResult());
                    transaction.commit();
                }
                finally {
                    transaction.close();
                    RecorderManager.INSTANCE.setTemporaryRecorderTarget(null);
                }
            }
        }

        public void setActiveWorkbenchPart(IWorkbenchPart workbenchPart) {
            if (workbenchPart instanceof SetupEditor) {
                this.setupEditor = (SetupEditor)workbenchPart;
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
                this.setupEditor = null;
            }
        }
    }

    private class PreferenceRecorderToolbarAction
    extends Action {
        public PreferenceRecorderToolbarAction(boolean withDialog) {
            super(Messages.SetupActionBarContributor_action_recordPreferences, SetupEditorPlugin.INSTANCE.getImageDescriptor("preference_recorder"));
        }

        public void run() {
            RecorderManager.INSTANCE.setTemporaryRecorderTarget(EcoreUtil.getURI((EObject)SetupActionBarContributor.this.getScope()));
            RecorderManager.INSTANCE.record(SetupActionBarContributor.this.getActiveEditor());
        }
    }

    protected static class SetupWorkingSetsProvider
    extends WorkingSetsActionBarContributor.PreviewDialog.WorkingSetsProvider {
        protected SetupWorkingSetsProvider() {
        }

        protected List<WorkingSet> getWorkingSets(IStructuredSelection selection) {
            Object[] objectArray = selection.toArray();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object object = objectArray[n2];
                if (object instanceof EObject) {
                    EObject eObject = (EObject)object;
                    while (eObject != null) {
                        List<WorkingSet> workingSets = this.getWorkingSets(eObject);
                        if (workingSets != null) {
                            return workingSets;
                        }
                        eObject = eObject.eContainer();
                    }
                }
                ++n2;
            }
            return Collections.emptyList();
        }

        private List<WorkingSet> getWorkingSets(EObject eObject) {
            for (EReference eReference : eObject.eClass().getEAllReferences()) {
                if (!eReference.isMany() || eReference.getEType() != WorkingSetsPackage.Literals.WORKING_SET) continue;
                EList value = (EList)eObject.eGet((EStructuralFeature)eReference);
                return value;
            }
            return null;
        }
    }

    private static final class ShowInformationBrowserAction
    extends Action {
        private SetupEditor setupEditor;

        public ShowInformationBrowserAction() {
            super(Messages.SetupActionBarContributor_action_showInformationBrowser, 2);
            this.setImageDescriptor(SetupEditorPlugin.INSTANCE.getImageDescriptor("open_browser"));
        }

        public void run() {
            if (this.isChecked()) {
                IStructuredSelection selection = (IStructuredSelection)this.setupEditor.getSelection();
                this.open(selection);
            } else {
                SetupEditor.BrowserDialog.closeFor(this.setupEditor.getSite().getWorkbenchWindow());
            }
        }

        public void open(IStructuredSelection selection) {
            EList resources;
            SetupEditor.BrowserDialog browserDialog = SetupEditor.BrowserDialog.openFor(this.setupEditor.getSite().getWorkbenchWindow());
            Object object = selection.getFirstElement();
            if (object == null && !(resources = this.setupEditor.getEditingDomain().getResourceSet().getResources()).isEmpty()) {
                object = resources.get(0);
            }
            browserDialog.setInput(this.setupEditor, object);
            browserDialog.getDockable().associate((IAction)this);
        }

        public void setActiveWorkbenchPart(IWorkbenchPart workbenchPart) {
            if (workbenchPart instanceof SetupEditor) {
                this.setupEditor = (SetupEditor)workbenchPart;
                this.setEnabled(true);
                SetupEditor.BrowserDialog browserDialog = SetupEditor.BrowserDialog.getFor(workbenchPart.getSite().getWorkbenchWindow());
                if (browserDialog != null) {
                    browserDialog.getDockable().associate((IAction)this);
                }
            } else {
                this.setEnabled(false);
                this.setupEditor = null;
            }
        }
    }

    public static class ShowLaunchConfigurationsAction
    extends Action {
        private IWorkbenchPart activePart;
        private LaunchConfigurationsDialog launchConfigurationsDialog;

        public ShowLaunchConfigurationsAction() {
            super(Messages.SetupActionBarContributor_LaunchConfigurations_label, 1);
            this.setImageDescriptor(SetupEditorPlugin.INSTANCE.getImageDescriptor("launch_ configurations"));
            this.setEnabled(LaunchConfigurationsDialog.IS_AVAILBLE);
        }

        public void run() {
            Shell shell;
            if (this.launchConfigurationsDialog != null && (shell = this.launchConfigurationsDialog.getShell()) != null && !shell.isDisposed()) {
                shell.setActive();
                return;
            }
            this.launchConfigurationsDialog = new LaunchConfigurationsDialog(this.activePart.getSite().getWorkbenchWindow());
            this.launchConfigurationsDialog.setBlockOnOpen(false);
            this.launchConfigurationsDialog.open();
        }

        public void setActiveWorkbenchPart(IWorkbenchPart workbenchPart) {
            if (workbenchPart instanceof WorkingSetsActionBarContributor.PreviewDialog.Previewable) {
                this.activePart = workbenchPart;
                this.setEnabled(true);
                WorkingSetsActionBarContributor.PreviewDialog previewDialog = WorkingSetsActionBarContributor.PreviewDialog.getFor((IWorkbenchWindow)workbenchPart.getSite().getWorkbenchWindow());
                if (previewDialog != null) {
                    previewDialog.getDockable().associate((IAction)this);
                }
            } else {
                this.setEnabled(false);
                this.activePart = null;
            }
        }

        public void dispose() {
            Shell shell;
            if (this.launchConfigurationsDialog != null && (shell = this.launchConfigurationsDialog.getShell()) != null && !shell.isDisposed()) {
                shell.dispose();
            }
        }
    }

    private static class ShowPropertiesViewAction
    extends Action {
        private IWorkbenchPage page;

        private ShowPropertiesViewAction() {
            super(SetupEditorPlugin.INSTANCE.getString("_UI_ShowPropertiesView_menu_item"), SetupEditorPlugin.INSTANCE.getImageDescriptor("show_properties_view"));
            this.setId("properties");
        }

        public void setPage(IWorkbenchPage page) {
            this.page = page;
        }

        public void run() {
            try {
                this.page.showView("org.eclipse.ui.views.PropertySheet");
            }
            catch (PartInitException exception) {
                SetupEditorPlugin.INSTANCE.log(exception);
            }
        }

        public void open(SetupEditor setupEditor, Object object, String property) {
            block4: {
                try {
                    PropertySheet propertySheet;
                    IPage page;
                    IViewPart propertiesView = this.page.showView("org.eclipse.ui.views.PropertySheet");
                    if (!(propertiesView instanceof PropertySheet) || !((page = (propertySheet = (PropertySheet)propertiesView).getCurrentPage()) instanceof ISelectionListener)) break block4;
                    ((ISelectionListener)page).selectionChanged((IWorkbenchPart)setupEditor, (ISelection)new StructuredSelection(object));
                    Control control = page.getControl();
                    if (!(control instanceof Tree)) break block4;
                    Tree tree = (Tree)control;
                    TreeItem[] treeItemArray = tree.getItems();
                    int n = treeItemArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TreeItem treeItem = treeItemArray[n2];
                        if (property.equals(treeItem.getText())) {
                            tree.select(treeItem);
                            break;
                        }
                        ++n2;
                    }
                }
                catch (PartInitException exception) {
                    SetupEditorPlugin.INSTANCE.log(exception);
                }
            }
        }
    }

    private static final class ShowTooltipsAction
    extends Action {
        public ShowTooltipsAction() {
            this.setText(Messages.SetupActionBarContributor_action_showTooltips);
            this.setChecked(SetupActionBarContributor.isShowTooltips());
            this.setImageDescriptor(SetupEditorPlugin.INSTANCE.getImageDescriptor("show_tooltips"));
        }

        public void run() {
            boolean show = this.isChecked();
            SetupActionBarContributor.setShowTooltips(show);
        }
    }

    @Deprecated
    private class TestInstallAction
    extends Action {
        private Project project;

        public TestInstallAction() {
            super(Messages.SetupActionBarContributor_action_testInstall, 1);
            this.setImageDescriptor(SetupEditorPlugin.INSTANCE.getImageDescriptor("run"));
            this.setToolTipText(Messages.SetupActionBarContributor_action_testInstall_tooltip);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            Object element;
            IStructuredSelection structuredSelection;
            ISelection selection = event.getSelection();
            if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1 && (element = structuredSelection.getFirstElement()) instanceof EObject) {
                this.project = this.getProject((EObject)element);
                if (this.project != null) {
                    this.setEnabled(true);
                    return;
                }
            }
            this.project = null;
            this.setEnabled(false);
        }

        public void run() {
        }

        private Project getProject(EObject object) {
            while (object != null && !(object instanceof Project)) {
                object = object.eContainer();
            }
            return (Project)object;
        }
    }

    protected static final class ToggleViewerInputAction
    extends Action {
        private SetupEditor setupEditor;

        public ToggleViewerInputAction() {
            super(Messages.SetupActionBarContributor_action_showResources, 2);
            this.setImageDescriptor(SetupEditorPlugin.INSTANCE.getImageDescriptor("ToggleInput"));
            this.setToolTipText(Messages.SetupActionBarContributor_action_showResources_tooltip);
        }

        public void run() {
            this.setupEditor.toggleInput();
        }

        public void select(ISelection selection) {
            this.setupEditor.selectionViewer.setSelection(selection, true);
        }

        public void setActiveWorkbenchPart(IWorkbenchPart workbenchPart) {
            if (workbenchPart instanceof SetupEditor) {
                this.setupEditor = (SetupEditor)workbenchPart;
                this.setEnabled(true);
                this.setChecked(this.setupEditor.selectionViewer.getInput() instanceof ResourceSet);
            } else {
                this.setEnabled(false);
                this.setupEditor = null;
            }
        }
    }
}

