/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.presentation.handlers;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.oomph.setup.presentation.SetupEditorPlugin;
import org.eclipse.oomph.setup.ui.SetupPropertyTester;
import org.eclipse.oomph.util.Request;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;

public class ProblemHandler
extends AbstractHandler {
    public void setEnabled(Object evaluationContext) {
        this.setBaseEnabled(SetupPropertyTester.getProblem() != null);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
        try {
            String problem = SetupPropertyTester.getProblem();
            URL url = this.getEnhancedURL(problem);
            IWebBrowser browser = browserSupport.createBrowser(128, "problem", SetupEditorPlugin.INSTANCE.getString("_UI_ReportProblem_label"), problem);
            browser.openURL(url);
        }
        catch (Exception ex) {
            SetupEditorPlugin.INSTANCE.log(ex, 2);
        }
        return 0;
    }

    private URL getEnhancedURL(String url) throws MalformedURLException {
        Request request = new Request(url);
        IProduct product = Platform.getProduct();
        if (product != null) {
            request.put((Object)"product-id", (Object)product.getId());
            Bundle definingBundle = product.getDefiningBundle();
            if (definingBundle != null) {
                String symbolicName = definingBundle.getSymbolicName();
                request.put((Object)"bundle-id", (Object)symbolicName);
                Version version = definingBundle.getVersion();
                request.put((Object)"bundle-version", (Object)version.toString());
            }
        }
        request.put((Object)"java.vendor", (Object)System.getProperty("java.vendor"));
        request.put((Object)"java.version", (Object)System.getProperty("java.version"));
        return new URL(request.getURI().toString());
    }
}

