/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.sse.core.indexing;

import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceProxy;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.sse.core.internal.Logger;
import org.eclipse.wst.sse.core.internal.SSECoreMessages;

public abstract class AbstractIndexManager {
    private static final String ENCODING_UTF16 = "utf16";
    private static final int WAIT_TIME = 300;
    private static final int UNKNOWN_WORK = 100;
    private static final int BATCH_UP_AMOUNT = 100;
    private static final String RE_PROCESS_FILE_NAME = ".re-process";
    private static final String LOG_ERROR_INDEX_INVALID = "Index may become invalid, incomplete, or enter some other inconsistent state.";
    private static final byte STATE_DISABLED = 0;
    private static final byte STATE_ENABLED = 1;
    protected static final byte ACTION_ADD = 0;
    protected static final byte ACTION_REMOVE = 1;
    protected static final byte ACTION_ADD_MOVE_FROM = 2;
    protected static final byte ACTION_REMOVE_MOVE_TO = 3;
    protected static final byte SOURCE_RESOURCE_CHANGE = 0;
    protected static final byte SOURCE_WORKSPACE_SCAN = 1;
    protected static final byte SOURCE_SAVED_STATE = 2;
    protected static final byte SOURCE_PRESERVED_RESOURCES_TO_INDEX = 3;
    private String fName;
    private ResourceChangeListener fResourceChangeListener;
    private ResourceEventProcessingJob fResourceEventProcessingJob;
    private Job fWorkspaceVisitorJob;
    private static final boolean DEBUG = Platform.getDebugBoolean((String)"org.eclipse.wst.sse.core/index");
    private static final boolean DEBUG_LIFECYCLE = Platform.getDebugBoolean((String)"org.eclipse.wst.sse.core/index/lifecycle");
    private volatile byte fState;
    private Object fStartStopLock = new Object();
    private boolean fStarting;

    protected AbstractIndexManager(String name) {
        this.fName = name;
        this.fState = 0;
        this.fResourceChangeListener = new ResourceChangeListener();
        this.fResourceEventProcessingJob = new ResourceEventProcessingJob();
        this.fStarting = false;
    }

    protected AbstractIndexManager(String name, String messageRunning, String messageInitializing, String messageProcessingFiles) {
        this(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start(IResourceDelta savedStateDelta, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        Object object = this.fStartStopLock;
        synchronized (object) {
            this.fStarting = true;
            try {
                if (this.fState == 0) {
                    progress.beginTask(NLS.bind((String)SSECoreMessages.IndexManager_0_starting, (Object)this.fName), 2);
                    this.fResourceChangeListener.start();
                    boolean fullReindexNeeded = this.isFullReIndexNeeded();
                    boolean bl = !this.fResourceEventProcessingJob.start(!fullReindexNeeded, progress.newChild(1));
                    progress.setWorkRemaining(1);
                    if (!(fullReindexNeeded |= bl)) {
                        if (savedStateDelta != null) {
                            try {
                                SubMonitor savedStateProgress = progress.newChild(1, 0);
                                savedStateProgress.setTaskName(NLS.bind((String)SSECoreMessages.IndexManager_0_starting_1, (Object[])new String[]{this.fName, SSECoreMessages.IndexManager_processing_deferred_resource_changes}));
                                ResourceDeltaVisitor visitor = new ResourceDeltaVisitor(savedStateProgress, 2);
                                savedStateDelta.accept((IResourceDeltaVisitor)visitor);
                                visitor.processBatchedResourceEvents();
                            }
                            catch (CoreException e) {
                                fullReindexNeeded = true;
                                Logger.logException(String.valueOf(this.fName) + ": Could not process saved state. " + "Forced to do a full workspace re-index.", e);
                            }
                        } else {
                            fullReindexNeeded = true;
                        }
                    } else if (DEBUG_LIFECYCLE && DEBUG) {
                        Logger.log(201, "Fully reindexing for " + this.getClass().getName());
                    }
                    progress.worked(1);
                    if (fullReindexNeeded) {
                        this.fWorkspaceVisitorJob = new ResourceVisitorJob();
                        this.fWorkspaceVisitorJob.schedule();
                    }
                    this.fState = 1;
                }
            }
            finally {
                this.fStarting = false;
                progress.done();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() throws InterruptedException {
        Object object = this.fStartStopLock;
        synchronized (object) {
            if (this.fState != 0) {
                this.fResourceChangeListener.stop();
                boolean forceFullReIndexNextStart = false;
                if (this.fWorkspaceVisitorJob != null && this.fWorkspaceVisitorJob.getState() != 0) {
                    this.fWorkspaceVisitorJob.cancel();
                    this.forceFullReIndexNextStart();
                    forceFullReIndexNextStart = true;
                }
                boolean bl = forceFullReIndexNextStart = !this.fResourceEventProcessingJob.stop(!forceFullReIndexNextStart);
                if (forceFullReIndexNextStart) {
                    this.forceFullReIndexNextStart();
                }
                this.doStop();
                this.fState = 0;
            }
        }
    }

    protected void doStop() {
    }

    protected String getName() {
        return this.fName;
    }

    public final boolean waitForConsistent(IProgressMonitor monitor) {
        SubMonitor workspaceVisitorProgress;
        boolean success = true;
        boolean interupted = false;
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        int remainingWork = 4;
        progress.beginTask(NLS.bind((String)SSECoreMessages.IndexManager_Waiting_for_0, (Object)this.fName), remainingWork);
        if (this.fStarting && !monitor.isCanceled()) {
            SubMonitor startingProgress = progress.newChild(1);
            startingProgress.subTask(NLS.bind((String)SSECoreMessages.IndexManager_0_starting, (Object)this.fName));
            while (this.fStarting && !monitor.isCanceled()) {
                startingProgress.setWorkRemaining(100);
                startingProgress.newChild(1).worked(1);
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                    interupted = true;
                }
            }
        }
        progress.setWorkRemaining(--remainingWork);
        if (this.fWorkspaceVisitorJob != null && this.fWorkspaceVisitorJob.getState() != 0 && !monitor.isCanceled()) {
            workspaceVisitorProgress = progress.newChild(1);
            workspaceVisitorProgress.subTask(SSECoreMessages.IndexManager_Processing_entire_workspace_for_the_first_time);
            while (this.fWorkspaceVisitorJob.getState() != 0 && !monitor.isCanceled()) {
                workspaceVisitorProgress.setWorkRemaining(100);
                workspaceVisitorProgress.newChild(1).worked(1);
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException interruptedException) {
                    interupted = true;
                }
            }
        }
        progress.setWorkRemaining(--remainingWork);
        if (this.fResourceChangeListener.isProcessingEvents() && !monitor.isCanceled()) {
            workspaceVisitorProgress = progress.newChild(1);
            workspaceVisitorProgress.subTask(SSECoreMessages.IndexManager_processing_recent_resource_changes);
            while (this.fResourceChangeListener.isProcessingEvents() && !monitor.isCanceled()) {
                workspaceVisitorProgress.setWorkRemaining(100);
                workspaceVisitorProgress.newChild(1).worked(1);
                try {
                    this.fResourceChangeListener.waitForCurrentEvent(300);
                }
                catch (InterruptedException interruptedException) {
                    interupted = true;
                }
            }
        }
        progress.setWorkRemaining(--remainingWork);
        if (this.fResourceEventProcessingJob.getNumResourceEventsToProcess() != 0 && !monitor.isCanceled()) {
            SubMonitor indexingProgress = progress.newChild(1);
            int numResources = this.fResourceEventProcessingJob.getNumResourceEventsToProcess();
            while (numResources != 0 && !monitor.isCanceled()) {
                indexingProgress.subTask(NLS.bind((String)SSECoreMessages.IndexManager_0_Indexing_1_Files, (Object[])new Object[]{this.fName, "" + numResources}));
                indexingProgress.setWorkRemaining(numResources);
                int prevNumResources = numResources;
                numResources = this.fResourceEventProcessingJob.getNumResourceEventsToProcess();
                int numProcessed = prevNumResources - numResources;
                indexingProgress.worked(numProcessed > 0 ? numProcessed : 0);
                try {
                    this.fResourceEventProcessingJob.waitForConsistant(300);
                }
                catch (InterruptedException interruptedException) {
                    interupted = true;
                }
            }
        }
        progress.setWorkRemaining(--remainingWork);
        if (monitor.isCanceled()) {
            success = false;
        }
        if (interupted) {
            Thread.currentThread().interrupt();
        }
        progress.done();
        return success;
    }

    protected abstract boolean isResourceToIndex(int var1, IPath var2);

    protected abstract void performAction(byte var1, byte var2, IResource var3, IPath var4);

    protected abstract IPath getWorkingLocation();

    protected void forceFullReIndexNextStart() {
        IPath reIndexLocation = this.getWorkingLocation().append(RE_PROCESS_FILE_NAME);
        File file = reIndexLocation.toFile();
        try {
            file.createNewFile();
        }
        catch (IOException e) {
            Logger.logException(String.valueOf(this.fName) + ": Could not create file to tell manager to" + " do a full re-index on next load. " + LOG_ERROR_INDEX_INVALID, e);
        }
    }

    private boolean _isForcedFullReIndexNeeded() {
        boolean forcedFullReIndexNeeded = false;
        IPath reindexLocation = this.getWorkingLocation().append(RE_PROCESS_FILE_NAME);
        File file = reindexLocation.toFile();
        if (file.exists()) {
            forcedFullReIndexNeeded = true;
            file.delete();
        }
        return forcedFullReIndexNeeded;
    }

    protected boolean isFullReIndexNeeded() {
        return this._isForcedFullReIndexNeeded();
    }

    private class ResourceChangeListener
    implements IResourceChangeListener {
        private volatile int fEventsBeingProcessed = 0;
        private final Object fEventsBeingProcessedLock = new Object();
        private volatile byte fState = 0;

        protected ResourceChangeListener() {
        }

        protected void start() {
            this.fState = 1;
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        }

        protected void stop() throws InterruptedException {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
            this.waitForCurrentEvent(0);
            this.fState = 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void waitForCurrentEvent(int timeout) throws InterruptedException {
            Object object = this.fEventsBeingProcessedLock;
            synchronized (object) {
                if (this.fEventsBeingProcessed != 0) {
                    this.fEventsBeingProcessedLock.wait(timeout);
                }
            }
        }

        protected boolean isProcessingEvents() {
            return this.fEventsBeingProcessed != 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resourceChanged(IResourceChangeEvent event) {
            block21: {
                try {
                    Object object = this.fEventsBeingProcessedLock;
                    synchronized (object) {
                        ++this.fEventsBeingProcessed;
                    }
                    if (this.fState == 1) {
                        switch (event.getType()) {
                            case 2: 
                            case 4: {
                                AbstractIndexManager.this.fResourceEventProcessingJob.pause();
                                break;
                            }
                            case 1: 
                            case 16: {
                                AbstractIndexManager.this.fResourceEventProcessingJob.unPause();
                                IResourceDelta delta = event.getDelta();
                                if (delta == null || !delta.getFullPath().toString().equals("/")) break block21;
                                try {
                                    ResourceDeltaVisitor visitor = new ResourceDeltaVisitor(0);
                                    delta.accept((IResourceDeltaVisitor)visitor, false);
                                    visitor.processBatchedResourceEvents();
                                    break;
                                }
                                catch (CoreException e) {
                                    Logger.logException(String.valueOf(AbstractIndexManager.this.fName) + ": Failed visiting resource change delta. " + AbstractIndexManager.LOG_ERROR_INDEX_INVALID, e);
                                }
                            }
                            default: {
                                break;
                            }
                        }
                        break block21;
                    }
                    Logger.log(4, "A resource change event came in after " + AbstractIndexManager.this.fName + " shut down. This should never " + "ever happen, but if it does the index may now be inconsistant.");
                }
                catch (Throwable throwable) {
                    Object object = this.fEventsBeingProcessedLock;
                    synchronized (object) {
                        --this.fEventsBeingProcessed;
                        if (this.fEventsBeingProcessed == 0) {
                            this.fEventsBeingProcessedLock.notifyAll();
                        }
                    }
                    throw throwable;
                }
            }
            Object object = this.fEventsBeingProcessedLock;
            synchronized (object) {
                --this.fEventsBeingProcessed;
                if (this.fEventsBeingProcessed == 0) {
                    this.fEventsBeingProcessedLock.notifyAll();
                }
            }
        }
    }

    private class ResourceDeltaVisitor
    implements IResourceDeltaVisitor {
        private SubMonitor fProgress;
        private byte fSource;
        private int fPredictedWorkRemaining;
        private Map<IResource, ResourceEvent> fBatchedResourceEvents;

        protected ResourceDeltaVisitor(byte source) {
            this(SubMonitor.convert(null), source);
        }

        protected ResourceDeltaVisitor(SubMonitor progress, byte source) {
            this.fProgress = progress;
            this.fSource = source;
            this.fBatchedResourceEvents = new LinkedHashMap<IResource, ResourceEvent>(100);
            this.fPredictedWorkRemaining = 1;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            this.fProgress.subTask(NLS.bind((String)SSECoreMessages.IndexManager_0_resources_to_go_1, (Object[])new Object[]{"" + this.fPredictedWorkRemaining, delta.getFullPath().toString()}));
            boolean visitChildren = false;
            if (delta.getResource().isDerived()) {
                visitChildren = false;
            } else if (delta.getFullPath().isRoot()) {
                visitChildren = true;
            } else {
                IResource resource = delta.getResource();
                if (AbstractIndexManager.this.isResourceToIndex(resource.getType(), resource.getFullPath())) {
                    if (resource.getType() == 1) {
                        switch (delta.getKind()) {
                            case 4: {
                                if ((delta.getFlags() & 0x100) == 0 && (delta.getFlags() & 0x40000) == 0 && (delta.getFlags() & 0x8000) == 0 && (delta.getFlags() & 0x1000) == 0) break;
                            }
                            case 1: {
                                if ((delta.getFlags() & 0x1000) != 0) {
                                    this.fBatchedResourceEvents.put(resource, new ResourceEvent(this.fSource, 2, delta.getMovedFromPath()));
                                    break;
                                }
                                this.fBatchedResourceEvents.put(resource, new ResourceEvent(this.fSource, 0, null));
                                break;
                            }
                            case 2: {
                                if ((delta.getFlags() & 0x2000) != 0) {
                                    this.fBatchedResourceEvents.put(resource, new ResourceEvent(this.fSource, 3, delta.getMovedToPath()));
                                    break;
                                }
                                this.fBatchedResourceEvents.put(resource, new ResourceEvent(this.fSource, 1, null));
                            }
                        }
                    } else if (resource.getType() == 4 && (delta.getFlags() & 0x4000) != 0 && ((IProject)resource).isOpen()) {
                        if (DEBUG_LIFECYCLE && DEBUG) {
                            Logger.log(201, "Indexing project " + resource.getName() + " for " + AbstractIndexManager.this.getName());
                        }
                        new ResourceVisitorJob(delta.getResource()).schedule();
                    }
                    visitChildren = true;
                } else {
                    visitChildren = false;
                }
                if (visitChildren) {
                    this.fPredictedWorkRemaining += delta.getAffectedChildren().length;
                }
                this.fProgress.setWorkRemaining(this.fPredictedWorkRemaining);
                this.fProgress.worked(1);
                --this.fPredictedWorkRemaining;
                if (this.fBatchedResourceEvents.size() >= 100) {
                    this.processBatchedResourceEvents();
                }
            }
            return visitChildren;
        }

        protected void processBatchedResourceEvents() {
            AbstractIndexManager.this.fResourceEventProcessingJob.addResourceEvents(this.fBatchedResourceEvents);
            this.fBatchedResourceEvents.clear();
        }
    }

    private static class ResourceEvent {
        protected byte fSource;
        protected byte fAction;
        protected IPath fMovePath;

        protected ResourceEvent(byte source, byte action, IPath movePath) {
            this.fSource = source;
            this.fAction = action;
            this.fMovePath = movePath;
        }
    }

    private class ResourceEventProcessingJob
    extends Job {
        private static final int DELAY = 500;
        private static final String PRESERVED_RESOURCE_EVENTS_TO_PROCESS_FILE_NAME = ".preservedResourceEvents";
        private static final long serialVersionUID = 2L;
        private volatile boolean fIsPaused;
        private Map<IResource, ResourceEvent> fResourceEvents;
        private final Object fResourceEventsLock;
        private final Object fToNotifyLock;

        protected ResourceEventProcessingJob() {
            super(NLS.bind((String)SSECoreMessages.IndexManager_0_Processing_resource_events, (Object)AbstractIndexManager.this.fName));
            this.fResourceEventsLock = new Object();
            this.fToNotifyLock = new Object();
            this.setUser(false);
            this.setSystem(true);
            this.setPriority(30);
            this.fIsPaused = false;
            this.fResourceEvents = new LinkedHashMap<IResource, ResourceEvent>();
        }

        protected synchronized boolean start(boolean loadPreservedResourceEvents, SubMonitor progress) {
            boolean successLoadingPreserved = false;
            if (loadPreservedResourceEvents) {
                successLoadingPreserved = this.loadPreservedReceivedResourceEvents(progress);
            } else {
                File preservedResourceEventsFile = this.getPreservedResourceEventsFile();
                preservedResourceEventsFile.delete();
            }
            this.schedule();
            return successLoadingPreserved;
        }

        protected synchronized boolean stop(boolean preserveResourceEvents) throws InterruptedException {
            this.cancel();
            this.join();
            boolean success = true;
            if (preserveResourceEvents && this.hasResourceEventsToProcess()) {
                success = this.preserveReceivedResourceEvents();
            } else {
                this.getPreservedResourceEventsFile().delete();
            }
            return success;
        }

        protected synchronized boolean isProcessing() {
            return this.getState() != 0 || this.fIsPaused;
        }

        protected synchronized void unPause() {
            this.fIsPaused = false;
            if (this.getState() == 1) {
                this.wakeUp(500L);
            } else {
                this.schedule(500L);
            }
        }

        protected synchronized void pause() {
            this.fIsPaused = true;
            this.sleep();
        }

        protected void addResourceEvents(Map<IResource, ResourceEvent> resourceEvents) {
            for (Map.Entry<IResource, ResourceEvent> entry : resourceEvents.entrySet()) {
                IResource resource = entry.getKey();
                ResourceEvent resourceEvent = entry.getValue();
                this.addResourceEvent(resource, resourceEvent);
            }
            if (!this.isProcessing()) {
                this.unPause();
            }
        }

        protected int getNumResourceEventsToProcess() {
            return this.fResourceEvents.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void waitForConsistant(int timeout) throws InterruptedException {
            if (this.hasResourceEventsToProcess() || this.isProcessing()) {
                Object object = this.fToNotifyLock;
                synchronized (object) {
                    this.fToNotifyLock.wait(timeout);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            try {
                SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
                while (!this.fIsPaused && !monitor.isCanceled() && this.hasResourceEventsToProcess()) {
                    progress.setTaskName(NLS.bind((String)SSECoreMessages.IndexManager_0_Indexing_1_Files, (Object[])new Object[]{AbstractIndexManager.this.fName, "" + this.getNumResourceEventsToProcess()}));
                    progress.setWorkRemaining(this.getNumResourceEventsToProcess());
                    ResourceEvent resourceEvent = null;
                    IResource resource = null;
                    Object object = this.fResourceEventsLock;
                    synchronized (object) {
                        resource = this.fResourceEvents.keySet().iterator().next();
                        resourceEvent = this.fResourceEvents.remove(resource);
                    }
                    monitor.subTask(resource.getName());
                    final byte source = resourceEvent.fSource;
                    final byte action = resourceEvent.fAction;
                    final IResource finResource = resource;
                    final IPath movePath = resourceEvent.fMovePath;
                    SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                        public void run() throws Exception {
                            AbstractIndexManager.this.performAction(source, action, finResource, movePath);
                        }

                        public void handleException(Throwable e) {
                            Logger.logException("Error while performing an update to the index. Index may become invalid, incomplete, or enter some other inconsistent state.", e);
                        }
                    });
                    progress.worked(1);
                    Job.getJobManager().currentJob().yieldRule(monitor);
                }
                monitor.done();
            }
            finally {
                this.notifyIfConsistant();
            }
            IStatus exitStatus = monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
            return exitStatus;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addResourceEvent(IResource resource, ResourceEvent resourceEvent) {
            Object object = this.fResourceEventsLock;
            synchronized (object) {
                if (!this.fResourceEvents.containsKey(resource)) {
                    this.fResourceEvents.put(resource, resourceEvent);
                } else if (resourceEvent.fSource == 0) {
                    this.fResourceEvents.get((Object)resource).fAction = resourceEvent.fAction;
                }
            }
        }

        private boolean hasResourceEventsToProcess() {
            return !this.fResourceEvents.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean preserveReceivedResourceEvents() {
            File preservedResourceEventsFile = this.getPreservedResourceEventsFile();
            boolean success = true;
            Object object = this.fResourceEventsLock;
            synchronized (object) {
                block23: {
                    FilterOutputStream dos = null;
                    try {
                        if (preservedResourceEventsFile.exists()) {
                            preservedResourceEventsFile.delete();
                            preservedResourceEventsFile.createNewFile();
                        }
                        FileOutputStream fos = new FileOutputStream(preservedResourceEventsFile);
                        BufferedOutputStream bos = new BufferedOutputStream(fos);
                        dos = new DataOutputStream(bos);
                        ((DataOutputStream)dos).writeLong(2L);
                        ((DataOutputStream)dos).writeInt(this.getNumResourceEventsToProcess());
                        for (Map.Entry<IResource, ResourceEvent> entry : this.fResourceEvents.entrySet()) {
                            IResource resource = entry.getKey();
                            ResourceEvent resourceEvent = entry.getValue();
                            if (resourceEvent.fSource == 1) continue;
                            ((DataOutputStream)dos).writeByte(resourceEvent.fAction);
                            ((DataOutputStream)dos).writeByte(resource.getType());
                            byte[] pathBytes = resource.getFullPath().toString().getBytes(AbstractIndexManager.ENCODING_UTF16);
                            ((DataOutputStream)dos).writeInt(pathBytes.length);
                            dos.write(pathBytes);
                            pathBytes = resourceEvent.fMovePath != null ? resourceEvent.fMovePath.toPortableString().getBytes(AbstractIndexManager.ENCODING_UTF16) : new byte[]{};
                            ((DataOutputStream)dos).writeInt(pathBytes.length);
                            if (pathBytes.length <= 0) continue;
                            dos.write(pathBytes);
                        }
                        this.fResourceEvents.clear();
                        ((DataOutputStream)dos).flush();
                    }
                    catch (FileNotFoundException e) {
                        Logger.logException(String.valueOf(AbstractIndexManager.this.fName) + ": Exception while opening file to preserve resources to index.", e);
                        success = false;
                        if (dos != null) {
                            try {
                                dos.close();
                            }
                            catch (IOException e2) {
                                Logger.logException(String.valueOf(AbstractIndexManager.this.fName) + ": Exception while closing file with preserved resources to index.", e2);
                                success = false;
                            }
                        }
                        break block23;
                    }
                    catch (IOException e) {
                        try {
                            Logger.logException(String.valueOf(AbstractIndexManager.this.fName) + ": Exception while writing to file to preserve resources to index.", e);
                            success = false;
                            break block23;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                        finally {
                            if (dos != null) {
                                try {
                                    dos.close();
                                }
                                catch (IOException e3) {
                                    Logger.logException(String.valueOf(AbstractIndexManager.this.fName) + ": Exception while closing file with preserved resources to index.", e3);
                                    success = false;
                                }
                            }
                        }
                    }
                    if (dos == null) break block23;
                    try {
                        dos.close();
                    }
                    catch (IOException e) {
                        Logger.logException(String.valueOf(AbstractIndexManager.this.fName) + ": Exception while closing file with preserved resources to index.", e);
                        success = false;
                    }
                }
                if (!success) {
                    preservedResourceEventsFile.delete();
                }
            }
            return success;
        }

        /*
         * Exception decompiling
         */
        private boolean loadPreservedReceivedResourceEvents(SubMonitor progress) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [15[CATCHBLOCK]], but top level block is 13[CATCHBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private String readStringFromStream(DataInputStream dis) throws IOException {
            int length = dis.readInt();
            byte[] resourceLocation = new byte[length];
            int read = 0;
            int offset = 0;
            while (offset < resourceLocation.length && (read = dis.read(resourceLocation, offset, resourceLocation.length - offset)) > 0) {
                offset += read;
            }
            return new String(resourceLocation, AbstractIndexManager.ENCODING_UTF16);
        }

        private File getPreservedResourceEventsFile() {
            IPath preservedResourcesToIndexLocation = AbstractIndexManager.this.getWorkingLocation().append(PRESERVED_RESOURCE_EVENTS_TO_PROCESS_FILE_NAME);
            return preservedResourcesToIndexLocation.toFile();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyIfConsistant() {
            if (!this.hasResourceEventsToProcess()) {
                Object object = this.fToNotifyLock;
                synchronized (object) {
                    this.fToNotifyLock.notifyAll();
                }
            }
        }
    }

    private class ResourceVisitor
    implements IResourceProxyVisitor {
        private SubMonitor fProgress;
        private Map<IResource, ResourceEvent> fBatchedResourceEvents;

        protected ResourceVisitor(IProgressMonitor monitor) {
            this.fProgress = SubMonitor.convert((IProgressMonitor)monitor);
            this.fBatchedResourceEvents = new LinkedHashMap<IResource, ResourceEvent>(100);
        }

        public boolean visit(IResourceProxy proxy) throws CoreException {
            this.fProgress.subTask(proxy.getName());
            boolean visitChildren = false;
            if (!this.fProgress.isCanceled()) {
                if (proxy.isDerived()) {
                    visitChildren = false;
                } else if (proxy.requestFullPath().isRoot()) {
                    visitChildren = true;
                } else if (AbstractIndexManager.this.isResourceToIndex(proxy.getType(), proxy.requestFullPath())) {
                    if (proxy.getType() == 1 && proxy.isAccessible()) {
                        IFile file = (IFile)proxy.requestResource();
                        this.fBatchedResourceEvents.put((IResource)file, new ResourceEvent(1, 0, null));
                    }
                    visitChildren = true;
                }
            }
            if (this.fBatchedResourceEvents.size() >= 100) {
                this.processBatchedResourceEvents();
            }
            return visitChildren;
        }

        protected void processBatchedResourceEvents() {
            AbstractIndexManager.this.fResourceEventProcessingJob.addResourceEvents(this.fBatchedResourceEvents);
            this.fBatchedResourceEvents.clear();
        }
    }

    private class ResourceVisitorJob
    extends Job {
        IResource fTarget;

        ResourceVisitorJob(IResource target) {
            this();
            this.fTarget = target;
        }

        protected ResourceVisitorJob() {
            super(NLS.bind((String)SSECoreMessages.IndexManager_0_Processing_entire_workspace_for_the_first_time, (Object)AbstractIndexManager.this.fName));
            this.fTarget = null;
            this.setUser(false);
            this.setSystem(true);
            this.setPriority(30);
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                monitor.beginTask(NLS.bind((String)SSECoreMessages.IndexManager_Indexing01, (Object)AbstractIndexManager.this.fName, (Object)(this.fTarget != null ? this.fTarget.getFullPath().makeRelative().toString() : "entire workspace")), -1);
                ResourceVisitor visitor = new ResourceVisitor(monitor);
                if (this.fTarget != null) {
                    this.fTarget.accept((IResourceProxyVisitor)visitor, 0);
                } else {
                    ResourcesPlugin.getWorkspace().getRoot().accept((IResourceProxyVisitor)visitor, 0);
                }
                visitor.processBatchedResourceEvents();
            }
            catch (CoreException e) {
                Logger.logException(String.valueOf(AbstractIndexManager.this.fName) + ": Failed visiting " + (this.fTarget != null ? this.fTarget.getFullPath() : "entire workspace") + " for initial index. " + AbstractIndexManager.LOG_ERROR_INDEX_INVALID, e);
            }
            IStatus status = monitor.isCanceled() ? Status.CANCEL_STATUS : Status.OK_STATUS;
            monitor.done();
            return status;
        }
    }
}

