/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.reviews.ui.compare;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterators;
import java.util.stream.StreamSupport;
import org.eclipse.compare.contentmergeviewer.TextMergeViewer;
import org.eclipse.compare.internal.MergeSourceViewer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextInputListener;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.LineRange;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.projection.AnnotationBag;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.internal.reviews.ui.ReviewsUiPlugin;
import org.eclipse.mylyn.internal.reviews.ui.annotations.CommentAnnotation;
import org.eclipse.mylyn.internal.reviews.ui.annotations.CommentAnnotationHoverInput;
import org.eclipse.mylyn.internal.reviews.ui.annotations.CommentPopupDialog;
import org.eclipse.mylyn.internal.reviews.ui.annotations.ReviewAnnotationModel;
import org.eclipse.mylyn.internal.reviews.ui.compare.CompareUtil;
import org.eclipse.mylyn.internal.reviews.ui.compare.Direction;
import org.eclipse.mylyn.internal.reviews.ui.compare.ReviewCompareInputListener;
import org.eclipse.mylyn.internal.reviews.ui.compare.ReviewItemSetCompareEditorInput;
import org.eclipse.mylyn.reviews.core.model.IComment;
import org.eclipse.mylyn.reviews.core.model.IFileItem;
import org.eclipse.mylyn.reviews.core.model.IReviewItem;
import org.eclipse.mylyn.reviews.ui.ReviewBehavior;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class ReviewCompareAnnotationSupport {
    private static String KEY_ANNOTAION_SUPPORT = ReviewItemSetCompareEditorInput.class.getName();
    private CommentPopupDialog commentPopupDialog = null;
    MonitorObject myMonitorObject = new MonitorObject();
    private ReviewBehavior behavior;
    private final ReviewAnnotationModel leftAnnotationModel = new ReviewAnnotationModel();
    private ReviewCompareInputListener leftViewerListener;
    private final ReviewAnnotationModel rightAnnotationModel = new ReviewAnnotationModel();
    private ReviewCompareInputListener rightViewerListener;
    private MergeSourceViewer leftSourceViewer;
    private MergeSourceViewer rightSourceViewer;

    public static ReviewCompareAnnotationSupport getAnnotationSupport(Viewer contentViewer) {
        ReviewCompareAnnotationSupport support = (ReviewCompareAnnotationSupport)contentViewer.getData(KEY_ANNOTAION_SUPPORT);
        if (support == null) {
            support = new ReviewCompareAnnotationSupport(contentViewer);
            contentViewer.setData(KEY_ANNOTAION_SUPPORT, (Object)support);
        }
        return support;
    }

    public ReviewCompareAnnotationSupport(Viewer contentViewer) {
        this.install(contentViewer);
        contentViewer.setData(KEY_ANNOTAION_SUPPORT, (Object)this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ReviewCompareAnnotationSupport other = (ReviewCompareAnnotationSupport)obj;
        if (!Objects.equals(this.leftAnnotationModel, other.leftAnnotationModel)) {
            return false;
        }
        return Objects.equals(this.rightAnnotationModel, other.rightAnnotationModel);
    }

    public ReviewBehavior getBehavior() {
        return this.behavior;
    }

    public int hashCode() {
        return Objects.hash(this.leftAnnotationModel, this.rightAnnotationModel);
    }

    public void install(Viewer contentViewer) {
        if (contentViewer instanceof TextMergeViewer) {
            TextMergeViewer textMergeViewer = (TextMergeViewer)contentViewer;
            try {
                Class<TextMergeViewer> clazz = TextMergeViewer.class;
                Field declaredField = clazz.getDeclaredField("fLeft");
                declaredField.setAccessible(true);
                this.leftSourceViewer = (MergeSourceViewer)declaredField.get(textMergeViewer);
                declaredField = clazz.getDeclaredField("fRight");
                declaredField.setAccessible(true);
                this.rightSourceViewer = (MergeSourceViewer)declaredField.get(textMergeViewer);
                this.leftViewerListener = this.registerInputListener(this.leftSourceViewer, this.leftAnnotationModel);
                this.rightViewerListener = this.registerInputListener(this.rightSourceViewer, this.rightAnnotationModel);
            }
            catch (Throwable t) {
                StatusHandler.log((IStatus)new Status(2, "org.eclipse.mylyn.reviews.ui", "Could not initialize annotation model for " + Viewer.class.getName(), t));
            }
        }
    }

    public boolean hasAnnotation(Direction direction) {
        Position rightPosition = new Position(0, 0);
        return this.findAnnotation(this.rightSourceViewer, direction, rightPosition, this.rightAnnotationModel) != null;
    }

    public Annotation gotoAnnotation(Direction direction) {
        if (this.leftSourceViewer == null) {
            return null;
        }
        int currentLeftOffset = this.getSelection(this.leftSourceViewer).getOffset();
        Position nextLeftPosition = new Position(0, 0);
        Annotation leftAnnotation = this.findAnnotation(this.leftSourceViewer, direction, nextLeftPosition, this.leftAnnotationModel);
        Position nextRightPosition = new Position(0, 0);
        Annotation rightAnnotation = this.findAnnotation(this.rightSourceViewer, direction, nextRightPosition, this.rightAnnotationModel);
        if (leftAnnotation == null && rightAnnotation != null) {
            this.selectAndReveal(this.rightSourceViewer, nextRightPosition);
            return rightAnnotation;
        }
        if (leftAnnotation != null && rightAnnotation == null) {
            this.selectAndReveal(this.leftSourceViewer, nextLeftPosition);
            return leftAnnotation;
        }
        if (leftAnnotation != null && rightAnnotation != null) {
            nextLeftPosition.offset = this.getLineOffset(this.leftAnnotationModel, nextLeftPosition.offset);
            nextLeftPosition.length = 1;
            nextRightPosition.offset = this.getLineOffset(this.rightAnnotationModel, nextRightPosition.offset);
            nextRightPosition.length = 1;
            if (this.calculateNextAnnotation(direction, nextLeftPosition, nextRightPosition, currentLeftOffset = this.getLineOffset(this.leftAnnotationModel, currentLeftOffset)) == Side.LEFT_SIDE) {
                return leftAnnotation;
            }
            return rightAnnotation;
        }
        return null;
    }

    public void gotoAnnotationWithComment(IComment comment) {
        CommentAnnotation rightAnnotation = this.findComment(this.rightAnnotationModel, comment);
        if (rightAnnotation != null) {
            this.selectAndReveal(this.rightSourceViewer, rightAnnotation.getPosition());
        } else {
            CommentAnnotation leftAnnotation = this.findComment(this.leftAnnotationModel, comment);
            if (leftAnnotation != null) {
                this.selectAndReveal(this.leftSourceViewer, leftAnnotation.getPosition());
            }
        }
    }

    private CommentAnnotation findComment(ReviewAnnotationModel annotationModel, IComment comment) {
        Optional<Annotation> annotation = StreamSupport.stream(Spliterators.spliteratorUnknownSize(annotationModel.getAnnotationIterator(), 16), false).filter(CommentAnnotation.class::isInstance).filter(c -> ((CommentAnnotation)((Object)c)).getComment().getId().equals(comment.getId())).findFirst();
        if (annotation.isPresent()) {
            return (CommentAnnotation)annotation.get();
        }
        return null;
    }

    private int getLineOffset(ReviewAnnotationModel annotationModel, int offset) {
        try {
            int line = annotationModel.getDocument().getLineOfOffset(offset);
            return annotationModel.getDocument().getLineOffset(line);
        }
        catch (BadLocationException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.reviews.ui", "Error displaying comment", (Throwable)e));
            return 0;
        }
    }

    public Side calculateNextAnnotation(Direction direction, Position nextLeftPosition, Position nextRightPosition, Integer currentLeftOffset) {
        if (direction == Direction.FORWARDS) {
            if (nextLeftPosition.offset == nextRightPosition.offset) {
                this.moveToAnnotation(this.rightSourceViewer, this.leftSourceViewer, nextLeftPosition);
                this.rightSourceViewer.getSourceViewer().revealRange(nextLeftPosition.offset - 1, nextLeftPosition.length - 1);
                this.rightSourceViewer.getSourceViewer().setSelectedRange(nextLeftPosition.offset - 1, nextLeftPosition.length - 1);
                return Side.LEFT_SIDE;
            }
            if (nextLeftPosition.offset < currentLeftOffset && nextRightPosition.offset < currentLeftOffset || nextLeftPosition.offset > currentLeftOffset && nextRightPosition.offset > currentLeftOffset) {
                if (nextLeftPosition.offset < nextRightPosition.offset) {
                    return this.moveToLeftAnnotation(nextLeftPosition);
                }
                return this.moveToRightAnnotation(nextRightPosition);
            }
            if (nextLeftPosition.offset < currentLeftOffset && nextRightPosition.offset > currentLeftOffset) {
                return this.moveToRightAnnotation(nextRightPosition);
            }
            if (nextLeftPosition.offset > currentLeftOffset && nextRightPosition.offset < currentLeftOffset) {
                return this.moveToLeftAnnotation(nextLeftPosition);
            }
            if (nextRightPosition.offset == currentLeftOffset) {
                return this.moveToLeftAnnotation(nextLeftPosition);
            }
            return this.moveToRightAnnotation(nextRightPosition);
        }
        if (nextLeftPosition.offset == nextRightPosition.offset) {
            this.moveToAnnotation(this.leftSourceViewer, this.rightSourceViewer, nextRightPosition);
            Position position = this.getNextLine(nextRightPosition.offset);
            this.leftSourceViewer.getSourceViewer().revealRange(position.offset, position.length);
            this.leftSourceViewer.getSourceViewer().setSelectedRange(position.offset, position.length);
            return Side.RIGHT_SIDE;
        }
        if (nextLeftPosition.offset > currentLeftOffset && nextRightPosition.offset > currentLeftOffset || nextLeftPosition.offset < currentLeftOffset && nextRightPosition.offset < currentLeftOffset) {
            if (nextLeftPosition.offset > nextRightPosition.offset) {
                return this.moveToLeftAnnotation(nextLeftPosition);
            }
            return this.moveToRightAnnotation(nextRightPosition);
        }
        if (nextLeftPosition.offset > currentLeftOffset && nextRightPosition.offset < currentLeftOffset) {
            return this.moveToRightAnnotation(nextRightPosition);
        }
        if (nextLeftPosition.offset < currentLeftOffset && nextRightPosition.offset > currentLeftOffset) {
            return this.moveToLeftAnnotation(nextLeftPosition);
        }
        if (nextRightPosition.offset == currentLeftOffset) {
            return this.moveToLeftAnnotation(nextLeftPosition);
        }
        return this.moveToRightAnnotation(nextRightPosition);
    }

    private Position getNextLine(int offset) {
        Position position = new Position(0, 0);
        try {
            int line = this.rightAnnotationModel.getDocument().getLineOfOffset(offset);
            IRegion region = this.rightAnnotationModel.getDocument().getLineInformation(line + 1);
            position.offset = region.getOffset();
            position.length = region.getLength();
        }
        catch (BadLocationException e) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.reviews.ui", "Error displaying comment", (Throwable)e));
        }
        return position;
    }

    private Side moveToLeftAnnotation(Position nextLeftPosition) {
        this.moveToAnnotation(this.rightSourceViewer, this.leftSourceViewer, nextLeftPosition);
        return Side.LEFT_SIDE;
    }

    private Side moveToRightAnnotation(Position nextRightPosition) {
        this.moveToAnnotation(this.leftSourceViewer, this.rightSourceViewer, nextRightPosition);
        return Side.RIGHT_SIDE;
    }

    public void moveToAnnotation(MergeSourceViewer adjacentViewer, MergeSourceViewer annotationViewer, Position position) {
        adjacentViewer.getSourceViewer().revealRange(position.offset, position.length);
        adjacentViewer.getSourceViewer().setSelectedRange(position.offset, position.length);
        this.selectAndReveal(annotationViewer, position);
    }

    private void selectAndReveal(MergeSourceViewer sourceViewer, Position position) {
        StyledText widget = sourceViewer.getSourceViewer().getTextWidget();
        widget.setRedraw(false);
        this.adjustHighlightRange(sourceViewer.getSourceViewer(), position.offset, position.length);
        sourceViewer.getSourceViewer().revealRange(position.offset, position.length);
        sourceViewer.getSourceViewer().setSelectedRange(position.offset, position.length);
        SourceViewer srcViewer = sourceViewer.getSourceViewer();
        IReviewItem reviewitem = ((ReviewAnnotationModel)srcViewer.getAnnotationModel()).getItem();
        List<CommentAnnotation> comments = this.getAnnotationsForLine(srcViewer, position.offset);
        Point p = sourceViewer.getLineRange(position, sourceViewer.getSourceViewer().getSelectedRange());
        LineRange range = new LineRange(p.x + 1, p.y);
        if (this.commentPopupDialog != null) {
            this.commentPopupDialog.dispose(false);
            this.commentPopupDialog = null;
        }
        this.commentPopupDialog = new CommentPopupDialog(ReviewsUiPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getShell(), 540672, reviewitem, range, true);
        CommentAnnotationHoverInput input = new CommentAnnotationHoverInput(comments, ((ReviewAnnotationModel)srcViewer.getAnnotationModel()).getBehavior());
        this.commentPopupDialog.create();
        this.commentPopupDialog.setInput(input);
        this.commentPopupDialog.setHeightBasedOnMouse(sourceViewer.getSourceViewer().getControl().toDisplay((int)0, (int)0).y);
        Point location = sourceViewer.getSourceViewer().getControl().toDisplay(sourceViewer.getSourceViewer().getControl().getSize().x, sourceViewer.getViewportHeight() / 3);
        this.commentPopupDialog.setLocation(location);
        this.commentPopupDialog.open();
        this.commentPopupDialog.setFocus();
        widget.setRedraw(true);
    }

    private List<CommentAnnotation> getAnnotationsForLine(SourceViewer viewer, int offset) {
        IAnnotationModel model = viewer.getAnnotationModel();
        if (model == null) {
            return Collections.emptyList();
        }
        IDocument document = viewer.getDocument();
        int line = 0;
        try {
            line = document.getLineOfOffset(offset);
        }
        catch (BadLocationException e1) {
            StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.reviews.ui", "Error fetching line", (Throwable)e1));
        }
        ArrayList<CommentAnnotation> commentAnnotations = new ArrayList<CommentAnnotation>();
        Iterator it = model.getAnnotationIterator();
        while (it.hasNext()) {
            Annotation annotation2 = (Annotation)it.next();
            Position position = model.getPosition(annotation2);
            if (position == null || !this.isPositionOnLine(position, line, document)) continue;
            if (annotation2 instanceof AnnotationBag) {
                AnnotationBag bag = (AnnotationBag)annotation2;
                for (Annotation annotation2 : bag) {
                    position = model.getPosition(annotation2);
                    if (position == null || !this.includeAnnotation(annotation2, position, commentAnnotations)) continue;
                    commentAnnotations.add((CommentAnnotation)annotation2);
                }
                continue;
            }
            if (!this.includeAnnotation(annotation2, position, commentAnnotations)) continue;
            commentAnnotations.add((CommentAnnotation)annotation2);
        }
        return commentAnnotations;
    }

    private boolean includeAnnotation(Annotation annotation, Position position, List<CommentAnnotation> annotations) {
        return annotation instanceof CommentAnnotation && !annotations.contains(annotation);
    }

    private boolean isPositionOnLine(Position position, int line, IDocument document) {
        if (position.getOffset() > -1 && position.getLength() > -1) {
            try {
                return line == document.getLineOfOffset(position.getOffset());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return false;
    }

    protected void adjustHighlightRange(SourceViewer sourceViewer, int offset, int length) {
        if (sourceViewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)sourceViewer;
            extension.exposeModelRange((IRegion)new Region(offset, length));
        } else if (!this.isVisible(sourceViewer, offset, length)) {
            sourceViewer.resetVisibleRegion();
        }
    }

    private boolean isVisible(SourceViewer viewer, int offset, int length) {
        if (viewer instanceof ITextViewerExtension5) {
            ITextViewerExtension5 extension = (ITextViewerExtension5)viewer;
            IRegion overlap = extension.modelRange2WidgetRange((IRegion)new Region(offset, length));
            return overlap != null;
        }
        return viewer.overlapsWithVisibleRegion(offset, length);
    }

    public void setReviewItem(IFileItem item, ReviewBehavior behavior) {
        this.leftAnnotationModel.setItem((IReviewItem)item.getBase(), behavior);
        this.rightAnnotationModel.setItem((IReviewItem)item.getTarget(), behavior);
        Display.getDefault().asyncExec(() -> {
            try {
                if (this.leftViewerListener != null) {
                    this.leftViewerListener.forceCustomAnnotationHover();
                }
                if (this.rightViewerListener != null) {
                    this.rightViewerListener.forceCustomAnnotationHover();
                }
            }
            catch (Exception e) {
                StatusHandler.log((IStatus)new Status(4, "org.eclipse.mylyn.reviews.ui", "Error attaching annotation hover", (Throwable)e));
            }
        });
    }

    private ReviewCompareInputListener registerInputListener(MergeSourceViewer sourceViewer, ReviewAnnotationModel annotationModel) {
        ReviewCompareInputListener listener = new ReviewCompareInputListener(sourceViewer, annotationModel);
        SourceViewer viewer = CompareUtil.getSourceViewer(sourceViewer);
        if (viewer != null) {
            viewer.addTextInputListener((ITextInputListener)listener);
        }
        listener.registerContextMenu();
        return listener;
    }

    protected Annotation findAnnotation(MergeSourceViewer viewer, Direction direction, Position annotationPosition, ReviewAnnotationModel annotationModel) {
        if (viewer == null) {
            return null;
        }
        ITextSelection selection = this.getSelection(viewer);
        int offset = selection.getOffset();
        int length = selection.getLength();
        Annotation nextAnnotation = null;
        Position nextAnnotationPosition = null;
        Annotation containingAnnotation = null;
        Position containingAnnotationPosition = null;
        boolean currentAnnotation = false;
        IDocument document = annotationModel.getDocument();
        if (document == null) {
            return null;
        }
        int endOfDocument = document.getLength();
        int distance = Integer.MAX_VALUE;
        Iterator<Annotation> e = annotationModel.getAnnotationIterator();
        while (e.hasNext()) {
            Position p;
            Annotation a = e.next();
            if (a instanceof CommentAnnotation) {
                CommentAnnotation c = (CommentAnnotation)a;
                v0 = c.getPosition();
            } else {
                v0 = p = null;
            }
            if (p == null) continue;
            if (direction == Direction.FORWARDS && p.offset == offset || direction == Direction.BACKWARDS && p.offset + p.getLength() == offset + length) {
                if (containingAnnotation != null && (direction != Direction.FORWARDS || p.length < containingAnnotationPosition.length) && (direction != Direction.BACKWARDS || p.length < containingAnnotationPosition.length)) continue;
                containingAnnotation = a;
                containingAnnotationPosition = p;
                currentAnnotation = p.length == length;
                continue;
            }
            int currentDistance = 0;
            if (direction == Direction.FORWARDS) {
                currentDistance = p.getOffset() - offset;
                if (currentDistance < 0) {
                    currentDistance = endOfDocument + currentDistance;
                }
                if (currentDistance >= distance && (currentDistance != distance || p.length >= nextAnnotationPosition.length)) continue;
                distance = currentDistance;
                nextAnnotation = a;
                nextAnnotationPosition = p;
                continue;
            }
            currentDistance = offset + length - (p.getOffset() + p.length);
            if (currentDistance < 0) {
                currentDistance = endOfDocument + currentDistance;
            }
            if (currentDistance >= distance && (currentDistance != distance || p.length >= nextAnnotationPosition.length)) continue;
            distance = currentDistance;
            nextAnnotation = a;
            nextAnnotationPosition = p;
        }
        if (!(containingAnnotationPosition == null || currentAnnotation && nextAnnotation != null)) {
            annotationPosition.setOffset(containingAnnotationPosition.getOffset());
            annotationPosition.setLength(containingAnnotationPosition.getLength());
            return containingAnnotation;
        }
        if (nextAnnotationPosition != null) {
            annotationPosition.setOffset(nextAnnotationPosition.getOffset());
            annotationPosition.setLength(nextAnnotationPosition.getLength());
        }
        return nextAnnotation;
    }

    private ITextSelection getSelection(MergeSourceViewer viewer) {
        return (ITextSelection)viewer.getSourceViewer().getSelectionProvider().getSelection();
    }

    public class MonitorObject {
    }

    public static enum Side {
        LEFT_SIDE,
        RIGHT_SIDE;

    }
}

