/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.buildconsole;

import org.eclipse.cdt.core.ProblemMarkerInfo;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsoleDocument;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsolePartition;
import org.eclipse.cdt.internal.ui.buildconsole.BuildConsolePartitioner;

class DocumentMarkerManager {
    BuildConsoleDocument fDocument;
    BuildConsolePartitioner fPartitioner;
    int highlightedPartitionIndex = -1;

    DocumentMarkerManager(BuildConsoleDocument document, BuildConsolePartitioner partitioner) {
        this.fDocument = document;
        this.fPartitioner = partitioner;
    }

    void moveToNextError() {
        if (this.fPartitioner.fPartitions.size() == 0) {
            return;
        }
        if (this.highlightedPartitionIndex == -1) {
            this.moveToFirstError();
            return;
        }
        int i = this.highlightedPartitionIndex + 1;
        do {
            String type;
            if (i == this.fPartitioner.fPartitions.size()) {
                i = 0;
            }
            if (!BuildConsolePartition.isProblemPartitionType(type = this.fPartitioner.fPartitions.get(i).getType())) continue;
            this.highlightedPartitionIndex = i;
            return;
        } while (this.highlightedPartitionIndex != ++i);
    }

    void moveToPreviousError() {
        if (this.fPartitioner.fPartitions.size() == 0) {
            return;
        }
        if (this.highlightedPartitionIndex == -1) {
            this.moveToFirstError();
            return;
        }
        int i = this.highlightedPartitionIndex - 1;
        do {
            String type;
            if (i == -1) {
                i = this.fPartitioner.fPartitions.size() - 1;
            }
            if (!BuildConsolePartition.isProblemPartitionType(type = this.fPartitioner.fPartitions.get(i).getType())) continue;
            this.highlightedPartitionIndex = i;
            return;
        } while (this.highlightedPartitionIndex != --i);
    }

    void moveToFirstError() {
        int i = 0;
        while (i < this.fPartitioner.fPartitions.size()) {
            String type = this.fPartitioner.fPartitions.get(i).getType();
            if (BuildConsolePartition.isProblemPartitionType(type)) {
                this.highlightedPartitionIndex = i;
                return;
            }
            ++i;
        }
        this.highlightedPartitionIndex = -1;
    }

    boolean moveToErrorByOffset(int offset) {
        BuildConsolePartition p = this.fPartitioner.getPartition(offset);
        String type = p.getType();
        if (BuildConsolePartition.isProblemPartitionType(type)) {
            this.highlightedPartitionIndex = this.fPartitioner.fPartitions.indexOf((Object)p);
            return true;
        }
        return false;
    }

    ProblemMarkerInfo getCurrentErrorMarker() {
        BuildConsolePartition p = this.getCurrentPartition();
        if (p != null) {
            return p.getMarker();
        }
        return null;
    }

    BuildConsolePartition getCurrentPartition() {
        if (this.highlightedPartitionIndex >= 0 && this.highlightedPartitionIndex < this.fPartitioner.fPartitions.size()) {
            BuildConsolePartition p = this.fPartitioner.fPartitions.get(this.highlightedPartitionIndex);
            return p;
        }
        return null;
    }

    void clear() {
        this.highlightedPartitionIndex = -1;
    }
}

