/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.implementmethod;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.ImplementMethodData;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.ImplementMethodInputPage;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.ImplementMethodRefactoring;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.Messages;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.MethodToImplementConfig;
import org.eclipse.cdt.internal.ui.refactoring.implementmethod.ParameterNamesInputPage;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;

public class ImplementMethodWizard
extends RefactoringWizard {
    private final ImplementMethodRefactoring refactoring;
    private Map<MethodToImplementConfig, ParameterNamesInputPage> pagesMap = new HashMap<MethodToImplementConfig, ParameterNamesInputPage>();

    public ImplementMethodWizard(ImplementMethodRefactoring refactoring) {
        super((Refactoring)refactoring, 36);
        this.setDefaultPageTitle(Messages.ImplementMethodInputPage_PageTitle);
        this.refactoring = refactoring;
    }

    protected void addUserInputPages() {
        this.addPage((IWizardPage)new ImplementMethodInputPage(this.refactoring.getRefactoringData(), this));
        ImplementMethodData data = this.refactoring.getRefactoringData();
        for (MethodToImplementConfig config : data.getMethodDeclarations()) {
            if (!config.getParaHandler().needsAdditionalArgumentNames()) continue;
            ParameterNamesInputPage page = new ParameterNamesInputPage(config, this);
            this.pagesMap.put(config, page);
            this.addPage((IWizardPage)page);
        }
    }

    public ParameterNamesInputPage getPageForConfig(MethodToImplementConfig config) {
        return this.pagesMap.get(config);
    }

    protected void cancelAndJoinPreviewJobs() {
        boolean isOnePreviewJobRunning = false;
        for (ParameterNamesInputPage parameterNamesInputPage : this.pagesMap.values()) {
            isOnePreviewJobRunning |= parameterNamesInputPage.cancelPreviewJob();
        }
        if (isOnePreviewJobRunning) {
            try {
                this.getContainer().run(false, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        monitor.beginTask(Messages.ImplementMethodRefactoringWizard_CancelingPreviewGeneration, ImplementMethodWizard.this.pagesMap.size() + 1);
                        monitor.worked(1);
                        for (ParameterNamesInputPage parameterNamesInputPage : ImplementMethodWizard.this.pagesMap.values()) {
                            parameterNamesInputPage.joinPreviewJob();
                            monitor.worked(1);
                        }
                        monitor.done();
                    }
                });
            }
            catch (InvocationTargetException e) {
                CUIPlugin.log(e);
            }
            catch (InterruptedException e) {}
        } else {
            for (ParameterNamesInputPage parameterNamesInputPage : this.pagesMap.values()) {
                parameterNamesInputPage.joinPreviewJob();
            }
        }
    }

    public boolean performCancel() {
        this.cancelAndJoinPreviewJobs();
        return super.performCancel();
    }

    public boolean performFinish() {
        this.cancelAndJoinPreviewJobs();
        return super.performFinish();
    }
}

