/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.c.hover;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.cdt.core.dom.ast.IASTFileLocation;
import org.eclipse.cdt.core.dom.ast.IASTMacroExpansionLocation;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IASTNodeLocation;
import org.eclipse.cdt.core.dom.ast.IASTNodeSelector;
import org.eclipse.cdt.core.dom.ast.IASTPreprocessorMacroExpansion;
import org.eclipse.cdt.core.dom.ast.IASTTranslationUnit;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IMacroBinding;
import org.eclipse.cdt.core.dom.rewrite.MacroExpansionExplorer;
import org.eclipse.cdt.core.model.CModelException;
import org.eclipse.cdt.core.model.ICElement;
import org.eclipse.cdt.core.model.ILanguage;
import org.eclipse.cdt.core.model.ITranslationUnit;
import org.eclipse.cdt.core.model.IWorkingCopy;
import org.eclipse.cdt.internal.core.model.ASTCache;
import org.eclipse.cdt.internal.ui.editor.ASTProvider;
import org.eclipse.cdt.internal.ui.text.CHeuristicScanner;
import org.eclipse.cdt.internal.ui.text.c.hover.CHoverMessages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.IWorkingCopyManager;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.Region;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class CMacroExpansionInput {
    final MacroExpansionExplorer fExplorer;
    boolean fStartWithFullExpansion = true;

    private CMacroExpansionInput(MacroExpansionExplorer explorer) {
        Assert.isNotNull((Object)explorer);
        this.fExplorer = explorer;
    }

    public String toString() {
        return this.fExplorer.getFullExpansion().getCodeAfterStep();
    }

    public static CMacroExpansionInput create(IEditorPart editor, IRegion textRegion, boolean force) {
        if (editor == null || !(editor instanceof ITextEditor)) {
            return null;
        }
        IEditorInput editorInput = editor.getEditorInput();
        IWorkingCopyManager manager = CUIPlugin.getDefault().getWorkingCopyManager();
        IWorkingCopy tu = manager.getWorkingCopy(editorInput);
        try {
            if (tu == null || !tu.isConsistent()) {
                return null;
            }
        }
        catch (CModelException exc) {
            return null;
        }
        ExpansionRegionComputer computer = new ExpansionRegionComputer((ITranslationUnit)tu, textRegion, force);
        CMacroExpansionInput.doRunOnAST(computer, (ITranslationUnit)tu, force);
        MacroExpansionExplorer explorer = computer.getMacroExpansionExplorer();
        if (explorer == null) {
            return null;
        }
        CMacroExpansionInput input = new CMacroExpansionInput(explorer);
        return input;
    }

    private static void doRunOnAST(final ASTCache.ASTRunnable runnable, final ITranslationUnit tu, boolean force) {
        Job job = new Job(CHoverMessages.CMacroExpansionInput_jobTitle){

            protected IStatus run(IProgressMonitor monitor) {
                return ASTProvider.getASTProvider().runOnAST((ICElement)tu, ASTProvider.WAIT_ACTIVE_ONLY, monitor, runnable);
            }
        };
        job.setPriority(force ? 10 : 50);
        job.setSystem(true);
        job.setRule(SingletonRule.INSTANCE);
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException exc) {
            job.cancel();
        }
    }

    public static final IRegion expandRegion(IRegion region, IDocument document, int contextLines) {
        try {
            int start = document.getLineOfOffset(region.getOffset());
            start = Math.max(start - contextLines, 0);
            int offset = document.getLineOffset(start);
            CHeuristicScanner scanner = new CHeuristicScanner(document);
            offset = scanner.findNonWhitespaceForward(offset, region.getOffset() + 1);
            int end = document.getLineOfOffset(region.getOffset() + region.getLength());
            end = Math.min(end + contextLines, document.getNumberOfLines() - 1);
            int endOffset = document.getNumberOfLines() > end + 1 ? document.getLineOffset(end + 1) : document.getLineOffset(end) + document.getLineLength(end);
            return new Region(offset, endOffset - offset);
        }
        catch (BadLocationException x) {
            return region;
        }
    }

    private static class ExpansionRegionComputer
    implements ASTCache.ASTRunnable {
        private final Position fTextRegion;
        private final boolean fAllowSelection;
        private IASTNode fEnclosingNode;
        private List<IASTNode> fExpansionNodes = new ArrayList<IASTNode>();
        private MacroExpansionExplorer fExplorer;
        private IRegion fExpansionRegion;

        private ExpansionRegionComputer(ITranslationUnit tUnit, IRegion textRegion, boolean allowSelection) {
            this.fTextRegion = new Position(textRegion.getOffset(), textRegion.getLength());
            this.fAllowSelection = allowSelection;
        }

        public IStatus runOnAST(ILanguage lang, IASTTranslationUnit ast) {
            if (ast != null) {
                IASTName macroName;
                IBinding binding;
                IASTNodeSelector nodeSelector = ast.getNodeSelector(ast.getFilePath());
                IASTName node = nodeSelector.findName(this.fTextRegion.getOffset(), this.fTextRegion.getLength());
                if (node instanceof IASTName && (binding = (macroName = node).getBinding()) instanceof IMacroBinding && !macroName.isDefinition() && macroName.getParent() instanceof IASTPreprocessorMacroExpansion) {
                    this.addExpansionNode((IASTNode)node);
                    this.createMacroExpansionExplorer(ast);
                    return Status.OK_STATUS;
                }
                if (this.fAllowSelection) {
                    boolean macroOccurrence = false;
                    this.fEnclosingNode = nodeSelector.findEnclosingNode(this.fTextRegion.getOffset(), this.fTextRegion.getLength());
                    if (this.fEnclosingNode == null) {
                        this.fEnclosingNode = ast;
                    } else if (this.fEnclosingNode.getParent() instanceof IASTPreprocessorMacroExpansion) {
                        this.fEnclosingNode = this.fEnclosingNode.getParent();
                    }
                    if (this.fEnclosingNode instanceof IASTPreprocessorMacroExpansion) {
                        this.addExpansionNode(this.fEnclosingNode);
                        macroOccurrence = true;
                    } else {
                        IASTNodeLocation[] locations = this.fEnclosingNode.getNodeLocations();
                        int i = 0;
                        while (i < locations.length) {
                            IASTFileLocation fileLocation;
                            IASTNodeLocation location = locations[i];
                            if (location instanceof IASTMacroExpansionLocation && (fileLocation = location.asFileLocation()) != null && ast.getFilePath().equals(fileLocation.getFileName()) && this.fTextRegion.overlapsWith(fileLocation.getNodeOffset(), fileLocation.getNodeLength())) {
                                this.addExpansionNode(nodeSelector.findEnclosingNode(fileLocation.getNodeOffset(), fileLocation.getNodeLength()));
                                macroOccurrence = true;
                            }
                            ++i;
                        }
                    }
                    if (macroOccurrence) {
                        this.createMacroExpansionExplorer(ast);
                        return Status.OK_STATUS;
                    }
                }
            }
            return Status.CANCEL_STATUS;
        }

        private void createMacroExpansionExplorer(IASTTranslationUnit ast) {
            IRegion region = this.getExpansionRegion();
            if (region != null) {
                this.fExplorer = MacroExpansionExplorer.create((IASTTranslationUnit)ast, (IRegion)region);
                this.fExpansionRegion = region;
            }
        }

        private void addExpansionNode(IASTNode node) {
            if (node != null) {
                this.fEnclosingNode = this.computeCommonAncestor(node, this.fEnclosingNode);
                this.fExpansionNodes.add(node);
            }
        }

        private IASTNode computeCommonAncestor(IASTNode node, IASTNode other) {
            if (node == null) {
                return null;
            }
            if (other == null) {
                return node;
            }
            if (node == other) {
                return other;
            }
            ArrayList<IASTNode> ancestors = new ArrayList<IASTNode>();
            while (node != null) {
                node = node.getParent();
                ancestors.add(node);
            }
            while (other != null) {
                if (ancestors.contains(other)) {
                    return other;
                }
                other = other.getParent();
            }
            return null;
        }

        IRegion getExpansionRegion() {
            if (this.fExpansionRegion != null) {
                return this.fExpansionRegion;
            }
            if (this.fEnclosingNode != null) {
                int startOffset = Integer.MAX_VALUE;
                int endOffset = this.fTextRegion.getOffset() + this.fTextRegion.getLength();
                for (IASTNode node : this.fExpansionNodes) {
                    IASTFileLocation location;
                    if (node != this.fEnclosingNode) {
                        while (node != null && node.getParent() != this.fEnclosingNode) {
                            node = node.getParent();
                        }
                    }
                    if (node == null || (location = node.getFileLocation()) == null) continue;
                    startOffset = Math.min(startOffset, location.getNodeOffset());
                    endOffset = Math.max(endOffset, location.getNodeOffset() + location.getNodeLength());
                }
                if (endOffset > startOffset) {
                    startOffset = Math.min(startOffset, this.fTextRegion.getOffset());
                    return new Region(startOffset, endOffset - startOffset);
                }
            }
            return null;
        }

        MacroExpansionExplorer getMacroExpansionExplorer() {
            return this.fExplorer;
        }
    }

    private static class SingletonRule
    implements ISchedulingRule {
        public static final ISchedulingRule INSTANCE = new SingletonRule();

        private SingletonRule() {
        }

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }
    }
}

