/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.text.correction;

import org.eclipse.cdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.cdt.ui.CDTSharedImages;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.cdt.ui.text.ICCompletionProposal;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.IMarkerResolution2;

public class MarkerResolutionProposal
implements ICCompletionProposal {
    private IMarkerResolution fResolution;
    private IMarker fMarker;

    public MarkerResolutionProposal(IMarkerResolution resolution, IMarker marker) {
        this.fResolution = resolution;
        this.fMarker = marker;
    }

    public void apply(IDocument document) {
        this.fResolution.run(this.fMarker);
    }

    public String getAdditionalProposalInfo() {
        if (this.fResolution instanceof IMarkerResolution2) {
            return ((IMarkerResolution2)this.fResolution).getDescription();
        }
        if (this.fResolution instanceof ICCompletionProposal) {
            return ((ICCompletionProposal)this.fResolution).getAdditionalProposalInfo();
        }
        try {
            String problemDesc = (String)this.fMarker.getAttribute("message");
            return NLS.bind((String)CorrectionMessages.MarkerResolutionProposal_additionaldesc, (Object)problemDesc);
        }
        catch (CoreException e) {
            CUIPlugin.log(e);
            return null;
        }
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        return this.fResolution.getLabel();
    }

    public Image getImage() {
        if (this.fResolution instanceof IMarkerResolution2) {
            return ((IMarkerResolution2)this.fResolution).getImage();
        }
        if (this.fResolution instanceof ICCompletionProposal) {
            return ((ICCompletionProposal)this.fResolution).getImage();
        }
        return CDTSharedImages.getImage("icons/obj16/correction_change.gif");
    }

    @Override
    public int getRelevance() {
        if (this.fResolution instanceof ICCompletionProposal) {
            return ((ICCompletionProposal)this.fResolution).getRelevance();
        }
        return 10;
    }

    public Point getSelection(IDocument document) {
        if (this.fResolution instanceof ICCompletionProposal) {
            return ((ICCompletionProposal)this.fResolution).getSelection(document);
        }
        return null;
    }

    @Override
    public String getIdString() {
        return this.getDisplayString();
    }
}

