/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.util;

import java.util.HashSet;
import org.eclipse.cdt.internal.ui.editor.TranslationUnitAnnotationModelEvent;
import org.eclipse.cdt.internal.ui.util.IProblemChangedListener;
import org.eclipse.cdt.internal.ui.util.SWTUtil;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.text.source.AnnotationModelEvent;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IAnnotationModelListenerExtension;
import org.eclipse.swt.widgets.Display;

public class ProblemMarkerManager
implements IResourceChangeListener,
IAnnotationModelListener,
IAnnotationModelListenerExtension {
    ListenerList<IProblemChangedListener> fListeners = new ListenerList();

    public void resourceChanged(IResourceChangeEvent event) {
        HashSet<IResource> changedElements = new HashSet<IResource>();
        try {
            IResourceDelta delta = event.getDelta();
            if (delta != null) {
                delta.accept((IResourceDeltaVisitor)new ProjectErrorVisitor(changedElements));
            }
        }
        catch (CoreException e) {
            CUIPlugin.log(e.getStatus());
        }
        if (!changedElements.isEmpty()) {
            IResource[] changes = changedElements.toArray(new IResource[changedElements.size()]);
            this.fireChanges(changes, true);
        }
    }

    public void modelChanged(IAnnotationModel model) {
    }

    public void modelChanged(AnnotationModelEvent event) {
        IResource res;
        TranslationUnitAnnotationModelEvent cuEvent;
        if (event instanceof TranslationUnitAnnotationModelEvent && (cuEvent = (TranslationUnitAnnotationModelEvent)event).includesProblemMarkerAnnotationChanges() && (res = cuEvent.getUnderlyingResource()) != null) {
            this.fireChanges(new IResource[]{res}, false);
        }
    }

    public void addListener(IProblemChangedListener listener) {
        if (this.fListeners.isEmpty()) {
            CUIPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
            CUIPlugin.getDefault().getDocumentProvider().addGlobalAnnotationModelListener(this);
        }
        this.fListeners.add((Object)listener);
    }

    public void removeListener(IProblemChangedListener listener) {
        this.fListeners.remove((Object)listener);
        if (this.fListeners.isEmpty()) {
            CUIPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
            CUIPlugin.getDefault().getDocumentProvider().removeGlobalAnnotationModelListener(this);
        }
    }

    private void fireChanges(IResource[] changes, boolean markerChanged) {
        Display display = SWTUtil.getStandardDisplay();
        if (display != null && !display.isDisposed()) {
            display.asyncExec(() -> {
                for (IProblemChangedListener curr : this.fListeners) {
                    curr.problemsChanged(changes, markerChanged);
                }
            });
        }
    }

    private static class ProjectErrorVisitor
    implements IResourceDeltaVisitor {
        private HashSet<IResource> fChangedElements;

        public ProjectErrorVisitor(HashSet<IResource> changedElements) {
            this.fChangedElements = changedElements;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IProject project;
            IResource res = delta.getResource();
            if (res instanceof IProject && delta.getKind() == 4 && !(project = (IProject)res).isAccessible()) {
                return false;
            }
            this.checkInvalidate(delta, res);
            return true;
        }

        private void checkInvalidate(IResourceDelta delta, IResource resource) {
            int kind = delta.getKind();
            if (kind == 2 || kind == 1 || kind == 4 && this.isErrorDelta(delta)) {
                while (resource.getType() != 8 && this.fChangedElements.add(resource)) {
                    resource = resource.getParent();
                }
            }
        }

        private boolean isErrorDelta(IResourceDelta delta) {
            if ((delta.getFlags() & 0x20000) != 0) {
                IMarkerDelta[] markerDeltas;
                IMarkerDelta[] iMarkerDeltaArray = markerDeltas = delta.getMarkerDeltas();
                int n = markerDeltas.length;
                int n2 = 0;
                while (n2 < n) {
                    IMarkerDelta markerDelta = iMarkerDeltaArray[n2];
                    if (markerDelta.isSubtypeOf("org.eclipse.core.resources.problemmarker")) {
                        int kind = markerDelta.getKind();
                        if (kind == 1 || kind == 2) {
                            return true;
                        }
                        int severity = markerDelta.getAttribute("severity", -1);
                        int newSeverity = markerDelta.getMarker().getAttribute("severity", -1);
                        if (newSeverity != severity) {
                            return true;
                        }
                    }
                    ++n2;
                }
            }
            return false;
        }
    }
}

