/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.workingsets;

import org.eclipse.cdt.internal.ui.workingsets.IWorkingSetProxy;
import org.eclipse.cdt.internal.ui.workingsets.WorkingSetConfigurationBlock;
import org.eclipse.cdt.internal.ui.workingsets.WorkingSetConfigurationManager;
import org.eclipse.cdt.internal.ui.workingsets.WorkingSetMessages;
import org.eclipse.cdt.internal.ui.workingsets.WorkspaceSnapshot;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.dialogs.PropertyPage;

public class WorkingSetConfigurationsPage
extends PropertyPage {
    private WorkingSetConfigurationBlock block;

    public WorkingSetConfigurationsPage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(5, 5).applyTo(result);
        WorkspaceSnapshot workspace = WorkingSetConfigurationManager.getDefault().createWorkspaceSnapshot();
        final IWorkingSetProxy.ISnapshot workingSet = this.getWorkingSet(workspace);
        if (workingSet == null) {
            new Label(result, 0).setText(WorkingSetMessages.WSetConfigsPage_noProjects);
        } else {
            this.block = new WorkingSetConfigurationBlock(workspace, workingSet);
            this.block.setWorkingSetFilter(new IFilter(){

                public boolean select(Object toTest) {
                    return toTest == workingSet;
                }
            });
            Control contents = this.block.createContents(result);
            contents.setLayoutData((Object)new GridData(4, 4, true, true));
        }
        return result;
    }

    private IWorkingSetProxy.ISnapshot getWorkingSet(WorkspaceSnapshot workspace) {
        IWorkingSetProxy.ISnapshot result = null;
        IWorkingSet realWorkingSet = (IWorkingSet)this.getElement().getAdapter(IWorkingSet.class);
        if (realWorkingSet != null && (result = workspace.getWorkingSet(realWorkingSet.getName())) != null && result.resolveProjects().isEmpty()) {
            result = null;
        }
        return result;
    }

    public boolean performOk() {
        if (!this.block.build()) {
            return false;
        }
        this.block.save();
        return true;
    }
}

