/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.newui;

import org.eclipse.cdt.core.cdtvariables.ICdtVariable;
import org.eclipse.cdt.internal.ui.newui.Messages;
import org.eclipse.core.variables.IStringVariable;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;

public class BuildVarListDialog
extends ElementListSelectionDialog {
    private static final String TYPE = Messages.BuildVarListDialog_0;
    private IStringVariable[] sysVars = VariablesPlugin.getDefault().getStringVariableManager().getVariables();
    private Text text;
    private Label type;
    private static final String LIST_DESCRIPTION = Messages.BuildVarListDialog_11;

    public BuildVarListDialog(Shell parent, Object[] input) {
        super(parent, (ILabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof ICdtVariable) {
                    return ((ICdtVariable)element).getName();
                }
                return super.getText(element);
            }
        });
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.setMessage(Messages.StringVariableSelectionDialog_message);
        this.setMultipleSelection(false);
        this.setElements(input);
    }

    protected Control createDialogArea(Composite container) {
        Composite c = (Composite)super.createDialogArea(container);
        this.type = new Label(c, 0);
        this.type.setFont(container.getFont());
        this.type.setLayoutData((Object)new GridData(768));
        Label desc = new Label(c, 0);
        desc.setFont(c.getFont());
        desc.setText(Messages.StringVariableSelectionDialog_columnDescription);
        desc.setLayoutData((Object)new GridData(768));
        this.text = new Text(c, 2624);
        this.text.setFont(container.getFont());
        this.text.setEditable(false);
        GridData gd = new GridData(768);
        gd.heightHint = 50;
        this.text.setLayoutData((Object)gd);
        if (this.fFilteredList != null) {
            this.fFilteredList.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    e.result = LIST_DESCRIPTION;
                }
            });
        }
        return c;
    }

    protected void handleSelectionChanged() {
        super.handleSelectionChanged();
        Object[] objects = this.getSelectedElements();
        String descr = null;
        if (objects.length == 1) {
            ICdtVariable v = (ICdtVariable)objects[0];
            this.type.setText(TYPE + " " + BuildVarListDialog.typeIntToString(v.getValueType()));
            int i = 0;
            while (i < this.sysVars.length) {
                if (v.getName() == this.sysVars[i].getName()) {
                    descr = this.sysVars[i].getDescription();
                    break;
                }
                ++i;
            }
        }
        if (descr == null) {
            descr = Messages.BuildVarListDialog_10;
        }
        this.text.setText(descr);
    }

    public static String typeIntToString(int type) {
        return switch (type) {
            case 2 -> Messages.BuildVarListDialog_1;
            case 3 -> Messages.BuildVarListDialog_2;
            case 4 -> Messages.BuildVarListDialog_3;
            case 5 -> Messages.BuildVarListDialog_4;
            case 6 -> Messages.BuildVarListDialog_5;
            case 7 -> Messages.BuildVarListDialog_6;
            case 8 -> Messages.BuildVarListDialog_7;
            default -> Messages.BuildVarListDialog_8;
        };
    }
}

