/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.e4.compatibility;

import jakarta.inject.Inject;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.commands.IHandler;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.di.PersistState;
import org.eclipse.e4.ui.internal.workbench.OpaqueElementUtil;
import org.eclipse.e4.ui.internal.workbench.swt.AbstractPartRenderer;
import org.eclipse.e4.ui.model.application.ui.MUIElement;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolBarElement;
import org.eclipse.e4.ui.workbench.modeling.EModelService;
import org.eclipse.e4.ui.workbench.renderers.swt.MenuManagerRenderer;
import org.eclipse.e4.ui.workbench.renderers.swt.ToolBarManagerRenderer;
import org.eclipse.e4.ui.workbench.swt.factories.IRendererFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.ActionDescriptor;
import org.eclipse.ui.internal.IMenuServiceWorkaround;
import org.eclipse.ui.internal.PartSite;
import org.eclipse.ui.internal.PluginAction;
import org.eclipse.ui.internal.ViewActionBuilder;
import org.eclipse.ui.internal.ViewReference;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchPartReference;
import org.eclipse.ui.internal.e4.compatibility.CompatibilityPart;
import org.eclipse.ui.internal.registry.ViewDescriptor;
import org.eclipse.ui.internal.testing.ContributionInfoMessages;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.testing.ContributionInfo;

public class CompatibilityView
extends CompatibilityPart {
    private final ViewReference reference;
    @Inject
    EModelService modelService;

    @Inject
    CompatibilityView(MPart part, ViewReference ref) {
        super(part);
        this.reference = ref;
    }

    public IViewPart getView() {
        return (IViewPart)this.getPart();
    }

    @Override
    public WorkbenchPartReference getReference() {
        return this.reference;
    }

    private MMenu getViewMenu() {
        for (MMenu menu : this.part.getMenus()) {
            if (!menu.getTags().contains("ViewMenu")) continue;
            return menu;
        }
        return null;
    }

    @Override
    protected boolean createPartControl(IWorkbenchPart legacyPart, Composite parent) {
        MToolBar toolbar;
        AbstractPartRenderer apr;
        this.clearMenuItems();
        this.part.getContext().set(IViewPart.class, (Object)((IViewPart)legacyPart));
        final IEclipseContext partContext = this.getModel().getContext();
        IRendererFactory rendererFactory = (IRendererFactory)partContext.get(IRendererFactory.class);
        final IActionBars actionBars = ((IViewPart)legacyPart).getViewSite().getActionBars();
        ToolBarManager tbm = (ToolBarManager)actionBars.getToolBarManager();
        Composite toolBarParent = new Composite(parent, 0);
        tbm.createControl(toolBarParent);
        MenuManager mm = (MenuManager)actionBars.getMenuManager();
        MMenu menu = this.getViewMenu();
        if (menu == null) {
            menu = (MMenu)this.modelService.createModelElement(MMenu.class);
            String partId = this.part.getElementId();
            int colonIndex = partId.indexOf(58);
            String descId = colonIndex == -1 ? partId : partId.substring(0, colonIndex);
            menu.setElementId(descId);
            menu.getTags().add("ViewMenu");
            menu.getTags().add("menuContribution:menu");
            this.part.getMenus().add(menu);
        }
        if ((apr = rendererFactory.getRenderer((MUIElement)menu, (Object)parent)) instanceof MenuManagerRenderer) {
            MenuManagerRenderer renderer = (MenuManagerRenderer)apr;
            renderer.linkModelToManager(menu, mm);
        }
        if ((toolbar = this.part.getToolbar()) == null) {
            toolbar = (MToolBar)this.modelService.createModelElement(MToolBar.class);
            String partId = this.part.getElementId();
            int colonIndex = partId.indexOf(58);
            String descId = colonIndex == -1 ? partId : partId.substring(0, colonIndex);
            toolbar.setElementId(descId);
            this.part.setToolbar(toolbar);
        } else {
            toolbar.getChildren().clear();
        }
        apr = rendererFactory.getRenderer((MUIElement)toolbar, (Object)parent);
        if (apr instanceof ToolBarManagerRenderer) {
            ((ToolBarManagerRenderer)apr).linkModelToManager(toolbar, tbm);
        }
        super.createPartControl(legacyPart, parent);
        ViewDescriptor desc = this.reference.getDescriptor();
        if (desc != null && desc.getPluginId() != null) {
            parent.setData((Object)new ContributionInfo(desc.getPluginId(), ContributionInfoMessages.ContributionInfo_View, null));
        }
        toolBarParent.dispose();
        apr = rendererFactory.getRenderer((MUIElement)menu, (Object)parent);
        if (apr instanceof MenuManagerRenderer) {
            MenuManagerRenderer renderer = (MenuManagerRenderer)apr;
            renderer.reconcileManagerToModel(mm, menu);
        }
        if ((apr = rendererFactory.getRenderer((MUIElement)toolbar, (Object)parent)) instanceof ToolBarManagerRenderer) {
            ((ToolBarManagerRenderer)apr).reconcileManagerToModel((IToolBarManager)tbm, toolbar);
        }
        final AtomicBoolean toolbarContributed = new AtomicBoolean();
        ContextFunction func = new ContextFunction(){

            public Object compute(IEclipseContext context, String contextKey) {
                if (toolbarContributed.getAndSet(true)) {
                    return null;
                }
                ViewActionBuilder actionBuilder = new ViewActionBuilder();
                actionBuilder.readActionExtensions(CompatibilityView.this.getView());
                ActionDescriptor[] actionDescriptors = actionBuilder.getExtendedActions();
                if (actionDescriptors != null) {
                    IHandlerService hs = (IHandlerService)partContext.get(IHandlerService.class);
                    ActionDescriptor[] actionDescriptorArray = actionDescriptors;
                    int n = actionDescriptors.length;
                    int n2 = 0;
                    while (n2 < n) {
                        PluginAction action;
                        ActionDescriptor actionDescriptor = actionDescriptorArray[n2];
                        if (actionDescriptor != null && (action = actionDescriptor.getAction()) != null && action.getActionDefinitionId() != null) {
                            hs.activateHandler(action.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)action));
                        }
                        ++n2;
                    }
                }
                actionBars.updateActionBars();
                Runnable dispose = actionBuilder::dispose;
                return dispose;
            }
        };
        if (toolbar.getWidget() == null) {
            toolbar.getTransientData().put("ToolBarManagerRenderer.postProcess.func", func);
        } else {
            toolbar.getTransientData().put("ToolBarManagerRenderer.postProcess.dispose", func.compute(partContext, null));
        }
        return true;
    }

    @Override
    @PersistState
    void persistState() {
        super.persistState();
        if (!Workbench.getInstance().isClosing()) {
            this.reference.persist();
        }
    }

    public static void clearOpaqueMenuItems(MenuManagerRenderer renderer, MMenu menu) {
        Iterator it = menu.getChildren().iterator();
        while (it.hasNext()) {
            MMenuElement child = (MMenuElement)it.next();
            IContributionItem contribution = renderer.getContribution(child);
            if (contribution != null) {
                renderer.clearModelToContribution(child, contribution);
            }
            if (OpaqueElementUtil.isOpaqueMenuSeparator((MUIElement)child)) {
                OpaqueElementUtil.clearOpaqueItem((MUIElement)child);
                it.remove();
                continue;
            }
            if (OpaqueElementUtil.isOpaqueMenuItem((MUIElement)child)) {
                OpaqueElementUtil.clearOpaqueItem((MUIElement)child);
                it.remove();
                continue;
            }
            if (!(child instanceof MMenu)) continue;
            MMenu submenu = (MMenu)child;
            MenuManager manager = renderer.getManager(submenu);
            if (manager != null) {
                renderer.clearModelToManager(submenu, manager);
            }
            if (OpaqueElementUtil.isOpaqueMenu((MUIElement)child)) {
                it.remove();
            }
            CompatibilityView.clearOpaqueMenuItems(renderer, submenu);
        }
    }

    @Override
    void disposeSite(PartSite site) {
        MToolBar toolbar;
        IEclipseContext context = this.getModel().getContext();
        IRendererFactory rendererFactory = (IRendererFactory)context.get(IRendererFactory.class);
        IActionBars actionBars = site.getActionBars();
        for (MMenu menu : this.part.getMenus()) {
            if (!menu.getTags().contains("ViewMenu")) continue;
            AbstractPartRenderer apr = rendererFactory.getRenderer((MUIElement)menu, null);
            if (!(apr instanceof MenuManagerRenderer)) break;
            MenuManagerRenderer renderer = (MenuManagerRenderer)apr;
            MenuManager mm = (MenuManager)actionBars.getMenuManager();
            renderer.clearModelToManager(menu, mm);
            CompatibilityView.clearOpaqueMenuItems(renderer, menu);
            break;
        }
        if ((toolbar = this.part.getToolbar()) != null) {
            AbstractPartRenderer apr = rendererFactory.getRenderer((MUIElement)toolbar, null);
            if (apr instanceof ToolBarManagerRenderer) {
                ToolBarManagerRenderer tbmr = (ToolBarManagerRenderer)apr;
                ToolBarManager tbm = (ToolBarManager)actionBars.getToolBarManager();
                tbmr.clearModelToManager(toolbar, tbm);
                CompatibilityView.clearOpaqueToolBarItems(tbmr, toolbar);
            }
            toolbar.getTransientData().remove("ToolBarManagerRenderer.postProcess.func");
        }
        CompatibilityView.clearMenuServiceContributions(site, this.part);
        super.disposeSite(site);
    }

    /*
     * WARNING - void declaration
     */
    private static void clearMenuServiceContributions(PartSite site, MPart part) {
        void service;
        IMenuService menuService = site.getService(IMenuService.class);
        if (!(menuService instanceof IMenuServiceWorkaround)) {
            return;
        }
        IMenuServiceWorkaround iMenuServiceWorkaround = (IMenuServiceWorkaround)((Object)menuService);
        service.clearContributions(site, part);
    }

    public static void clearOpaqueToolBarItems(ToolBarManagerRenderer tbmr, MToolBar toolbar) {
        Iterator it = toolbar.getChildren().iterator();
        while (it.hasNext()) {
            MToolBarElement element = (MToolBarElement)it.next();
            IContributionItem contribution = tbmr.getContribution(element);
            if (contribution != null) {
                tbmr.clearModelToContribution(element, contribution);
            }
            if (!OpaqueElementUtil.isOpaqueToolItem((MUIElement)element)) continue;
            OpaqueElementUtil.clearOpaqueItem((MUIElement)element);
            it.remove();
        }
    }
}

