/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.remote.ui.Activator;
import org.eclipse.tracecompass.internal.tmf.remote.ui.messages.RemoteMessages;
import org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.model.RemoteGenerateManifestOperation;
import org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.model.RemoteImportConnectionNodeElement;
import org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.model.RemoteImportProfileElement;
import org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch.model.RemoteImportTracesOperation;
import org.eclipse.tracecompass.internal.tmf.ui.project.operations.NewExperimentOperation;
import org.eclipse.tracecompass.internal.tmf.ui.project.operations.SelectTracesOperation;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.AbstractTracePackageWizardPage;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageFilesElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageLabelProvider;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.TracePackageTraceElement;
import org.eclipse.tracecompass.internal.tmf.ui.project.wizards.tracepkg.importexport.Messages;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfExperimentFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectElement;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfProjectRegistry;
import org.eclipse.tracecompass.tmf.ui.project.model.TmfTraceFolder;
import org.eclipse.tracecompass.tmf.ui.project.model.TraceUtils;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class RemoteFetchLogWizardRemotePage
extends AbstractTracePackageWizardPage {
    private static final String PAGE_NAME = "org.eclipse.tracecompass.internal.tmf.remote.ui.wizards.fetch";
    private static final String ICON_PATH = "icons/elcl16/fetch_log_wiz.gif";
    private static final Image COLLAPSE_ALL_IMAGE = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_ELCL_COLLAPSEALL");
    private static final Image EXPAND_ALL_IMAGE = Activator.getDefault().getImageFromPath("icons/elcl16/expandall.png");
    public static final String DEFAULT_REMOTE_PROJECT_NAME = "Remote";
    private TmfTraceFolder fTmfTraceFolder;
    private RemoteImportProfileElement fProfile;
    private final Set<RemoteImportConnectionNodeElement> fRemoteHosts = new HashSet<RemoteImportConnectionNodeElement>();
    private boolean fOverwriteAll;
    private boolean fIsVisible = false;
    private String fDefaultProjectName = null;
    private CCombo fCombo;
    private Button fCreateExperimentCheckbox;
    private Text fExperimentNameText;
    private List<IProject> fProjects;
    private @Nullable TmfExperimentFolder fExperimentFolderElement;
    private @Nullable String fExperimentName;

    protected RemoteFetchLogWizardRemotePage(String title, IStructuredSelection selection, @Nullable RemoteImportProfileElement profile, @Nullable String experimentName) {
        super(PAGE_NAME, title, null, selection);
        this.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.tracecompass.tmf.remote.ui", (String)ICON_PATH));
        if (selection.getFirstElement() instanceof TmfTraceFolder) {
            this.fTmfTraceFolder = (TmfTraceFolder)selection.getFirstElement();
        }
        if (this.fTmfTraceFolder == null) {
            TmfProjectRegistry.createProject((String)DEFAULT_REMOTE_PROJECT_NAME, null, null);
            this.fDefaultProjectName = DEFAULT_REMOTE_PROJECT_NAME;
        }
        this.fProfile = profile;
        this.fExperimentName = experimentName;
        this.setDescription(RemoteMessages.RemoteFetchLogWizardRemotePage_Description);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        composite.setFont(parent.getFont());
        this.createToolBar(composite);
        this.createElementViewer(composite);
        this.createButtonsGroup(composite);
        this.createProjectGroup(composite);
        this.createOptionGroup(composite);
        this.restoreWidgetValues();
        this.updatePageCompletion();
        this.setControl((Control)composite);
    }

    protected boolean determinePageCompletion() {
        if (this.getElementViewer().getCheckedElements().length <= 0) {
            return false;
        }
        this.validateProject();
        if (this.fExperimentName != null && this.fCreateExperimentCheckbox.getSelection()) {
            String name = this.fExperimentNameText.getText().trim();
            if (name.isEmpty()) {
                this.setMessage(null);
                this.setErrorMessage(RemoteMessages.RemoteFetchLogWizardRemotePage_ErrorEmptyExperimentName);
                return false;
            }
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            if (workspace != null && !workspace.validateName(name, 1).isOK()) {
                this.setMessage(null);
                this.setErrorMessage(NLS.bind((String)RemoteMessages.RemoteFetchLogWizardRemotePage_ErrorExperimentNameInvalid, (Object)name));
                return false;
            }
            TmfExperimentFolder experimentFolder = this.fExperimentFolderElement;
            if (experimentFolder != null) {
                TmfExperimentElement element = experimentFolder.getExperiment(name);
                if (element != null) {
                    this.setMessage(null);
                    this.setErrorMessage(NLS.bind((String)RemoteMessages.RemoteFetchLogWizardRemotePage_ErrorExperimentAlreadyExists, (Object)name));
                    return false;
                }
                IFolder expResource = experimentFolder.getResource();
                IResource res = expResource.findMember(name);
                if (res != null) {
                    this.setMessage(null);
                    this.setErrorMessage(NLS.bind((String)RemoteMessages.RemoteFetchLogWizardRemotePage_ErrorResourceAlreadyExists, (Object)name));
                    return false;
                }
            }
        }
        return true;
    }

    protected void updateWithFilePathSelection() {
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        this.fIsVisible = visible;
        if (visible) {
            this.getContainer().getShell().getDisplay().asyncExec(this::updateViewer);
        } else {
            this.getElementViewer().setInput(null);
        }
    }

    private void createToolBar(Composite parent) {
        ToolBar toolBar = new ToolBar(parent, 256);
        toolBar.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        ToolItem expandAll = new ToolItem(toolBar, 8);
        expandAll.setImage(EXPAND_ALL_IMAGE);
        expandAll.setToolTipText(RemoteMessages.RemoteFetchLogWizardRemotePage_ExpandAll);
        expandAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemoteFetchLogWizardRemotePage.this.getElementViewer().expandAll();
            }
        });
        ToolItem collapseAll = new ToolItem(toolBar, 8);
        collapseAll.setImage(COLLAPSE_ALL_IMAGE);
        collapseAll.setToolTipText(RemoteMessages.RemoteFetchLogWizardRemotePage_CollapseAll);
        collapseAll.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RemoteFetchLogWizardRemotePage.this.getElementViewer().collapseAll();
            }
        });
    }

    protected void createElementViewer(Composite compositeParent) {
        super.createElementViewer(compositeParent);
        CheckboxTreeViewer elementViewer = this.getElementViewer();
        elementViewer.setLabelProvider((IBaseLabelProvider)new TracePackageLabelProvider(){

            public String getText(Object element) {
                if (element instanceof TracePackageTraceElement) {
                    TracePackageElement[] tracePackageElementArray = ((TracePackageTraceElement)element).getChildren();
                    int n = tracePackageElementArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        TracePackageElement files = tracePackageElementArray[n2];
                        if (files instanceof TracePackageFilesElement) {
                            return ((TracePackageFilesElement)files).getFileName();
                        }
                        ++n2;
                    }
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                TracePackageElement[] tracePackageElementArray;
                if (element instanceof TracePackageTraceElement && (tracePackageElementArray = ((TracePackageTraceElement)element).getChildren()).length != 0) {
                    TracePackageElement files = tracePackageElementArray[0];
                    return files.getImage();
                }
                return super.getImage(element);
            }
        });
        elementViewer.setComparator(new ViewerComparator(){

            public int category(Object element) {
                if (element instanceof TracePackageTraceElement) {
                    return 1;
                }
                return 0;
            }
        });
    }

    private void createProjectGroup(Composite parent) {
        if (this.fDefaultProjectName != null) {
            Group projectGroup = new Group(parent, 32);
            projectGroup.setText(RemoteMessages.RemoteFetchLogWizardRemotePage_ImportDialogProjectsGroupName);
            GridLayout layout = new GridLayout(1, true);
            projectGroup.setLayout((Layout)layout);
            projectGroup.setLayoutData((Object)new GridData(768));
            this.fProjects = new ArrayList<IProject>();
            ArrayList<String> projectNames = new ArrayList<String>();
            for (IProject project : TraceUtils.getOpenedTmfProjects()) {
                this.fProjects.add(project);
                projectNames.add(project.getName());
            }
            this.fCombo = new CCombo((Composite)projectGroup, 8);
            this.fCombo.setToolTipText(RemoteMessages.RemoteFetchLogWizardRemotePage_ImportDialogProjectsGroupName);
            this.fCombo.setLayoutData((Object)new GridData(4, 2, true, false, 1, 1));
            this.fCombo.setItems(projectNames.toArray(new String[projectNames.size()]));
            int select = projectNames.indexOf(this.fDefaultProjectName);
            this.fCombo.select(select);
        }
    }

    private void createOptionGroup(Composite parent) {
        if (this.fExperimentName != null) {
            Group comp = new Group(parent, 32);
            comp.setText(RemoteMessages.RemoteFetchLogWizardRemotePage_OptionsGroupName);
            GridLayout layout = new GridLayout(2, false);
            comp.setLayout((Layout)layout);
            GridData data = new GridData(4, 2, true, false);
            comp.setLayoutData((Object)data);
            this.fCreateExperimentCheckbox = new Button((Composite)comp, 32);
            this.fCreateExperimentCheckbox.setFont(comp.getFont());
            this.fCreateExperimentCheckbox.setText(RemoteMessages.RemoteFetchLogWizardRemotePage_CreateExperimentName);
            this.fCreateExperimentCheckbox.setSelection(false);
            data = new GridData(1, 2, false, false);
            this.fCreateExperimentCheckbox.setLayoutData((Object)data);
            this.fExperimentNameText = new Text((Composite)comp, 2048);
            data = new GridData(4, 2, true, false);
            this.fExperimentNameText.setLayoutData((Object)data);
            this.fExperimentNameText.setText(this.fExperimentName);
            this.fExperimentNameText.setEnabled(this.fCreateExperimentCheckbox.getSelection());
            this.fExperimentNameText.addModifyListener(e -> this.updatePageCompletion());
            this.fCreateExperimentCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RemoteFetchLogWizardRemotePage.this.fExperimentNameText.setEnabled(RemoteFetchLogWizardRemotePage.this.fCreateExperimentCheckbox.getSelection());
                    RemoteFetchLogWizardRemotePage.this.updatePageCompletion();
                }
            });
        }
    }

    protected Object createElementViewerInput() {
        RemoteGenerateManifestOperation generateManifestOperation;
        block10: {
            if (this.fProfile == null) {
                return null;
            }
            final List<RemoteImportConnectionNodeElement> remoteHosts = this.fProfile.getConnectionNodeElements();
            if (remoteHosts.isEmpty()) {
                return new Status(4, "org.eclipse.tracecompass.tmf.remote.ui", RemoteMessages.RemoteFetchLogWizardRemotePage_MissingConnectionInformation);
            }
            final IStatus[] status = new IStatus[1];
            try {
                this.getContainer().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)remoteHosts.size());
                        for (RemoteImportConnectionNodeElement remoteHost : remoteHosts) {
                            SubMonitor child = subMonitor.newChild(1);
                            child.setTaskName(MessageFormat.format(RemoteMessages.RemoteFetchLogWizardRemotePage_OpeningConnectionTo, remoteHost.getURI()));
                            status[0] = remoteHost.connect((IProgressMonitor)NonNullUtils.checkNotNull((Object)subMonitor.newChild(1)));
                            if (!status[0].isOK()) {
                                monitor.done();
                                return;
                            }
                            RemoteFetchLogWizardRemotePage.this.fRemoteHosts.add(remoteHost);
                        }
                        monitor.done();
                    }
                });
            }
            catch (InvocationTargetException e) {
                this.handleError(MessageFormat.format(RemoteMessages.RemoteFetchLogWizardRemotePage_ConnectionError, this.fProfile.getText()), e);
                return null;
            }
            catch (InterruptedException e) {
                status[0] = Status.CANCEL_STATUS;
            }
            if (!status[0].isOK()) {
                this.handleErrorStatus(status[0]);
                return null;
            }
            generateManifestOperation = new RemoteGenerateManifestOperation(this.fProfile);
            this.getContainer().run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    monitor.beginTask(Messages.ImportTracePackageWizardPage_ReadingPackage, 10);
                    generateManifestOperation.run(monitor);
                    monitor.done();
                }
            });
            status[0] = generateManifestOperation.getStatus();
            if (status[0].getSeverity() != 4) break block10;
            this.handleErrorStatus(status[0]);
            return null;
        }
        try {
            return generateManifestOperation.getResultElements();
        }
        catch (InvocationTargetException e1) {
            this.handleError(Messages.TracePackageExtractManifestOperation_ErrorReadingManifest, e1);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return null;
    }

    public void setPageData(RemoteImportProfileElement profile, boolean overwriteAll) {
        this.fProfile = profile;
        this.fOverwriteAll = overwriteAll;
    }

    public boolean finish() {
        IStatus status;
        RemoteImportTracesOperation importOperation;
        block9: {
            TmfTraceFolder parentTraceFolder;
            IFolder expFolder;
            IStatus[] operationStatus;
            TmfExperimentFolder root;
            ArrayList traceResources;
            block11: {
                String experimentName;
                IFolder[] experimentFolders;
                block10: {
                    boolean result;
                    if (!this.fIsVisible && !(result = this.updateViewer())) {
                        return false;
                    }
                    result = this.validateProject();
                    if (!result) {
                        return false;
                    }
                    Object[] elements = this.getElementViewer().getCheckedElements();
                    importOperation = new RemoteImportTracesOperation(this.getContainer().getShell(), this.fTmfTraceFolder, elements, this.fOverwriteAll);
                    traceResources = new ArrayList();
                    this.getContainer().run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            importOperation.run(monitor);
                            traceResources.addAll(importOperation.getImportedResources());
                            monitor.done();
                        }
                    });
                    if (this.fExperimentName == null || !this.fCreateExperimentCheckbox.getSelection() || traceResources.isEmpty()) break block9;
                    experimentFolders = new IFolder[1];
                    root = this.fExperimentFolderElement;
                    operationStatus = new IStatus[1];
                    experimentName = this.fExperimentNameText.getText().trim();
                    if (root != null && !experimentName.isEmpty()) break block10;
                    return true;
                }
                this.getContainer().run(true, true, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                        operationStatus[0] = null;
                        NewExperimentOperation operation = new NewExperimentOperation(root, experimentName);
                        operation.run(monitor);
                        monitor.done();
                        operationStatus[0] = operation.getStatus();
                        experimentFolders[0] = operation.getExperimentFolder();
                    }
                });
                expFolder = experimentFolders[0];
                parentTraceFolder = this.fTmfTraceFolder;
                if (expFolder != null && parentTraceFolder != null) break block11;
                return true;
            }
            try {
                if (operationStatus[0] != null && operationStatus[0].isOK()) {
                    this.getContainer().run(true, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            operationStatus[0] = null;
                            SelectTracesOperation operation = new SelectTracesOperation(root, expFolder, parentTraceFolder, traceResources);
                            operation.run(monitor);
                            monitor.done();
                            operationStatus[0] = operation.getStatus();
                        }
                    });
                }
            }
            catch (InvocationTargetException e) {
                this.handleError(Messages.TracePackageExtractManifestOperation_ErrorReadingManifest, e);
                return false;
            }
            catch (InterruptedException e) {
                return false;
            }
        }
        if ((status = importOperation.getStatus()).getSeverity() == 4) {
            this.handleErrorStatus(status);
            return false;
        }
        this.disconnectAllRemoteHosts();
        return true;
    }

    public void cancel() {
        this.disconnectAllRemoteHosts();
    }

    private void disconnectAllRemoteHosts() {
        for (RemoteImportConnectionNodeElement remoteHost : this.fRemoteHosts) {
            remoteHost.disconnect();
        }
    }

    private boolean updateViewer() {
        Object elementViewerInput = this.createElementViewerInput();
        if (elementViewerInput == null) {
            return false;
        }
        CheckboxTreeViewer elementViewer = this.getElementViewer();
        elementViewer.setInput(elementViewerInput);
        elementViewer.expandToLevel(3);
        RemoteFetchLogWizardRemotePage.setAllChecked((CheckboxTreeViewer)elementViewer, (boolean)false, (boolean)true);
        this.updatePageCompletion();
        return true;
    }

    private boolean validateProject() {
        if (this.fCombo != null) {
            int fProjectIndex = this.fCombo.getSelectionIndex();
            if (fProjectIndex < 0) {
                this.handleError(RemoteMessages.RemoteFetchLogWizardRemotePage_NoProjectSelectedError, null);
                return false;
            }
            IProject project = this.fProjects.get(fProjectIndex);
            TmfProjectElement projectElement = TmfProjectRegistry.getProject((IProject)project, (boolean)true);
            TmfTraceFolder tracesFolderElement = projectElement.getTracesFolder();
            if (tracesFolderElement == null) {
                this.handleError(RemoteMessages.RemoteFetchLogWizardRemotePage_InvalidTracingProject, null);
                return false;
            }
            IFolder traceFolder = tracesFolderElement.getResource();
            if (!traceFolder.exists()) {
                this.handleError(RemoteMessages.RemoteFetchLogWizardRemotePage_InvalidTracingProject, null);
                return false;
            }
            try {
                if (project.hasNature("org.eclipse.linuxtools.tmf.project.nature")) {
                    this.fTmfTraceFolder = projectElement.getTracesFolder();
                    this.fExperimentFolderElement = projectElement.getExperimentsFolder();
                }
            }
            catch (CoreException ex) {
                this.handleError(RemoteMessages.RemoteFetchLogWizardRemotePage_InvalidTracingProject, ex);
                return false;
            }
        }
        return true;
    }
}

