/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model;

import java.util.Map;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.DataDrivenAction;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.model.runtime.DataDrivenScenarioInfo;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.module.IAnalysisDataContainer;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.module.pattern.DataDrivenPattern;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;

public final class DataDrivenActionUpdateStoredFields
implements DataDrivenAction {
    private static final DataDrivenAction INSTANCE = new DataDrivenActionUpdateStoredFields();

    public static DataDrivenAction getInstance() {
        return INSTANCE;
    }

    private DataDrivenActionUpdateStoredFields() {
    }

    @Override
    public void eventHandle(ITmfEvent event, DataDrivenScenarioInfo scenarioInfo, IAnalysisDataContainer container) {
        if (container instanceof DataDrivenPattern) {
            DataDrivenPattern patternSp = (DataDrivenPattern)container;
            for (Map.Entry<String, String> entry : patternSp.getStoredFields().entrySet()) {
                ITmfEventField eventField = event.getContent().getField(new String[]{entry.getKey()});
                TmfStateValue stateValue = null;
                if (eventField == null) continue;
                String alias = entry.getValue();
                Object field = eventField.getValue();
                if (field instanceof String) {
                    stateValue = TmfStateValue.newValueString((String)((String)field));
                } else if (field instanceof Long) {
                    stateValue = TmfStateValue.newValueLong((long)((Long)field));
                } else if (field instanceof Integer) {
                    stateValue = TmfStateValue.newValueInt((int)((Integer)field));
                } else if (field instanceof Double) {
                    stateValue = TmfStateValue.newValueDouble((double)((Double)field));
                }
                if (stateValue == null) {
                    throw new IllegalStateException("State value is null. Invalid type.");
                }
                patternSp.getExecutionData().getHistoryBuilder().updateStoredFields(container, alias, (ITmfStateValue)stateValue, scenarioInfo, event);
            }
        }
    }
}

