/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.profiling.launch;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.cdt.core.CCorePlugin;
import org.eclipse.cdt.core.CommandLauncher;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.cdt.utils.spawner.ProcessFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.linuxtools.profiling.launch.IRemoteCommandLauncher;

public class LocalLauncher
implements IRemoteCommandLauncher {
    private CommandLauncher launcher = new CommandLauncher();

    @Override
    public Process execute(IPath commandPath, String[] args, String[] env, IPath changeToDirectory, IProgressMonitor monitor) throws CoreException {
        this.launcher.showCommand(true);
        return this.launcher.execute(commandPath, args, env, changeToDirectory, monitor);
    }

    @Override
    public Process execute(IPath commandPath, String[] args, String[] env, IPath changeToDirectory, IProgressMonitor monitor, PTY pty) {
        String[] mergedCommand = new String[args.length + 1];
        System.arraycopy(args, 0, mergedCommand, 1, args.length);
        mergedCommand[0] = commandPath.toOSString();
        Process p = null;
        try {
            p = ProcessFactory.getFactory().exec(mergedCommand, env, changeToDirectory.toFile(), pty);
        }
        catch (IOException e) {
            CCorePlugin.log((Throwable)e);
        }
        return p;
    }

    @Override
    public int waitAndRead(OutputStream output, OutputStream err, IProgressMonitor monitor) {
        return this.launcher.waitAndRead(output, err, monitor);
    }

    @Override
    public String getErrorMessage() {
        return this.launcher.getErrorMessage();
    }
}

