/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.context.tasks.ui.editors;

import java.util.Collection;
import java.util.List;
import org.eclipse.mylyn.context.core.IInteractionContext;
import org.eclipse.mylyn.context.core.IInteractionContextScaling;
import org.eclipse.mylyn.context.core.IInteractionElement;
import org.eclipse.mylyn.monitor.core.InteractionEvent;
import org.eclipse.mylyn.tasks.core.ITask;

class ContextWrapper
implements IInteractionContext {
    private IInteractionContext wrappedContext;
    private final ITask task;

    public ContextWrapper(IInteractionContext context, ITask task) {
        this.wrappedContext = context;
        this.task = task;
    }

    public boolean isForSameTaskAs(IInteractionContext context) {
        return context != null && this.isForSameTaskAs(context.getHandleIdentifier());
    }

    public boolean isForSameTaskAs(String contextHandle) {
        return contextHandle != null && contextHandle.equals(this.task.getHandleIdentifier());
    }

    public IInteractionContext getWrappedContext() {
        return this.wrappedContext;
    }

    public void setWrappedContext(IInteractionContext wrappedContext) {
        this.wrappedContext = wrappedContext;
    }

    public String getHandleIdentifier() {
        return this.wrappedContext.getHandleIdentifier();
    }

    public List<InteractionEvent> getInteractionHistory() {
        return this.wrappedContext.getInteractionHistory();
    }

    public boolean isInteresting(String elementHandle) {
        return this.wrappedContext.isInteresting(elementHandle);
    }

    public List<IInteractionElement> getInteresting() {
        return this.wrappedContext.getInteresting();
    }

    public List<IInteractionElement> getLandmarks() {
        return this.wrappedContext.getLandmarks();
    }

    public IInteractionElement get(String element) {
        return this.wrappedContext.get(element);
    }

    public IInteractionElement getActiveNode() {
        return this.wrappedContext.getActiveNode();
    }

    public void delete(IInteractionElement element) {
        this.wrappedContext.delete(element);
    }

    public void delete(Collection<IInteractionElement> elements) {
        this.wrappedContext.delete(elements);
    }

    public void updateElementHandle(IInteractionElement element, String newHandle) {
        this.wrappedContext.updateElementHandle(element, newHandle);
    }

    public List<IInteractionElement> getAllElements() {
        return this.wrappedContext.getAllElements();
    }

    public IInteractionContextScaling getScaling() {
        return this.wrappedContext.getScaling();
    }

    public String getContentLimitedTo() {
        return this.wrappedContext.getContentLimitedTo();
    }

    public void setContentLimitedTo(String contentLimitedTo) {
        this.wrappedContext.setContentLimitedTo(contentLimitedTo);
    }
}

