/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.core.internal.validation.errorcustomization;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.validation.errorcustomization.ElementInformation;
import org.eclipse.wst.xml.core.internal.validation.errorcustomization.IErrorMessageCustomizer;
import org.osgi.framework.Bundle;

public class ErrorMessageCustomizerDelegate
implements IErrorMessageCustomizer {
    protected Bundle bundle = null;
    protected String classname = null;
    protected IErrorMessageCustomizer customizer = null;

    public ErrorMessageCustomizerDelegate(Bundle bundle, String classname) {
        this.bundle = bundle;
        this.classname = classname;
    }

    @Override
    public String customizeMessage(ElementInformation elementInfo, String errorKey, Object[] arguments) {
        if (this.customizer == null) {
            this.loadCustomizer();
        }
        if (this.customizer == null) {
            return null;
        }
        return this.customizer.customizeMessage(elementInfo, errorKey, arguments);
    }

    protected void loadCustomizer() {
        try {
            Class customizerClass = this.bundle.loadClass(this.classname);
            this.customizer = (IErrorMessageCustomizer)customizerClass.newInstance();
        }
        catch (Exception e) {
            XMLCorePlugin.getDefault().getLog().log((IStatus)new Status(2, XMLCorePlugin.getDefault().getBundle().getSymbolicName(), 0, "The XML validator error customizer was unable to load class " + this.classname, (Throwable)e));
        }
    }
}

