/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.setup.ui.actions;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.oomph.setup.SetupPackage;
import org.eclipse.oomph.setup.SetupTask;
import org.eclipse.oomph.setup.ui.SetupUIPlugin;
import org.eclipse.oomph.setup.ui.actions.Messages;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class ToggleDisabledAction
implements IObjectActionDelegate {
    private final Set<SetupTask> tasks = new HashSet<SetupTask>();
    private boolean disabled;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.tasks.clear();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)selection;
            for (Object element : ssel) {
                if (!(element instanceof SetupTask)) continue;
                SetupTask task = (SetupTask)element;
                if (this.tasks.isEmpty()) {
                    this.disabled = task.isDisabled();
                } else if (this.disabled != task.isDisabled()) {
                    this.tasks.clear();
                    action.setEnabled(false);
                    action.setChecked(false);
                    return;
                }
                this.tasks.add(task);
            }
        }
        action.setEnabled(!this.tasks.isEmpty());
        action.setImageDescriptor(SetupUIPlugin.INSTANCE.getImageDescriptor(this.disabled ? "checkbox_checked" : "checkbox_unchecked"));
        action.setChecked(this.disabled);
    }

    public void run(IAction action) {
        SetupTask firstTask = this.tasks.iterator().next();
        boolean value = !firstTask.isDisabled();
        EditingDomain editingDomain = AdapterFactoryEditingDomain.getEditingDomainFor((EObject)firstTask);
        CompoundCommand compoundCommand = new CompoundCommand(value ? Messages.ToggleDisabledAction_commandLabel_setDisabled : Messages.ToggleDisabledAction_commandLabel_setEanbled);
        for (SetupTask task : this.tasks) {
            compoundCommand.append(SetCommand.create((EditingDomain)editingDomain, (Object)task, (Object)SetupPackage.Literals.SETUP_TASK__DISABLED, (Object)value));
        }
        editingDomain.getCommandStack().execute((Command)compoundCommand);
    }
}

