/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.validation.internal.MarkerManager;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class ReporterHelper
implements IReporter {
    private IProgressMonitor _monitor;
    private List<IMessage> _list = new LinkedList<IMessage>();

    public ReporterHelper(IProgressMonitor monitor) {
        this._monitor = monitor;
    }

    @Override
    public void addMessage(IValidator origin, IMessage message) {
        this._list.add(message);
    }

    @Override
    public void displaySubtask(IValidator validator, IMessage message) {
        this._monitor.subTask(message.getText(validator.getClass().getClassLoader()));
    }

    @Override
    public List<IMessage> getMessages() {
        return this._list;
    }

    @Override
    public boolean isCancelled() {
        return this._monitor.isCanceled();
    }

    @Override
    public void removeAllMessages(IValidator origin) {
        this._list.clear();
    }

    @Override
    public void removeAllMessages(IValidator origin, Object object) {
        this._list.clear();
    }

    @Override
    public void removeMessageSubset(IValidator validator, Object obj, String groupName) {
        this._list.clear();
    }

    public void makeMarkers() {
        MarkerManager.getDefault().makeMarkers(this._list);
    }
}

