/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.validation.internal;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.wst.validation.internal.InternalValidatorManager;
import org.eclipse.wst.validation.internal.Tracing;
import org.eclipse.wst.validation.internal.ValidationRegistryReader;
import org.eclipse.wst.validation.internal.ValidatorMetaData;
import org.eclipse.wst.validation.internal.core.IFileDelta;
import org.eclipse.wst.validation.internal.operations.IWorkbenchContext;
import org.eclipse.wst.validation.internal.operations.WorkbenchFileDelta;
import org.eclipse.wst.validation.internal.plugin.ValidationPlugin;

public final class FilterUtil {
    private static VMDDeltaVisitor _deltaVisitor = null;
    private static VMDResourceVisitor _resourceVisitor = null;

    private FilterUtil() {
    }

    static Map<ValidatorMetaData, Set<IFileDelta>> wrapInMap(Set<ValidatorMetaData> enabledValidators) {
        HashMap<ValidatorMetaData, Set<IFileDelta>> result = new HashMap<ValidatorMetaData, Set<IFileDelta>>();
        if (enabledValidators == null || enabledValidators.size() == 0) {
            return result;
        }
        for (ValidatorMetaData vmd : enabledValidators) {
            result.put(vmd, null);
        }
        return result;
    }

    static void checkCanceled(IProgressMonitor monitor) throws OperationCanceledException {
        if (monitor == null) {
            return;
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException("");
        }
    }

    private static Set<IFileDelta> getResourceDeltas(Map<ValidatorMetaData, Set<IFileDelta>> enabledValidators, ValidatorMetaData vmd) {
        Set<IFileDelta> fileDeltas = enabledValidators.get(vmd);
        if (fileDeltas == null) {
            fileDeltas = new HashSet<IFileDelta>();
            enabledValidators.put(vmd, fileDeltas);
        }
        return fileDeltas;
    }

    private static int getResourceDeltaType(int ifileDeltaType) {
        switch (ifileDeltaType) {
            case 1: {
                return 1;
            }
            case 3: {
                return 2;
            }
        }
        return 4;
    }

    static int getFileDeltaType(int iresourceDeltaType) {
        switch (iresourceDeltaType) {
            case 1: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 8: {
                return 1;
            }
            case 16: {
                return 3;
            }
        }
        return 2;
    }

    static void addFileDelta(Map<ValidatorMetaData, Set<IFileDelta>> enabledValidators, ValidatorMetaData vmd, WorkbenchFileDelta fileDelta) {
        Set<IFileDelta> fileDeltas = FilterUtil.getResourceDeltas(enabledValidators, vmd);
        fileDeltas.add(fileDelta);
        enabledValidators.put(vmd, fileDeltas);
    }

    public static Map<ValidatorMetaData, Set<IFileDelta>> getFileDeltas(Set<ValidatorMetaData> enabledValidators, Object[] changedResources, boolean filterIn) {
        return FilterUtil.getFileDeltas(enabledValidators, changedResources, 2, filterIn);
    }

    public static Map<ValidatorMetaData, Set<IFileDelta>> getFileDeltas(Set<ValidatorMetaData> enabledValidators, Object[] changedResources, int ifileDeltaType) {
        return FilterUtil.getFileDeltas(enabledValidators, changedResources, ifileDeltaType, false);
    }

    public static Map<ValidatorMetaData, Set<IFileDelta>> getFileDeltas(Set<ValidatorMetaData> enabledValidators, Object[] changedResources, int ifileDeltaType, boolean force) {
        HashMap<ValidatorMetaData, Set<IFileDelta>> result = new HashMap<ValidatorMetaData, Set<IFileDelta>>();
        if (enabledValidators == null || enabledValidators.size() == 0) {
            return result;
        }
        boolean cannotLoad = false;
        IWorkbenchContext helper = null;
        for (ValidatorMetaData vmd : enabledValidators) {
            try {
                HashSet<WorkbenchFileDelta> deltas = new HashSet<WorkbenchFileDelta>();
                NullProgressMonitor monitor = new NullProgressMonitor();
                int i = 0;
                while (i < changedResources.length) {
                    Object obj = changedResources[i];
                    WorkbenchFileDelta wfd = null;
                    if (obj instanceof IResource) {
                        IResource res = (IResource)obj;
                        if (force || !FilterUtil.filterOut((IProgressMonitor)monitor, vmd, res, FilterUtil.getResourceDeltaType(ifileDeltaType))) {
                            helper = vmd.getHelper(res.getProject());
                            wfd = FilterUtil.getFileDelta(helper, vmd, res, FilterUtil.getResourceDeltaType(ifileDeltaType));
                        }
                    } else {
                        wfd = new WorkbenchFileDelta(obj);
                    }
                    if (wfd != null) {
                        deltas.add(wfd);
                    }
                    ++i;
                }
                result.put(vmd, deltas);
            }
            catch (InstantiationException e) {
                cannotLoad = true;
                ValidationRegistryReader.getReader().disableValidator(vmd);
                ValidationPlugin.getPlugin().handleException(e);
            }
        }
        if (cannotLoad) {
            Object[] vmds = enabledValidators.toArray();
            int i = 0;
            while (i < vmds.length) {
                ValidatorMetaData vmd = (ValidatorMetaData)vmds[i];
                if (vmd.cannotLoad()) {
                    result.remove(vmd);
                }
                ++i;
            }
        }
        return result;
    }

    public static WorkbenchFileDelta getFileDelta(IWorkbenchContext helper, ValidatorMetaData vmd, IResource resource, int iresourceDeltaType) {
        String fileName = helper.getPortableName(resource);
        if (fileName == null) {
            IPath resourcePath = resource.getFullPath();
            if (resourcePath != null) {
                fileName = resourcePath.toString();
            } else {
                ValidationPlugin.getPlugin().logMessage(4, "portableName is null and path is null for resource " + String.valueOf(resource));
                return null;
            }
        }
        int ifileDeltaType = FilterUtil.getFileDeltaType(iresourceDeltaType);
        return new WorkbenchFileDelta(fileName, ifileDeltaType, resource);
    }

    static boolean addToFileList(Map<ValidatorMetaData, Set<IFileDelta>> enabledValidators, IWorkbenchContext helper, ValidatorMetaData vmd, IResource resource, int resourceDelta, boolean isFullBuild) {
        if (vmd == null || resource == null) {
            return false;
        }
        try {
            helper.registerResource(resource);
        }
        catch (Exception exc) {
            ValidationPlugin.getPlugin().handleException(exc);
            InternalValidatorManager.getManager().addInternalErrorTask(resource.getProject(), vmd, exc);
        }
        if (isFullBuild) {
            return true;
        }
        WorkbenchFileDelta newFileDelta = FilterUtil.getFileDelta(helper, vmd, resource, resourceDelta);
        if (newFileDelta != null) {
            FilterUtil.addFileDelta(enabledValidators, vmd, newFileDelta);
        }
        return true;
    }

    static boolean filterOut(IProgressMonitor monitor, ValidatorMetaData vmd, IResource resource, int resourceDelta) {
        if (monitor == null) {
            return false;
        }
        FilterUtil.checkCanceled(monitor);
        return !vmd.isApplicableTo(resource, resourceDelta);
    }

    static void filterOut(IProgressMonitor monitor, Map<ValidatorMetaData, Set<IFileDelta>> enabledValidators, IResource resource, int resourceDelta, boolean isFullBuild) {
        if (monitor == null) {
            return;
        }
        FilterUtil.checkCanceled(monitor);
        boolean cannotLoad = false;
        for (ValidatorMetaData vmd : enabledValidators.keySet()) {
            FilterUtil.checkCanceled(monitor);
            if (FilterUtil.filterOut(monitor, vmd, resource, resourceDelta)) continue;
            try {
                IWorkbenchContext helper = vmd.getHelper(resource.getProject());
                FilterUtil.addToFileList(enabledValidators, helper, vmd, resource, resourceDelta, isFullBuild);
            }
            catch (InstantiationException e) {
                cannotLoad = true;
                ValidationRegistryReader.getReader().disableValidator(vmd);
                ValidationPlugin.getPlugin().handleException(e);
            }
        }
        if (cannotLoad) {
            Object[] vmds = enabledValidators.keySet().toArray();
            int i = 0;
            while (i < vmds.length) {
                ValidatorMetaData vmd = (ValidatorMetaData)vmds[i];
                if (vmd.cannotLoad()) {
                    enabledValidators.remove(vmd);
                }
                ++i;
            }
        }
    }

    static void filterOut(IProgressMonitor monitor, Map<ValidatorMetaData, Set<IFileDelta>> enabledValidators, IResource resource, IResourceDelta delta) {
        if (FilterUtil.filterOut(delta)) {
            return;
        }
        FilterUtil.filterOut(monitor, enabledValidators, resource, delta.getKind(), false);
    }

    static boolean filterOut(IResourceDelta delta) {
        if (delta == null) {
            return true;
        }
        switch (delta.getKind()) {
            case 1: {
                return false;
            }
            case 2: {
                return delta.getResource() instanceof IProject;
            }
            case 4: {
                if (!(delta.getResource() instanceof IFile) || (delta.getFlags() & 0x100) == 0) break;
                return false;
            }
        }
        return true;
    }

    static boolean shouldProcess(IResource resource, IResourceDelta delta) {
        if (resource != null && !(resource instanceof IProject)) {
            return true;
        }
        if (delta == null) {
            return false;
        }
        switch (delta.getKind()) {
            case 1: {
                if ((delta.getFlags() & 0x1000) == 0) break;
                return false;
            }
            case 2: {
                return false;
            }
            case 4: {
                if ((delta.getFlags() & 0x4000) != 0) {
                    return false;
                }
                if ((delta.getFlags() & 0x40000) == 0) break;
                return false;
            }
        }
        return true;
    }

    private static VMDResourceVisitor getResourceVisitor(IProgressMonitor monitor, Set<ValidatorMetaData> enabledValidators) {
        if (_resourceVisitor == null) {
            _resourceVisitor = new VMDResourceVisitor(){
                private Map<ValidatorMetaData, Set<IFileDelta>> _vmdDeltas = null;
                private IProgressMonitor _progressMonitor = null;

                @Override
                public Map<ValidatorMetaData, Set<IFileDelta>> getResult() {
                    return this._vmdDeltas;
                }

                @Override
                public void setEnabledValidators(Set<ValidatorMetaData> validators) {
                    this._vmdDeltas = FilterUtil.wrapInMap(validators);
                }

                @Override
                public IProgressMonitor getProgressMonitor() {
                    return this._progressMonitor;
                }

                @Override
                public void setProgressMonitor(IProgressMonitor m) {
                    this._progressMonitor = m;
                }

                public boolean visit(IResource res) throws CoreException {
                    FilterUtil.checkCanceled(this.getProgressMonitor());
                    FilterUtil.filterOut(this.getProgressMonitor(), this._vmdDeltas, res, 4, true);
                    return true;
                }
            };
        }
        _resourceVisitor.setProgressMonitor(monitor);
        _resourceVisitor.setEnabledValidators(enabledValidators);
        return _resourceVisitor;
    }

    private static VMDDeltaVisitor getDeltaVisitor(IProgressMonitor monitor, Set<ValidatorMetaData> enabledValidators) {
        if (_deltaVisitor == null) {
            _deltaVisitor = new VMDDeltaVisitor(){
                private Map<ValidatorMetaData, Set<IFileDelta>> _vmdDeltas = null;
                private IProgressMonitor _progressMonitor = null;

                @Override
                public Map<ValidatorMetaData, Set<IFileDelta>> getResult() {
                    return this._vmdDeltas;
                }

                @Override
                public void setEnabledValidators(Set<ValidatorMetaData> validators) {
                    this._vmdDeltas = FilterUtil.wrapInMap(validators);
                }

                @Override
                public IProgressMonitor getProgressMonitor() {
                    return this._progressMonitor;
                }

                @Override
                public void setProgressMonitor(IProgressMonitor m) {
                    this._progressMonitor = m;
                }

                public boolean visit(IResourceDelta subdelta) throws CoreException {
                    FilterUtil.checkCanceled(this.getProgressMonitor());
                    if (subdelta == null) {
                        return true;
                    }
                    IResource resource = subdelta.getResource();
                    if (Tracing.isLogging(2)) {
                        StringBuffer buffer = new StringBuffer("FilterUtil-01: subdelta of ");
                        buffer.append(resource.getName());
                        buffer.append(" has resource delta kind: ");
                        buffer.append(subdelta.getKind());
                        buffer.append(" Does the resource exist? ");
                        buffer.append(resource.exists());
                        buffer.append(" Is it a phantom? ");
                        buffer.append(resource.isPhantom());
                        Tracing.log(buffer);
                    }
                    if (FilterUtil.shouldProcess(resource, subdelta)) {
                        FilterUtil.filterOut(this.getProgressMonitor(), this._vmdDeltas, resource, subdelta);
                        return true;
                    }
                    return false;
                }
            };
        }
        _deltaVisitor.setProgressMonitor(monitor);
        _deltaVisitor.setEnabledValidators(enabledValidators);
        return _deltaVisitor;
    }

    public static Map<ValidatorMetaData, Set<IFileDelta>> loadDeltas(IProgressMonitor monitor, Set<ValidatorMetaData> enabledValidators, IResourceDelta delta) throws CoreException {
        VMDDeltaVisitor visitor = FilterUtil.getDeltaVisitor(monitor, enabledValidators);
        delta.accept((IResourceDeltaVisitor)visitor, true);
        return visitor.getResult();
    }

    public static Map<ValidatorMetaData, Set<IFileDelta>> loadDeltas(IProgressMonitor monitor, Set<ValidatorMetaData> enabledValidators, IProject project) throws CoreException {
        VMDResourceVisitor visitor = FilterUtil.getResourceVisitor(monitor, enabledValidators);
        project.accept((IResourceVisitor)visitor, 2, true);
        return visitor.getResult();
    }

    private static interface VMDDeltaVisitor
    extends VMDRecorder,
    IResourceDeltaVisitor {
    }

    private static interface VMDRecorder {
        public Map<ValidatorMetaData, Set<IFileDelta>> getResult();

        public void setEnabledValidators(Set<ValidatorMetaData> var1);

        public void setProgressMonitor(IProgressMonitor var1);

        public IProgressMonitor getProgressMonitor();
    }

    private static interface VMDResourceVisitor
    extends VMDRecorder,
    IResourceVisitor {
    }
}

