/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.debug.internal.ui.preferences;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;

public final class StringSetSerializer {
    private static final String DELIM = "\u0000";

    private StringSetSerializer() {
    }

    public static String serialize(Set<String> strings) {
        Assert.isLegal((strings != null ? 1 : 0) != 0);
        StringBuilder buf = new StringBuilder(strings.size() * 20);
        Iterator<String> it = strings.iterator();
        while (it.hasNext()) {
            buf.append(it.next());
            if (!it.hasNext()) continue;
            buf.append(DELIM);
        }
        return buf.toString();
    }

    public static Set<String> deserialize(String serialized) {
        Assert.isLegal((serialized != null ? 1 : 0) != 0);
        HashSet<String> marked = new HashSet<String>();
        StringTokenizer tok = new StringTokenizer(serialized, DELIM);
        while (tok.hasMoreTokens()) {
            marked.add(tok.nextToken());
        }
        return marked;
    }

    public static String[] getDifference(String oldValue, String newValue) {
        Set<String> oldSet = StringSetSerializer.deserialize(oldValue);
        Set<String> newSet = StringSetSerializer.deserialize(newValue);
        HashSet<String> intersection = new HashSet<String>(oldSet);
        intersection.retainAll(newSet);
        oldSet.removeAll(intersection);
        newSet.removeAll(intersection);
        oldSet.addAll(newSet);
        return oldSet.toArray(new String[oldSet.size()]);
    }
}

